/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.text.JTextComponent;

class TextComponentPainter
extends SyntheticaComponentPainter {
    TextComponentPainter() {
    }

    protected void paintBackground(String type, SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean keyExists;
        boolean innerBorderIsDefault;
        boolean multiLine;
        JTextComponent tc = (JTextComponent)sc.getComponent();
        Color background = tc.getBackground();
        boolean defaultBackground = background == null || background instanceof ColorUIResource;
        boolean keepLockedBorderIfColored = SyntheticaLookAndFeel.getBoolean("Synthetica." + type + ".keepLockedBorderIfColored", tc);
        boolean keepDisabledBorderIfColored = SyntheticaLookAndFeel.getBoolean("Synthetica." + type + ".keepDisabledBorderIfColored", tc);
        boolean noBorderIfColored = SyntheticaLookAndFeel.getBoolean("Synthetica." + type + ".noBorderIfColored", tc);
        boolean opaque = SyntheticaLookAndFeel.isOpaque(tc);
        boolean locked = !tc.isEditable();
        boolean inScrollPane = tc.getParent() instanceof JViewport;
        boolean bl = multiLine = "textArea".equals(type) || "textPane".equals(type) || "editorPane".equals(type);
        if (!opaque || multiLine && inScrollPane) {
            return;
        }
        if (defaultBackground) {
            if (locked) {
                background = SyntheticaLookAndFeel.getColor("Synthetica." + type + ".locked.backgroundColor", tc);
                if (background == null) {
                    background = SyntheticaLookAndFeel.getColor("Synthetica." + type + ".lockedColor", tc);
                }
                if (background == null) {
                    if (tc.isEnabled() && SyntheticaLookAndFeel.getClientProperty("Synthetica.MOUSE_OVER", tc, false).booleanValue()) {
                        sc = new SynthContext(tc, sc.getRegion(), sc.getStyle(), sc.getComponentState() | 2);
                    }
                    background = sc.getStyle().getColor(sc, ColorType.BACKGROUND);
                }
            } else {
                if (tc.isEnabled() && SyntheticaLookAndFeel.getClientProperty("Synthetica.MOUSE_OVER", tc, false).booleanValue()) {
                    sc = new SynthContext(tc, sc.getRegion(), sc.getStyle(), sc.getComponentState() | 2);
                }
                background = sc.getStyle().getColor(sc, ColorType.BACKGROUND);
            }
        }
        SyntheticaPainterState state = new SyntheticaPainterState(sc);
        UIKey key = new UIKey(type, state);
        Boolean fillBackground = (Boolean)SyntheticaLookAndFeel.get(key.get("fillBackground"), tc);
        Border border = tc.getBorder();
        Border defaultBorder = SyntheticaLookAndFeel.findDefaultBorder(border);
        boolean defaultBorderIsSynth = defaultBorder == null ? false : defaultBorder.getClass().getName().equals("javax.swing.plaf.synth.SynthBorder");
        boolean bl2 = innerBorderIsDefault = border instanceof CompoundBorder && ((CompoundBorder)border).getInsideBorder() == defaultBorder;
        if (innerBorderIsDefault) {
            Insets ins = border.getBorderInsets(tc);
            Insets ins_ = defaultBorder.getBorderInsets(tc);
            x += ins.left - ins_.left;
            y += ins.top - ins_.top;
            w -= ins.left - ins_.left + ins.right - ins_.right;
            h -= ins.top - ins_.top + ins.bottom - ins_.bottom;
        }
        if (fillBackground == null || fillBackground.booleanValue()) {
            this.fillBackground(tc, type, border, defaultBorder, defaultBorderIsSynth, multiLine, g, background, x, y, w, h);
        }
        if (!defaultBackground && noBorderIfColored) {
            return;
        }
        if (!(defaultBackground || keepLockedBorderIfColored && keepDisabledBorderIfColored || !multiLine)) {
            return;
        }
        SyntheticaState state_ = new SyntheticaState(state.getState());
        if (!defaultBackground && !keepLockedBorderIfColored) {
            state_.resetState(SyntheticaState.State.LOCKED);
        }
        if (!defaultBackground && !keepDisabledBorderIfColored) {
            state_.resetState(SyntheticaState.State.DISABLED);
        }
        boolean bl3 = keyExists = SyntheticaLookAndFeel.get((key = this.getUIKey(tc, type, state_)).get(), tc) != null;
        if (locked && !keyExists) {
            state_.resetState(SyntheticaState.State.LOCKED);
            key = this.getUIKey(tc, type, state_);
        }
        String imagePath = key.resolveImagePath(sc, 1);
        if (tc.hasFocus() && this.resolveImagePath(String.valueOf(key.get()) + ".focused", tc) != null) {
            imagePath = this.resolveImagePath(String.valueOf(key.get()) + ".focused", tc);
        }
        Insets sInsets = this.getImageInsets("Synthetica." + type + ".border.insets", tc);
        Insets dInsets = this.getImageInsets("Synthetica." + type + ".border.dInsets", tc, sInsets);
        Insets insets = tc.getInsets();
        if (!defaultBorderIsSynth) {
            x += insets.left;
            y += insets.top;
            w += -insets.left - insets.right;
            h += -insets.top - insets.bottom;
            dInsets = new Insets(0, 0, 0, 0);
        } else if (multiLine) {
            dInsets = new Insets(0, 0, 0, 0);
        }
        ImagePainter imagePainter = new ImagePainter(tc, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        if (!(defaultBackground || keepLockedBorderIfColored && keepDisabledBorderIfColored)) {
            imagePainter.drawBorder();
        } else if (multiLine) {
            imagePainter.drawCenter();
        } else {
            imagePainter.draw();
        }
    }

    protected void paintBorder(String type, SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JComponent c = sc.getComponent();
        if (!(c instanceof JTextComponent)) {
            UIKey key = this.getUIKey(c, type, new SyntheticaState());
            String imagePath = key.resolveImagePath(sc, 1);
            Insets sInsets = this.getImageInsets("Synthetica." + type + ".border.insets", c);
            Insets dInsets = this.getImageInsets("Synthetica." + type + ".border.dInsets", c, sInsets);
            ImagePainter imagePainter = new ImagePainter(c, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.drawBorder();
        }
        boolean textComponentsFocusEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.focus.textComponents.enabled", c, true);
        if (c.hasFocus() && textComponentsFocusEnabled) {
            FocusPainter.paintFocus("focus." + type, sc, g, x, y, w, h);
        }
    }

    protected UIKey getUIKey(JComponent c, String type, SyntheticaState state) {
        return new UIKey(String.valueOf(type) + ".border", state);
    }

    private void fillBackground(JTextComponent tc, String type, Border border, Border defaultBorder, boolean defaultBorderIsSynth, boolean multiLine, Graphics g, Color background, int x, int y, int w, int h) {
        Color color = g.getColor();
        g.setColor(background);
        Insets insets = tc.getInsets();
        if (multiLine || border == null || insets.equals(new Insets(0, 0, 0, 0))) {
            g.fillRect(x, y, w, h);
        } else if (!defaultBorderIsSynth) {
            g.fillRect(x + insets.left, y + insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
        } else {
            Insets fillInsets = SyntheticaLookAndFeel.getInsets("Synthetica." + type + ".border.fillInsets", (Component)tc, false, true);
            int arcWidth = SyntheticaLookAndFeel.getInt("Synthetica." + type + ".border.arcWidth", tc, 8, true);
            int arcHeight = SyntheticaLookAndFeel.getInt("Synthetica." + type + ".border.arcHeight", tc, 8, true);
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.fillRoundRect(x + fillInsets.left, y + fillInsets.top, w - fillInsets.left - fillInsets.right, h - fillInsets.top - fillInsets.bottom, arcWidth, arcHeight);
            g2.setRenderingHints(rh);
        }
        g.setColor(color);
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        JComponent c = sc.getComponent();
        int hash = super.getCacheHash(sc, w, h, meta, id);
        if (c instanceof JTextComponent) {
            JTextComponent tc = (JTextComponent)c;
            boolean locked = !tc.isEditable();
            hash = 31 * hash + (locked ? 0 : 1);
        }
        return hash;
    }
}

