/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import de.javasoft.plaf.synthetica.painter.ArrowButtonPainter;
import de.javasoft.plaf.synthetica.painter.ButtonPainter;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.CheckBoxPainter;
import de.javasoft.plaf.synthetica.painter.ComboBoxPainter;
import de.javasoft.plaf.synthetica.painter.DesktopPanePainter;
import de.javasoft.plaf.synthetica.painter.EditorPanePainter;
import de.javasoft.plaf.synthetica.painter.FormattedTextFieldPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.InternalFramePainter;
import de.javasoft.plaf.synthetica.painter.LabelPainter;
import de.javasoft.plaf.synthetica.painter.ListPainter;
import de.javasoft.plaf.synthetica.painter.MenuPainter;
import de.javasoft.plaf.synthetica.painter.OptionPanePainter;
import de.javasoft.plaf.synthetica.painter.PanelPainter;
import de.javasoft.plaf.synthetica.painter.PasswordFieldPainter;
import de.javasoft.plaf.synthetica.painter.ProgressBarPainter;
import de.javasoft.plaf.synthetica.painter.RadioButtonPainter;
import de.javasoft.plaf.synthetica.painter.RootPanePainter;
import de.javasoft.plaf.synthetica.painter.ScrollBarPainter;
import de.javasoft.plaf.synthetica.painter.ScrollPanePainter;
import de.javasoft.plaf.synthetica.painter.SeparatorPainter;
import de.javasoft.plaf.synthetica.painter.SliderPainter;
import de.javasoft.plaf.synthetica.painter.SpinnerPainter;
import de.javasoft.plaf.synthetica.painter.SplitPanePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaSoftCache;
import de.javasoft.plaf.synthetica.painter.TabbedPanePainter;
import de.javasoft.plaf.synthetica.painter.TablePainter;
import de.javasoft.plaf.synthetica.painter.TextAreaPainter;
import de.javasoft.plaf.synthetica.painter.TextFieldPainter;
import de.javasoft.plaf.synthetica.painter.TextPanePainter;
import de.javasoft.plaf.synthetica.painter.ToggleButtonPainter;
import de.javasoft.plaf.synthetica.painter.ToolBarPainter;
import de.javasoft.plaf.synthetica.painter.ToolTipPainter;
import de.javasoft.plaf.synthetica.painter.TreePainter;
import de.javasoft.plaf.synthetica.painter.ViewportPainter;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.VolatileImage;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

public class SyntheticaPainter
extends SynthPainter {
    private static SynthPainter instance;

    public SyntheticaPainter() {
        if (instance == null) {
            instance = this;
        }
    }

    public static SynthPainter getInstance() {
        if (instance == null) {
            instance = new SyntheticaPainter();
        }
        return instance;
    }

    public static void clearCache() {
        SyntheticaSoftCache.getInstance().clear();
    }

    private boolean paintCachedImage(SynthContext sc, Graphics g, int x, int y, int w, int h, int meta, SyntheticaComponentPainter scp, String method, Class<?> ... parameterTypes) {
        VolatileImage buffer;
        int hash = 0;
        Cacheable.ScaleType scaleType = scp.getCacheScaleType(method);
        if (!UIManager.getBoolean("Synthetica.cache.enabled") || (hash = scp.getCacheHash(sc, w, h, meta, method)) == -1 || scaleType != Cacheable.ScaleType.NINE_SQUARE && !SyntheticaSoftCache.getInstance().isCacheable(w, h)) {
            return false;
        }
        Insets scaleInsets = null;
        int w_ = w;
        int h_ = h;
        if (scaleType == Cacheable.ScaleType.NINE_SQUARE) {
            scaleInsets = scp.getCacheScaleInsets(sc, method);
            w_ = scaleInsets.left + scaleInsets.right + SyntheticaLookAndFeel.getInstance().scaleInteger(24);
            h_ = scaleInsets.top + scaleInsets.bottom + SyntheticaLookAndFeel.getInstance().scaleInteger(24);
        }
        if ((buffer = this.getCachedImage(hash, sc, g, w_, h_, meta, scp, method, parameterTypes)) == null) {
            return false;
        }
        if (scaleType == Cacheable.ScaleType.NONE) {
            return g.drawImage(buffer, x, y, null);
        }
        if (scaleType == Cacheable.ScaleType.NINE_SQUARE) {
            ImagePainter ip = new ImagePainter(buffer, g, x, y, w, h, scaleInsets, scaleInsets, false);
            if (method.endsWith("Border")) {
                ip.drawBorder();
            } else {
                ip.draw();
            }
            return true;
        }
        return false;
    }

    private VolatileImage getCachedImage(int hash, SynthContext sc, Graphics g, int w, int h, int meta, SyntheticaComponentPainter scp, String method, Class<?> ... parameterTypes) {
        GraphicsConfiguration gc = ((Graphics2D)g).getDeviceConfiguration();
        if (gc.getDevice().getType() == 1) {
            return null;
        }
        hash = 31 * hash + gc.hashCode();
        SyntheticaSoftCache imageCache = SyntheticaSoftCache.getInstance();
        VolatileImage image = (VolatileImage)imageCache.getImage(hash);
        do {
            int bufferStatus;
            int n = bufferStatus = image == null ? 2 : image.validate(gc);
            if (bufferStatus != 2 && bufferStatus != 1) continue;
            if (bufferStatus == 2 || image.getWidth() != w || image.getHeight() != h) {
                if (image != null) {
                    image.flush();
                    image = null;
                }
                image = gc.createCompatibleVolatileImage(w, h, 3);
                imageCache.setImage(image, hash);
            }
            Graphics2D g2 = image.createGraphics();
            g2.setComposite(AlphaComposite.Clear);
            g2.fillRect(0, 0, w, h);
            g2.setComposite(AlphaComposite.SrcOver);
            try {
                try {
                    Method m = scp.getClass().getMethod(method, parameterTypes);
                    if (meta == -1) {
                        m.invoke((Object)scp, sc, g2, 0, 0, w, h);
                    } else {
                        m.invoke((Object)scp, sc, g2, 0, 0, w, h, meta);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                g2.dispose();
            }
        } while (image.contentsLost());
        return image;
    }

    @Override
    public void paintArrowButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ArrowButtonPainter.getInstance(sc), "paintArrowButtonBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ArrowButtonPainter.getInstance(sc).paintArrowButtonBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintArrowButtonBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ArrowButtonPainter.getInstance(sc), "paintArrowButtonBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ArrowButtonPainter.getInstance(sc).paintArrowButtonBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintArrowButtonForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int direction) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, direction, ArrowButtonPainter.getInstance(sc), "paintArrowButtonForeground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ArrowButtonPainter.getInstance(sc).paintArrowButtonForeground(sc, g, x, y, w, h, direction);
        }
    }

    @Override
    public void paintButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ButtonPainter.getInstance(sc), "paintButtonBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ButtonPainter.getInstance(sc).paintButtonBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintButtonBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ButtonPainter.getInstance(sc), "paintButtonBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ButtonPainter.getInstance(sc).paintButtonBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintCheckBoxBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        CheckBoxPainter.getInstance(sc).paintCheckBoxBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintCheckBoxBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        CheckBoxPainter.getInstance(sc).paintCheckBoxBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintComboBoxBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ComboBoxPainter.getInstance(sc), "paintComboBoxBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ComboBoxPainter.getInstance(sc).paintComboBoxBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintComboBoxBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ComboBoxPainter.getInstance(sc), "paintComboBoxBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ComboBoxPainter.getInstance(sc).paintComboBoxBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintDesktopPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        DesktopPanePainter.getInstance(sc).paintDesktopPaneBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintDesktopPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        DesktopPanePainter.getInstance(sc).paintDesktopPaneBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintEditorPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, EditorPanePainter.getInstance(sc), "paintEditorPaneBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            EditorPanePainter.getInstance(sc).paintEditorPaneBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintEditorPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        EditorPanePainter.getInstance(sc).paintEditorPaneBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintFormattedTextFieldBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, FormattedTextFieldPainter.getInstance(sc), "paintFormattedTextFieldBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            FormattedTextFieldPainter.getInstance(sc).paintFormattedTextFieldBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintFormattedTextFieldBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, FormattedTextFieldPainter.getInstance(sc), "paintFormattedTextFieldBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            FormattedTextFieldPainter.getInstance(sc).paintFormattedTextFieldBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintInternalFrameBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        InternalFramePainter.getInstance(sc).paintInternalFrameBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintInternalFrameBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, InternalFramePainter.getInstance(sc), "paintInternalFrameBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            InternalFramePainter.getInstance(sc).paintInternalFrameBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintInternalFrameTitlePaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        InternalFramePainter.getInstance(sc).paintInternalFrameTitlePaneBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintInternalFrameTitlePaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, InternalFramePainter.getInstance(sc), "paintInternalFrameTitlePaneBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            InternalFramePainter.getInstance(sc).paintInternalFrameTitlePaneBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintLabelBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        LabelPainter.getInstance(sc).paintLabelBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintLabelBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        LabelPainter.getInstance(sc).paintLabelBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintListBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        ListPainter.getInstance(sc).paintListBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintListBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        ListPainter.getInstance(sc).paintListBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintMenuBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintMenuBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintMenuBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintMenuBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintMenuBarBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, MenuPainter.getInstance(sc), "paintMenuBarBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            MenuPainter.getInstance(sc).paintMenuBarBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintMenuBarBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, MenuPainter.getInstance(sc), "paintMenuBarBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            MenuPainter.getInstance(sc).paintMenuBarBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintMenuItemBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintMenuItemBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintMenuItemBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintMenuItemBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintRadioButtonMenuItemBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintRadioButtonMenuItemBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintRadioButtonMenuItemBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintRadioButtonMenuItemBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintCheckBoxMenuItemBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintCheckBoxMenuItemBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintCheckBoxMenuItemBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintCheckBoxMenuItemBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintOptionPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        OptionPanePainter.getInstance(sc).paintOptionPaneBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintOptionPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        OptionPanePainter.getInstance(sc).paintOptionPaneBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintPopupMenuBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintPopupMenuBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintPopupMenuBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintPopupMenuBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintPanelBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        PanelPainter.getInstance(sc).paintPanelBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintPanelBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        PanelPainter.getInstance(sc).paintPanelBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintPasswordFieldBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, PasswordFieldPainter.getInstance(sc), "paintPasswordFieldBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            PasswordFieldPainter.getInstance(sc).paintPasswordFieldBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintPasswordFieldBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, PasswordFieldPainter.getInstance(sc), "paintPasswordFieldBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            PasswordFieldPainter.getInstance(sc).paintPasswordFieldBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintProgressBarForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int direction) {
        ProgressBarPainter.getInstance(sc).paintProgressBarForeground(sc, g, x, y, w, h, direction);
    }

    @Override
    public void paintProgressBarBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ProgressBarPainter.getInstance(sc), "paintProgressBarBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ProgressBarPainter.getInstance(sc).paintProgressBarBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintProgressBarBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ProgressBarPainter.getInstance(sc), "paintProgressBarBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ProgressBarPainter.getInstance(sc).paintProgressBarBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintRadioButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        RadioButtonPainter.getInstance(sc).paintRadioButtonBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintRadioButtonBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        RadioButtonPainter.getInstance(sc).paintRadioButtonBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintRootPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    @Override
    public void paintRootPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (UIManager.getBoolean("Synthetica.window.decoration") && !this.paintCachedImage(sc, g, x, y, w, h, -1, RootPanePainter.getInstance(sc), "paintRootPaneBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            RootPanePainter.getInstance(sc).paintRootPaneBorder(sc, g, x, y, w, h);
        }
    }

    public void paintRootPaneTitlePaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, RootPanePainter.getInstance(sc), "paintTitlePaneBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            RootPanePainter.getInstance(sc).paintTitlePaneBackground(sc, g, x, y, w, h);
        }
    }

    public void paintRootPaneButtonAreaBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, RootPanePainter.getInstance(sc), "paintButtonAreaBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            RootPanePainter.getInstance(sc).paintButtonAreaBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintScrollBarBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ScrollBarPainter.getInstance(sc), "paintScrollBarBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ScrollBarPainter.getInstance(sc).paintScrollBarBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintScrollBarBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ScrollBarPainter.getInstance(sc), "paintScrollBarBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ScrollBarPainter.getInstance(sc).paintScrollBarBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintScrollBarThumbBackground(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, orientation, ScrollBarPainter.getInstance(sc), "paintScrollBarThumbBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ScrollBarPainter.getInstance(sc).paintScrollBarThumbBackground(sc, g, x, y, w, h, orientation);
        }
    }

    @Override
    public void paintScrollBarThumbBorder(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, orientation, ScrollBarPainter.getInstance(sc), "paintScrollBarThumbBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ScrollBarPainter.getInstance(sc).paintScrollBarThumbBorder(sc, g, x, y, w, h, orientation);
        }
    }

    @Override
    public void paintScrollBarTrackBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ScrollBarPainter.getInstance(sc), "paintScrollBarTrackBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ScrollBarPainter.getInstance(sc).paintScrollBarTrackBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintScrollBarTrackBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ScrollBarPainter.getInstance(sc), "paintScrollBarTrackBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ScrollBarPainter.getInstance(sc).paintScrollBarTrackBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintScrollPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ScrollPanePainter.getInstance(sc), "paintScrollPaneBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ScrollPanePainter.getInstance(sc).paintScrollPaneBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintScrollPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ScrollPanePainter.getInstance(sc), "paintScrollPaneBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ScrollPanePainter.getInstance(sc).paintScrollPaneBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintSeparatorBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        SeparatorPainter.getInstance(sc).paintSeparatorBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintSeparatorBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        SeparatorPainter.getInstance(sc).paintSeparatorBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintSeparatorForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        SeparatorPainter.getInstance(sc).paintSeparatorForeground(sc, g, x, y, w, h, orientation);
    }

    @Override
    public void paintSliderBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        SliderPainter.getInstance(sc).paintSliderBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintSliderBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, SliderPainter.getInstance(sc), "paintSliderBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            SliderPainter.getInstance(sc).paintSliderBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintSliderTrackBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, SliderPainter.getInstance(sc), "paintSliderTrackBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            SliderPainter.getInstance(sc).paintSliderTrackBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintSliderTrackBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, SliderPainter.getInstance(sc), "paintSliderTrackBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            SliderPainter.getInstance(sc).paintSliderTrackBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintSliderThumbBackground(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, orientation, SliderPainter.getInstance(sc), "paintSliderThumbBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            SliderPainter.getInstance(sc).paintSliderThumbBackground(sc, g, x, y, w, h, orientation);
        }
    }

    @Override
    public void paintSliderThumbBorder(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, orientation, SliderPainter.getInstance(sc), "paintSliderThumbBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            SliderPainter.getInstance(sc).paintSliderThumbBorder(sc, g, x, y, w, h, orientation);
        }
    }

    @Override
    public void paintSpinnerBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        SyntheticaLookAndFeel.setChildrenOpaque(sc.getComponent(), false);
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, SpinnerPainter.getInstance(sc), "paintSpinnerBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            SpinnerPainter.getInstance(sc).paintSpinnerBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintSpinnerBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, SpinnerPainter.getInstance(sc), "paintSpinnerBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            SpinnerPainter.getInstance(sc).paintSpinnerBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintSplitPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        SplitPanePainter.getInstance(sc).paintSplitPaneBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintSplitPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        SplitPanePainter.getInstance(sc).paintSplitPaneBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintSplitPaneDividerForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, orientation, SplitPanePainter.getInstance(sc), "paintSplitPaneDividerForeground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            SplitPanePainter.getInstance(sc).paintSplitPaneDividerForeground(sc, g, x, y, w, h, orientation);
        }
    }

    @Override
    public void paintSplitPaneDividerBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, SplitPanePainter.getInstance(sc), "paintSplitPaneDividerBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            SplitPanePainter.getInstance(sc).paintSplitPaneDividerBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintSplitPaneDragDivider(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, orientation, SplitPanePainter.getInstance(sc), "paintSplitPaneDragDivider", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            SplitPanePainter.getInstance(sc).paintSplitPaneDragDivider(sc, g, x, y, w, h, orientation);
        }
    }

    @Override
    public void paintTabbedPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        TabbedPanePainter.getInstance(sc).paintTabbedPaneBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        TabbedPanePainter.getInstance(sc).paintTabbedPaneBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneContentBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        TabbedPanePainter.getInstance(sc).paintTabbedPaneContentBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneContentBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        TabbedPanePainter.getInstance(sc).paintTabbedPaneContentBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabAreaBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Rectangle r = this.tabAreaBoundsCorretion(sc, x, y, w, h);
        x = r.x;
        y = r.y;
        w = r.width;
        h = r.height;
        TabbedPanePainter.getInstance(sc).paintTabbedPaneTabAreaBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabAreaBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Rectangle r = this.tabAreaBoundsCorretion(sc, x, y, w, h);
        x = r.x;
        y = r.y;
        w = r.width;
        h = r.height;
        TabbedPanePainter.getInstance(sc).paintTabbedPaneTabAreaBorder(sc, g, x, y, w, h);
    }

    private Rectangle tabAreaBoundsCorretion(SynthContext sc, int x, int y, int w, int h) {
        JTabbedPane tabbedPane = (JTabbedPane)sc.getComponent();
        if (tabbedPane.getTabLayoutPolicy() == 1) {
            Insets insets = tabbedPane.getInsets();
            Insets areaInsets = sc.getStyle().getInsets(sc, null);
            int tabCount = tabbedPane.getTabCount();
            if (tabbedPane.getTabPlacement() == 2 || tabbedPane.getTabPlacement() == 4) {
                x -= insets.top;
                y -= insets.left;
                w = (tabCount > 0 ? tabbedPane.getBoundsAt((int)0).width : 0) + areaInsets.top + areaInsets.bottom;
                h = areaInsets.left + areaInsets.right;
                int i = 0;
                while (i < tabCount) {
                    h += tabbedPane.getBoundsAt((int)i).height;
                    ++i;
                }
                h = Math.max(h, tabbedPane.getHeight());
            } else {
                x -= insets.left;
                y -= insets.top;
                w = areaInsets.left + areaInsets.right;
                int i = 0;
                while (i < tabCount) {
                    w += tabbedPane.getBoundsAt((int)i).width;
                    ++i;
                }
                w = Math.max(w, tabbedPane.getWidth());
                h = (tabCount > 0 ? tabbedPane.getBoundsAt((int)0).height : 0) + areaInsets.top + areaInsets.bottom;
            }
        }
        return new Rectangle(x, y, w, h);
    }

    @Override
    public void paintTabbedPaneTabBackground(SynthContext sc, Graphics g, int x, int y, int w, int h, int tabIndex) {
        sc.getComponent().putClientProperty("Synthetica.tabbedPane.tabIndex", tabIndex);
        if (!this.paintCachedImage(sc, g, x, y, w, h, tabIndex, TabbedPanePainter.getInstance(sc), "paintTabbedPaneTabBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            TabbedPanePainter.getInstance(sc).paintTabbedPaneTabBackground(sc, g, x, y, w, h, tabIndex);
        }
    }

    @Override
    public void paintTabbedPaneTabBorder(SynthContext sc, Graphics g, int x, int y, int w, int h, int tabIndex) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, tabIndex, TabbedPanePainter.getInstance(sc), "paintTabbedPaneTabBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            TabbedPanePainter.getInstance(sc).paintTabbedPaneTabBorder(sc, g, x, y, w, h, tabIndex);
        }
    }

    @Override
    public void paintTableBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        TablePainter.getInstance(sc).paintTableBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintTableBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        TablePainter.getInstance(sc).paintTableBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintTableHeaderBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, TablePainter.getInstance(sc), "paintTableHeaderBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            TablePainter.getInstance(sc).paintTableHeaderBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintTableHeaderBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        TablePainter.getInstance(sc).paintTableHeaderBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintTextAreaBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, TextAreaPainter.getInstance(sc), "paintTextAreaBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            TextAreaPainter.getInstance(sc).paintTextAreaBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintTextAreaBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        TextAreaPainter.getInstance(sc).paintTextAreaBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintTextFieldBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, TextFieldPainter.getInstance(sc), "paintTextFieldBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            TextFieldPainter.getInstance(sc).paintTextFieldBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintTextFieldBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, TextFieldPainter.getInstance(sc), "paintTextFieldBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            TextFieldPainter.getInstance(sc).paintTextFieldBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintTextPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, TextPanePainter.getInstance(sc), "paintTextPaneBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            TextPanePainter.getInstance(sc).paintTextPaneBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintTextPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        TextPanePainter.getInstance(sc).paintTextPaneBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintToggleButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ToggleButtonPainter.getInstance(sc), "paintToggleButtonBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ToggleButtonPainter.getInstance(sc).paintToggleButtonBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintToggleButtonBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ToggleButtonPainter.getInstance(sc), "paintToggleButtonBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ToggleButtonPainter.getInstance(sc).paintToggleButtonBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintToolBarBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JComponent c = sc.getComponent();
        JRootPane root = c.getRootPane();
        RootPaneUI ui = root.getUI();
        if (ui instanceof SyntheticaRootPaneUI && ((SyntheticaRootPaneUI)ui).isHeaderShadowEnabled()) {
            Insets insets = root.getInsets();
            boolean shadowSupported = SyntheticaLookAndFeel.getClientProperty("Synthetica.headerShadowSupport", c, true);
            if (shadowSupported && w == root.getWidth() - insets.left - insets.right && c != ((SyntheticaRootPaneUI)ui).getHeaderShadowComponent() && c.getLocationOnScreen().y + c.getHeight() < root.getLocationOnScreen().y + root.getHeight() - insets.bottom) {
                ((SyntheticaRootPaneUI)ui).setHeaderShadowComponent(c);
            }
        }
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ToolBarPainter.getInstance(sc), "paintToolBarBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ToolBarPainter.getInstance(sc).paintToolBarBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintToolBarBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ToolBarPainter.getInstance(sc), "paintToolBarBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ToolBarPainter.getInstance(sc).paintToolBarBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintToolBarContentBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ToolBarPainter.getInstance(sc), "paintToolBarContentBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ToolBarPainter.getInstance(sc).paintToolBarContentBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintToolBarContentBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ToolBarPainter.getInstance(sc), "paintToolBarContentBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ToolBarPainter.getInstance(sc).paintToolBarContentBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintToolTipBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ToolTipPainter.getInstance(sc), "paintToolTipBackground", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ToolTipPainter.getInstance(sc).paintToolTipBackground(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintToolTipBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        if (!this.paintCachedImage(sc, g, x, y, w, h, -1, ToolTipPainter.getInstance(sc), "paintToolTipBorder", SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)) {
            ToolTipPainter.getInstance(sc).paintToolTipBorder(sc, g, x, y, w, h);
        }
    }

    @Override
    public void paintTreeBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        TreePainter.getInstance(sc).paintTreeBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintTreeBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        TreePainter.getInstance(sc).paintTreeBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintTreeCellBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        TreePainter.getInstance(sc).paintTreeCellBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintTreeCellBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        TreePainter.getInstance(sc).paintTreeCellBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paintTreeCellFocus(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    @Override
    public void paintViewportBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        ViewportPainter.getInstance(sc).paintViewportBackground(sc, g, x, y, w, h);
    }

    @Override
    public void paintViewportBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        ViewportPainter.getInstance(sc).paintViewportBorder(sc, g, x, y, w, h);
    }
}

