/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.synth.SynthContext;

public class SliderPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.SliderPainter";

    protected SliderPainter() {
    }

    public static SliderPainter getInstance() {
        return SliderPainter.getInstance(null);
    }

    public static SliderPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(SliderPainter.getPainterClassName(sc, SliderPainter.class, UI_KEY));
        if (instance == null) {
            instance = SliderPainter.getInstance(sc, SliderPainter.class, UI_KEY);
        }
        return (SliderPainter)instance;
    }

    public void paintSliderBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JComponent c = sc.getComponent();
        if (c.hasFocus()) {
            FocusPainter.paintFocus("focus.slider", sc, g, x, y, w, h);
        }
    }

    public void paintSliderBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintSliderTrackBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintSliderTrackBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JSlider slider = (JSlider)sc.getComponent();
        SyntheticaPainterState state = new SyntheticaPainterState(sc);
        this.paintSliderTrack(slider, state, slider.getOrientation(), g, x, y, w, h);
        state = new SyntheticaPainterState(sc, 0, true);
        this.paintSliderTrack(slider, state, slider.getOrientation(), slider.getValue(), slider.getMinimum(), slider.getMaximum(), slider.getInverted(), g, x, y, w, h);
    }

    public void paintSliderTrack(JComponent c, SyntheticaState state, int orientation, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        UIKey key = new UIKey("slider.track", state, -1, -1, orientation);
        Insets dInsets = sInsets = (Insets)UIKey.findProperty(c, key.get(), "image.insets", 1);
        String imagePath = this.resolveImagePath(key.get("image"), c);
        if (imagePath != null) {
            ImagePainter imagePainter = new ImagePainter(c, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintSliderTrack(JComponent c, SyntheticaState state, int orientation, int value, int minimum, int maximum, boolean inverted, Graphics g, int x, int y, int w, int h) {
        String keyName = "slider.trackMark";
        UIKey key = new UIKey(keyName, state, -1, -1, orientation);
        String imagePath = this.resolveImagePath(key.get("image"), c);
        if (imagePath == null) {
            keyName = "slider.track";
            key = new UIKey(keyName, state, -1, -1, orientation);
            imagePath = this.resolveImagePath(key.get("image"), c);
        }
        if (imagePath != null) {
            boolean enabled;
            Insets sInsets = (Insets)UIKey.findProperty(c, key.get(), "image.insets", 1);
            Insets dInsets = (Insets)sInsets.clone();
            key = new UIKey(keyName, state);
            int cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), (Component)c, 1);
            int delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), (Component)c, 50);
            int type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)c, 2);
            if (state.isSet(SyntheticaState.State.HOVER) || state.isSet(SyntheticaState.State.PRESSED)) {
                type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)c, 1);
            }
            int val = value - minimum;
            int range = maximum == minimum ? val : maximum - minimum;
            boolean bl = enabled = c.isEnabled() && this.isSliderTrackMarkEnabled(c);
            if (range == 0) {
                range = 1;
            }
            if (orientation == 0) {
                int thumbWidth = SyntheticaLookAndFeel.getClientProperty("Synthetica.thumbWidth", c, SyntheticaLookAndFeel.getInt("Synthetica.slider.thumb.width", c, 10, true));
                int thumbX = SyntheticaLookAndFeel.getClientProperty("Synthetica.thumbX", c, 0);
                w -= thumbWidth;
                if (!inverted ^ !c.getComponentOrientation().isLeftToRight()) {
                    w = enabled ? thumbX - x + thumbWidth / 2 : w * val / range + thumbWidth / 2;
                    dInsets.right = 0;
                } else {
                    int w_ = enabled ? w + x - thumbX + thumbWidth / 2 : w * val / range + thumbWidth / 2;
                    x += w - w_ + thumbWidth;
                    w = w_;
                    dInsets.left = 0;
                }
            } else {
                int thumbHeight = SyntheticaLookAndFeel.getClientProperty("Synthetica.thumbHeight", c, SyntheticaLookAndFeel.getInt("Synthetica.slider.thumb.height", c, 10, true));
                int thumbY = SyntheticaLookAndFeel.getClientProperty("Synthetica.thumbY", c, 0);
                h -= thumbHeight;
                if (!inverted) {
                    int h_ = enabled ? h + y - thumbY + thumbHeight / 2 : h * val / range + thumbHeight / 2;
                    y += h - h_ + thumbHeight;
                    h = h_;
                    dInsets.top = 0;
                } else {
                    h = enabled ? thumbY - y + thumbHeight / 2 : h * val / range + thumbHeight / 2;
                    dInsets.bottom = 0;
                }
            }
            ImagePainter imagePainter = new ImagePainter(c, "track", cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintSliderThumbBorder(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
    }

    public void paintSliderThumbBackground(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        JSlider slider = (JSlider)sc.getComponent();
        SyntheticaPainterState state = new SyntheticaPainterState(sc);
        this.paintSliderThumb(slider, state, orientation, g, x, y, w, h);
    }

    public void paintSliderThumb(JComponent c, SyntheticaState state, int orientation, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        if (this.isSliderTrackMarkEnabled(c)) {
            int thumbX = SyntheticaLookAndFeel.getClientProperty("Synthetica.thumbX", c, -1);
            int thumbY = SyntheticaLookAndFeel.getClientProperty("Synthetica.thumbY", c, -1);
            if (thumbX != x || thumbY != y) {
                c.putClientProperty("Synthetica.thumbX", x);
                c.putClientProperty("Synthetica.thumbY", y);
                c.putClientProperty("Synthetica.thumbWidth", w);
                c.putClientProperty("Synthetica.thumbHeight", h);
                c.repaint();
            }
        }
        UIKey key = new UIKey("slider.thumb", state, -1, -1, orientation);
        Insets dInsets = sInsets = (Insets)UIKey.findProperty(c, key.get(), "image.insets", 1);
        String imagePath = this.resolveImagePath(key.get("image"), c);
        if (state.isSet(SyntheticaState.State.PRESSED) && imagePath == null) {
            state.setState(SyntheticaState.State.HOVER.toInt());
            key = new UIKey("slider.thumb", state, -1, -1, orientation);
            imagePath = this.resolveImagePath(key.get("image"), c);
        }
        if (imagePath != null) {
            key = new UIKey("slider.thumb", state);
            int cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), (Component)c, 1);
            int delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), (Component)c, 50);
            int type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)c, 2);
            if (state.isSet(SyntheticaState.State.HOVER) || state.isSet(SyntheticaState.State.PRESSED)) {
                type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)c, 1);
            }
            ImagePainter imagePainter = new ImagePainter(c, "thumb", cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
        if (c.hasFocus() || state.isSet(SyntheticaState.State.FOCUSED)) {
            int xPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.focus.slider.thumb.horizontalTiled", c, false) ? 1 : 0;
            int yPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.focus.slider.thumb.verticalTiled", c, false) ? 1 : 0;
            String thumbKey = null;
            if (SyntheticaLookAndFeel.get("Synthetica.focus.slider.thumb.x", c) != null && ((JSlider)c).getOrientation() == 0) {
                thumbKey = "focus.slider.thumb.x";
            } else if (SyntheticaLookAndFeel.get("Synthetica.focus.slider.thumb.y", c) != null && ((JSlider)c).getOrientation() == 1) {
                thumbKey = "focus.slider.thumb.y";
            } else if (SyntheticaLookAndFeel.get("Synthetica.focus.slider.thumb", c) != null) {
                thumbKey = "focus.slider.thumb";
            }
            if (thumbKey != null) {
                FocusPainter.paintFocus(thumbKey, c, state.getState(), "", 0, g, x, y, w, h, xPolicy, yPolicy);
            }
        }
    }

    private boolean isSliderTrackMarkEnabled(JComponent c) {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.slider.hoverAndPressed.enabled", c, false) || SyntheticaLookAndFeel.getBoolean("Synthetica.slider.trackMark.enabled", c, false);
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        if (id.equals("paintSliderBackground")) {
            return -1;
        }
        JSlider slider = (JSlider)sc.getComponent();
        int orientation = slider.getOrientation();
        int hash = super.getCacheHash(sc, w, h, meta, id);
        hash = 31 * hash + orientation;
        return hash;
    }
}

