/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.UIKey;
import de.javasoft.plaf.synthetica.util.HiDpi;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class ScrollBarPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ScrollBarPainter";
    private static HashMap<String, Image> imgCache = new HashMap();

    protected ScrollBarPainter() {
    }

    public static ScrollBarPainter getInstance() {
        return ScrollBarPainter.getInstance(null);
    }

    public static ScrollBarPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(ScrollBarPainter.getPainterClassName(sc, ScrollBarPainter.class, UI_KEY));
        if (instance == null) {
            instance = ScrollBarPainter.getInstance(sc, ScrollBarPainter.class, UI_KEY);
        }
        return (ScrollBarPainter)instance;
    }

    public void paintScrollBarBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintScrollBarBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintScrollBarThumbBorder(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
    }

    public void paintScrollBarTrackBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintScrollBarThumbBackground(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        boolean scalingEnabled;
        Insets sInsets;
        if (w < 4 || h < 4) {
            return;
        }
        JScrollBar scrollBar = (JScrollBar)sc.getComponent();
        int state = sc.getComponentState();
        boolean hover = (state & 2) > 0;
        boolean pressed = scrollBar.getClientProperty("Synthetica.MOUSE_PRESSED") == null ? false : (Boolean)scrollBar.getClientProperty("Synthetica.MOUSE_PRESSED");
        boolean flipHorizontal = scrollBar.getOrientation() == 1 && !scrollBar.getComponentOrientation().isLeftToRight();
        Rectangle trackBounds = (Rectangle)scrollBar.getClientProperty("Synthetica.scrollBarTrack.bounds");
        if (trackBounds == null) {
            trackBounds = new Rectangle();
        }
        SynthStyle ss = SynthLookAndFeel.getStyle(scrollBar, Region.SCROLL_BAR);
        SynthContext sbsc = new SynthContext(scrollBar, Region.SCROLL_BAR, ss, 0);
        Dimension minThumbSize = (Dimension)ss.get(sbsc, "ScrollBar.minimumThumbSize");
        if (orientation == 1 && trackBounds.height < minThumbSize.height || orientation == 0 && trackBounds.width < minThumbSize.width) {
            return;
        }
        UIKey key = new UIKey("scrollBarThumb." + (orientation == 0 ? "x" : "y"), new SyntheticaState(state));
        Insets dInsets = sInsets = (Insets)key.findProperty(sc, "background.insets", 2);
        String gripPath = null;
        String imagePath = "Synthetica.scrollBarThumb";
        if (orientation == 0) {
            gripPath = String.valueOf(imagePath) + ".x.grip";
            imagePath = String.valueOf(imagePath) + ".x.background";
        } else {
            gripPath = String.valueOf(imagePath) + ".y.grip";
            imagePath = String.valueOf(imagePath) + ".y.background";
        }
        if (pressed && this.resolveImagePath(String.valueOf(imagePath) + ".pressed", scrollBar) != null) {
            imagePath = String.valueOf(imagePath) + ".pressed";
            if (this.resolveImagePath(String.valueOf(gripPath) + ".pressed", scrollBar) != null) {
                gripPath = String.valueOf(gripPath) + ".pressed";
            }
        } else if (hover) {
            imagePath = String.valueOf(imagePath) + ".hover";
            if (this.resolveImagePath(String.valueOf(gripPath) + ".hover", scrollBar) != null) {
                gripPath = String.valueOf(gripPath) + ".hover";
            }
        }
        imagePath = this.resolveImagePath(imagePath, scrollBar);
        int cycles = 0;
        int delay = 0;
        int type = 0;
        if (hover) {
            cycles = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.hover.animation.cycles", (Component)scrollBar, 1);
            delay = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.hover.animation.delay", (Component)scrollBar, 50);
            type = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.hover.animation.type", (Component)scrollBar, 1);
        } else {
            cycles = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.animation.cycles", (Component)scrollBar, 1);
            delay = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.animation.delay", (Component)scrollBar, 50);
            type = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarThumb.animation.type", (Component)scrollBar, 2);
        }
        ImagePainter imagePainter = new ImagePainter(scrollBar, "thumb", cycles, delay, type, state, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0, flipHorizontal, false);
        imagePainter.draw();
        gripPath = this.resolveImagePath(gripPath, scrollBar);
        if (gripPath == null) {
            return;
        }
        Image image = imgCache.get(gripPath);
        if (image == null) {
            image = new ImageIcon(SyntheticaLookAndFeel.getResource(gripPath)).getImage();
            imgCache.put(gripPath, image);
        }
        int gripWidth = SyntheticaLookAndFeel.getInstance().scaleInteger(image.getWidth(null));
        int gripHeight = SyntheticaLookAndFeel.getInstance().scaleInteger(image.getHeight(null));
        int xPos = x + (w - gripWidth) / 2;
        int yPos = y + (h - gripHeight) / 2;
        if (orientation == 0 && w - 4 <= gripWidth) {
            return;
        }
        if (orientation == 1 && h - 4 <= gripHeight) {
            return;
        }
        boolean bl = scalingEnabled = SyntheticaLookAndFeel.getInstance().getScaleFactor() != 1.0f;
        if (scalingEnabled) {
            image = HiDpi.scaleImage(image, gripWidth, gripHeight);
        }
        g.drawImage(image, xPos, yPos, gripWidth, gripHeight, null);
    }

    public void paintScrollBarTrackBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        boolean hover;
        Container parent;
        JScrollBar scrollBar = (JScrollBar)sc.getComponent();
        UIKey key = new UIKey("scrollBarTrack." + (scrollBar.getOrientation() == 0 ? "x" : "y"), new SyntheticaState(sc.getComponentState()));
        Insets sInsets = (Insets)key.findProperty(sc, "background.insets", 2);
        Insets dInsets = (Insets)sInsets.clone();
        boolean flipHorizontal = scrollBar.getOrientation() == 1 && !scrollBar.getComponentOrientation().isLeftToRight();
        boolean clipEdges = SyntheticaLookAndFeel.getBoolean("Synthetica.scrollBarTrack.clipEdgesOnShowingBoth", scrollBar);
        if (clipEdges && this.isHorizontalAndVerticalScrollBarVisible(scrollBar)) {
            if (scrollBar.getOrientation() == 0) {
                dInsets.right = 0;
            } else {
                dInsets.bottom = 0;
            }
        }
        if ((parent = scrollBar.getParent()) instanceof JScrollPane && SyntheticaLookAndFeel.getClientProperty("Synthetica.scrollPane.clipScrollBarEdges", (JComponent)parent, false).booleanValue()) {
            if (scrollBar.getOrientation() == 0) {
                dInsets.left = 0;
                dInsets.right = 0;
            } else {
                dInsets.top = 0;
                dInsets.bottom = 0;
            }
        }
        scrollBar.putClientProperty("Synthetica.scrollBarTrack.bounds", new Rectangle(x, y, w, h));
        String imagePath = "Synthetica.scrollBarTrack";
        imagePath = scrollBar.getOrientation() == 0 ? String.valueOf(imagePath) + ".x.background" : String.valueOf(imagePath) + ".y.background";
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.scrollBarTrack.hoverAndPressed.enabled", scrollBar)) {
            imagePath = this.resolveImagePath(imagePath, scrollBar);
            ImagePainter imagePainter = new ImagePainter(scrollBar, null, -1, -1, -1, -1, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0, flipHorizontal, false);
            imagePainter.draw();
            return;
        }
        boolean bl = hover = scrollBar.getClientProperty("Synthetica.MOUSE_OVER") == null ? false : (Boolean)scrollBar.getClientProperty("Synthetica.MOUSE_OVER");
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.scrollBarTrack.hoverOnButtons.enabled", scrollBar)) {
            x = 0;
            y = 0;
            w = scrollBar.getWidth();
            h = scrollBar.getHeight();
            ArrayList components = new ArrayList();
            SyntheticaLookAndFeel.findComponents("ScrollBar.button", (Container)scrollBar, components);
            for (Component c : components) {
                hover |= ((JButton)c).getModel().isRollover();
            }
        }
        if (hover &= scrollBar.getModel().getMaximum() > scrollBar.getModel().getExtent()) {
            imagePath = String.valueOf(imagePath) + ".hover";
        }
        if (scrollBar.getParent() instanceof JScrollPane && SyntheticaLookAndFeel.getBoolean("Synthetica.scrollBarTrack.focusState.enabled", scrollBar)) {
            boolean focused;
            Component view = ((JScrollPane)scrollBar.getParent()).getViewport().getView();
            boolean bl2 = focused = view != null && view.hasFocus();
            if (focused && this.resolveImagePath(String.valueOf(imagePath) + ".focused", scrollBar) != null) {
                imagePath = String.valueOf(imagePath) + ".focused";
            }
        }
        imagePath = this.resolveImagePath(imagePath, scrollBar);
        int cycles = 0;
        int delay = 0;
        int type = 0;
        if (hover) {
            cycles = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarTrack.hover.animation.cycles", (Component)scrollBar, 1);
            delay = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarTrack.hover.animation.delay", (Component)scrollBar, 50);
            type = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarTrack.hover.animation.type", (Component)scrollBar, 1);
        } else {
            cycles = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarTrack.animation.cycles", (Component)scrollBar, 1);
            delay = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarTrack.animation.delay", (Component)scrollBar, 50);
            type = SyntheticaLookAndFeel.getInt("Synthetica.scrollBarTrack.animation.type", (Component)scrollBar, 2);
        }
        int state = sc.getComponentState();
        if (hover) {
            state |= 2;
        }
        ImagePainter imagePainter = new ImagePainter(scrollBar, "track", cycles, delay, type, state, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0, flipHorizontal, false);
        imagePainter.draw();
    }

    private boolean isHorizontalAndVerticalScrollBarVisible(JScrollBar scrollBar) {
        JScrollPane scroller = (JScrollPane)scrollBar.getParent();
        JScrollBar hScrollBar = scroller.getHorizontalScrollBar();
        JScrollBar vScrollBar = scroller.getVerticalScrollBar();
        return hScrollBar != null && vScrollBar != null && hScrollBar.isVisible() && vScrollBar.isVisible();
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        JScrollBar sb = (JScrollBar)sc.getComponent();
        int orientation = sb.getOrientation();
        int hash = super.getCacheHash(sc, w, h, meta, id);
        hash = 31 * hash + orientation;
        return hash;
    }
}

