/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.synth.SynthContext;

public class ProgressBarPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ProgressBarPainter";
    private static HashMap<String, Image> imgCache = new HashMap();

    protected ProgressBarPainter() {
    }

    public static ProgressBarPainter getInstance() {
        return ProgressBarPainter.getInstance(null);
    }

    public static ProgressBarPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(ProgressBarPainter.getPainterClassName(sc, ProgressBarPainter.class, UI_KEY));
        if (instance == null) {
            instance = ProgressBarPainter.getInstance(sc, ProgressBarPainter.class, UI_KEY);
        }
        return (ProgressBarPainter)instance;
    }

    public void paintProgressBarBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintProgressBarBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        JProgressBar pBar = (JProgressBar)sc.getComponent();
        Insets stInsets = sc.getStyle().getInsets(sc, null);
        Insets insets = pBar.getInsets();
        w -= insets.left + insets.right - stInsets.left - stInsets.right;
        h -= insets.top + insets.bottom - stInsets.top - stInsets.bottom;
        x += insets.left - stInsets.left;
        y += insets.top - stInsets.top;
        int activeState = pBar.getValue() > 0 || pBar.isIndeterminate() ? SyntheticaState.State.ACTIVE.toInt() : 0;
        SyntheticaPainterState state = new SyntheticaPainterState(sc, activeState, false);
        UIKey key = new UIKey("progressBar.x.background", state);
        if (pBar.getOrientation() == 1) {
            key = new UIKey("progressBar.y.background", state);
        }
        Insets dInsets = sInsets = (Insets)key.findProperty(sc, "insets", 2);
        String imagePath = key.resolveImagePath(sc, 1);
        key = new UIKey("progressBar.background", state);
        if (imagePath != null) {
            int cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), (Component)pBar, 1);
            int delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), (Component)pBar, 50);
            int type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)pBar, 6);
            if (state.isSet(SyntheticaState.State.ACTIVE)) {
                type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)pBar, 5);
            }
            ImagePainter imagePainter = new ImagePainter((JComponent)pBar, cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintProgressBarForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        Insets sInsets;
        Graphics2D g2 = (Graphics2D)g;
        JProgressBar pBar = (JProgressBar)sc.getComponent();
        pBar.putClientProperty("Synthetica.progressBar.textFillStart", orientation == 0 ? x : y);
        pBar.putClientProperty("Synthetica.progressBar.textFillAmount", orientation == 0 ? w : h);
        SyntheticaPainterState state = new SyntheticaPainterState(sc);
        UIKey key = new UIKey(pBar.isIndeterminate() ? "progressBar.x.indeterminate" : "progressBar.x", state);
        if (orientation == 1) {
            key = new UIKey(pBar.isIndeterminate() ? "progressBar.y.indeterminate" : "progressBar.y", state);
        }
        if ((sInsets = (Insets)key.findProperty(sc, "insets", 2)) == null) {
            sInsets = new Insets(0, 0, 0, 0);
        }
        Insets dInsets = sInsets;
        boolean respectMinSize = SyntheticaLookAndFeel.getBoolean("Synthetica.progressBar.respectMinimumBarImageSize", pBar, true);
        if (orientation == 0) {
            int minWidth;
            int n = minWidth = respectMinSize ? sInsets.left + sInsets.right : 1;
            if (w < minWidth) {
                return;
            }
        } else {
            int minHeight;
            int n = minHeight = respectMinSize ? sInsets.top + sInsets.bottom : 1;
            if (h < minHeight) {
                return;
            }
        }
        int width = w;
        int height = h;
        int fillPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.progressBar.tiled", pBar) ? 1 : 0;
        String imagePath = key.resolveImagePath(sc, 2);
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.progressBar.continuous", pBar)) {
            Image image = imgCache.get(imagePath);
            if (image == null) {
                image = new ImageIcon(SyntheticaLookAndFeel.getResource(imagePath)).getImage();
                imgCache.put(imagePath, image);
            }
            int centerWidth = image.getWidth(null) - sInsets.left - sInsets.right;
            int centerHeight = image.getHeight(null) - sInsets.top - sInsets.bottom;
            width = (w - sInsets.left - sInsets.right) / centerWidth * centerWidth + sInsets.left + sInsets.right;
            height = (h - sInsets.top - sInsets.bottom) / centerHeight * centerHeight + sInsets.top + sInsets.bottom;
            fillPolicy = 1;
        }
        int cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), (Component)pBar, -1);
        int delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), (Component)pBar, 70);
        int type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)pBar, 0);
        RenderingHints rh = g2.getRenderingHints();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        ImagePainter imagePainter = null;
        if (orientation == 0) {
            imagePainter = new ImagePainter((JComponent)pBar, cycles, delay, type, state.getState(), g, x, y, width, h, imagePath, sInsets, dInsets, fillPolicy, 0);
            imagePainter.draw();
        } else {
            imagePainter = new ImagePainter((JComponent)pBar, cycles, delay, type, state.getState(), g, x, y - height + h, w, height, imagePath, sInsets, dInsets, 0, fillPolicy);
            imagePainter.draw();
        }
        g2.setRenderingHints(rh);
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        if (id.equals("paintProgressBarForeground")) {
            return -1;
        }
        JProgressBar pb = (JProgressBar)sc.getComponent();
        int orientation = pb.getOrientation();
        int hash = super.getCacheHash(sc, w, h, meta, id);
        hash = 31 * hash + orientation;
        return hash;
    }
}

