/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.util.DropShadow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class InternalFramePainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.InternalFramePainter";
    private static WeakHashMap<JComponent, Object> opaqued = new WeakHashMap();

    protected InternalFramePainter() {
    }

    public static InternalFramePainter getInstance() {
        return InternalFramePainter.getInstance(null);
    }

    public static InternalFramePainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(InternalFramePainter.getPainterClassName(sc, InternalFramePainter.class, UI_KEY));
        if (instance == null) {
            instance = InternalFramePainter.getInstance(sc, InternalFramePainter.class, UI_KEY);
        }
        return (InternalFramePainter)instance;
    }

    public void paintInternalFrameTitlePaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        ImagePainter imagePainter;
        Insets sInsets;
        BasicInternalFrameTitlePane pane = (BasicInternalFrameTitlePane)sc.getComponent();
        boolean selected = (sc.getComponentState() & 0x200) > 0;
        this.setIcons(pane, sc);
        if (!opaqued.containsKey(pane)) {
            opaqued.put(pane, null);
            Component[] components = pane.getComponents();
            int i = 0;
            while (i < components.length) {
                Component comp = components[i];
                if (comp instanceof JButton) {
                    JButton b = (JButton)comp;
                    b.setOpaque(false);
                }
                ++i;
            }
        }
        String imagePath = "Synthetica.internalFrameTitlePane.background";
        if (selected) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        imagePath = this.resolveImagePath(imagePath, pane);
        Insets dInsets = sInsets = this.getImageInsets("Synthetica.internalFrameTitlePane.background.insets", pane);
        int xPolicy = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.background.horizontalTiled", pane)) {
            xPolicy = 1;
        }
        int yPolicy = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.background.verticalTiled", pane)) {
            yPolicy = 1;
        }
        if (imagePath != null) {
            imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy);
            imagePainter.draw();
        }
        imagePath = "Synthetica.internalFrameTitlePane.background.light";
        if (selected) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        if ((imagePath = this.resolveImagePath(imagePath, pane)) != null) {
            imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, yPolicy);
            imagePainter.draw();
        }
        this.paintTitle(sc, g, w);
    }

    protected void paintTitle(SynthContext sc, Graphics g, int w) {
        Color titleFg;
        BasicInternalFrameTitlePane pane = (BasicInternalFrameTitlePane)sc.getComponent();
        boolean selected = (sc.getComponentState() & 0x200) > 0;
        String title = this.getTitle(pane.getParent());
        FontMetrics fm = pane.getFontMetrics(pane.getFont());
        int th = fm.getHeight();
        int tw = fm.stringWidth(title);
        int ty = (pane.getSize().height - th) / 2;
        int xGap = 4;
        boolean rtl = this.isRTL(pane);
        Rectangle menuRect = this.getMenuButtonBounds(pane);
        Rectangle controlsRect = this.getControlButtonsBounds(pane);
        int txMin = rtl ? controlsRect.x + controlsRect.width + xGap : menuRect.x + menuRect.width + xGap;
        int txMax = rtl ? menuRect.x - xGap - tw : controlsRect.x - xGap - tw;
        txMax = Math.max(txMin, txMax);
        int tx = rtl ? txMax : txMin;
        tx = SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.title.center", pane) ? w / 2 - fm.stringWidth(title) / 2 : tx;
        tx = rtl ? Math.min(tx, txMax) : Math.max(tx, txMin);
        tx = rtl ? Math.max(tx, txMin) : Math.min(tx, txMax);
        Rectangle viewRect = pane.getBounds();
        viewRect.width -= menuRect.width + controlsRect.width + xGap * 4;
        title = sc.getStyle().getGraphicsUtils(sc).layoutText(sc, g.getFontMetrics(), title, null, 0, 0, 0, 0, viewRect, new Rectangle(0, 0), new Rectangle(0, 0), 0);
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.dropShadow", pane) && selected && tw > 0 && th > 0) {
            BufferedImage image = new BufferedImage(tw, th, 2);
            Graphics2D g2 = image.createGraphics();
            g2.setFont(g.getFont());
            ((Graphics)g2).drawString(title, 0, fm.getAscent());
            g2.dispose();
            DropShadow ds = new DropShadow(image);
            ds.setDistance(SyntheticaLookAndFeel.getInt("Synthetica.internalFrame.titlePane.dropShadow.distance", pane, -5, true));
            ds.setShadowColor(SyntheticaLookAndFeel.getColor("Synthetica.internalFrame.titlePane.dropShadow.color", pane, ds.getShadowColor()));
            ds.setQuality(SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.dropShadow.highQuality", pane, ds.getHighQuality()));
            ds.setShadowOpacity((float)SyntheticaLookAndFeel.getInt("Synthetica.internalFrame.titlePane.dropShadow.opacity", (Component)pane, (int)(ds.getShadowOpacity() * 100.0f)) / 100.0f);
            ds.setShadowSize(SyntheticaLookAndFeel.getInt("Synthetica.internalFrame.titlePane.dropShadow.size", pane, ds.getShadowSize(), true));
            int xOffset = SyntheticaLookAndFeel.getInt("Synthetica.internalFrame.titlePane.dropShadow.xOffset", pane, 0, true);
            int yOffset = SyntheticaLookAndFeel.getInt("Synthetica.internalFrame.titlePane.dropShadow.yOffset", pane, 0, true);
            ds.paintShadow(g, tx + xOffset, ty + yOffset);
        }
        Color titleColor = (titleFg = pane.getForeground()) == null || titleFg instanceof ColorUIResource ? sc.getStyle().getColor(sc, ColorType.FOREGROUND) : titleFg;
        SynthStyle ss = sc.getStyle();
        if (pane.getParent() instanceof JInternalFrame) {
            JInternalFrame iFrame = (JInternalFrame)pane.getParent();
            ss = SynthLookAndFeel.getStyle(iFrame, Region.INTERNAL_FRAME_TITLE_PANE);
            sc = new SynthContext(iFrame, Region.INTERNAL_FRAME_TITLE_PANE, ss, sc.getComponentState());
        }
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.title.etchedTop", pane)) {
            g.setColor(Color.BLACK);
            ss.getGraphicsUtils(sc).paintText(sc, g, title, tx, ty - 1, -2);
        }
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.titlePane.title.etchedBottom", pane)) {
            g.setColor(Color.WHITE);
            ss.getGraphicsUtils(sc).paintText(sc, g, title, tx, ty + 1, -2);
        }
        g.setColor(titleColor);
        ss.getGraphicsUtils(sc).paintText(sc, g, title, tx, ty, -2);
    }

    private String getTitle(Container parent) {
        String title = null;
        if (parent instanceof JInternalFrame) {
            title = ((JInternalFrame)parent).getTitle();
        } else if (parent instanceof JInternalFrame.JDesktopIcon) {
            title = ((JInternalFrame.JDesktopIcon)parent).getInternalFrame().getTitle();
        }
        title = title == null ? "" : title;
        return title;
    }

    public void paintInternalFrameTitlePaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintInternalFrameBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintInternalFrameBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        JInternalFrame frame = (JInternalFrame)sc.getComponent();
        String imagePath = "Synthetica.internalFrame.border";
        if (frame.isSelected()) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        imagePath = this.resolveImagePath(imagePath, frame);
        Insets dInsets = sInsets = this.getImageInsets("Synthetica.internalFrame.border.insets", frame);
        ImagePainter imagePainter = new ImagePainter(frame, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.drawBorder();
    }

    private void setIcons(BasicInternalFrameTitlePane pane, SynthContext sc) {
        String hoverButton = (String)pane.getClientProperty("Synthetica.MOUSE_OVER");
        boolean hover = hoverButton != null;
        String pressedButton = (String)pane.getClientProperty("Synthetica.MOUSE_PRESSED");
        boolean pressed = pressedButton != null;
        SynthStyle style = sc.getStyle();
        SynthContext scHover = new SynthContext(pane, sc.getRegion(), style, 2);
        SynthContext scPressed = new SynthContext(pane, sc.getRegion(), style, 4);
        Container parent = pane.getParent();
        String key = "InternalFrameTitlePane.iconifyIcon";
        Icon iconifyIcon = style.getIcon(sc, key);
        if (pressed && pressedButton.endsWith("iconifyButton")) {
            iconifyIcon = style.getIcon(scPressed, key) == iconifyIcon ? style.getIcon(scHover, key) : style.getIcon(scPressed, key);
        } else if (hover && hoverButton.endsWith("iconifyButton")) {
            iconifyIcon = style.getIcon(scHover, key);
        }
        key = "InternalFrameTitlePane.maximizeIcon";
        Icon maxIcon = style.getIcon(sc, key);
        if (pressed && pressedButton.endsWith("maximizeButton")) {
            maxIcon = style.getIcon(scPressed, key) == maxIcon ? style.getIcon(scHover, key) : style.getIcon(scPressed, key);
        } else if (hover && hoverButton.endsWith("maximizeButton")) {
            maxIcon = style.getIcon(scHover, key);
        }
        key = "InternalFrameTitlePane.closeIcon";
        Icon closeIcon = style.getIcon(sc, key);
        if (pressed && pressedButton.endsWith("closeButton")) {
            closeIcon = style.getIcon(scPressed, key) == closeIcon ? style.getIcon(scHover, key) : style.getIcon(scPressed, key);
        } else if (hover && hoverButton.endsWith("closeButton")) {
            closeIcon = style.getIcon(scHover, key);
        }
        key = "InternalFrameTitlePane.minimizeIcon";
        Icon minIcon = style.getIcon(sc, key);
        if (pressed && (pressedButton.endsWith("maximizeButton") && parent instanceof JInternalFrame || pressedButton.endsWith("iconifyButton") && parent instanceof JInternalFrame.JDesktopIcon)) {
            minIcon = style.getIcon(scPressed, key) == minIcon ? style.getIcon(scHover, key) : style.getIcon(scPressed, key);
        } else if (hover && (hoverButton.endsWith("maximizeButton") && parent instanceof JInternalFrame || hoverButton.endsWith("iconifyButton") && parent instanceof JInternalFrame.JDesktopIcon)) {
            minIcon = style.getIcon(scHover, key);
        }
        AbstractButton iconButton = null;
        AbstractButton maxButton = null;
        AbstractButton closeButton = null;
        Component[] components = pane.getComponents();
        int i = 0;
        while (i < components.length) {
            Component c = components[i];
            if (c instanceof JButton) {
                String cName = c.getName();
                if (cName.endsWith("closeButton")) {
                    closeButton = (JButton)c;
                }
                if (cName.endsWith("iconifyButton")) {
                    iconButton = (JButton)c;
                }
                if (cName.endsWith("maximizeButton")) {
                    maxButton = (JButton)c;
                }
            }
            ++i;
        }
        if (parent instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)parent;
            if (frame.isMaximum()) {
                if (iconButton != null) {
                    iconButton.setIcon(iconifyIcon);
                }
                if (maxButton != null) {
                    maxButton.setIcon(minIcon);
                }
            } else if (frame.isIcon()) {
                if (iconButton != null) {
                    iconButton.setIcon(minIcon);
                }
                if (maxButton != null) {
                    maxButton.setIcon(maxIcon);
                }
            } else {
                if (iconButton != null) {
                    iconButton.setIcon(iconifyIcon);
                }
                if (maxButton != null) {
                    maxButton.setIcon(maxIcon);
                }
            }
        } else if (parent instanceof JInternalFrame.JDesktopIcon) {
            if (iconButton != null) {
                iconButton.setIcon(minIcon);
            }
            if (maxButton != null) {
                maxButton.setIcon(maxIcon);
            }
        }
        if (closeButton != null) {
            closeButton.setIcon(closeIcon);
        }
    }

    protected Rectangle getControlButtonsBounds(BasicInternalFrameTitlePane pane) {
        Rectangle r;
        Component iconifyButton = null;
        Component toggleButton = null;
        Component closeButton = null;
        boolean rtl = this.isRTL(pane);
        Component[] components = pane.getComponents();
        int i = 0;
        while (i < components.length) {
            String cName;
            Component c = components[i];
            if (c instanceof JButton && (cName = c.getName()) != null) {
                if (cName.endsWith("closeButton")) {
                    closeButton = (JButton)c;
                }
                if (cName.endsWith("iconifyButton")) {
                    iconifyButton = (JButton)c;
                }
                if (cName.endsWith("maximizeButton")) {
                    toggleButton = (JButton)c;
                }
            }
            ++i;
        }
        JInternalFrame iFrame = null;
        if (pane.getParent() instanceof JInternalFrame && !(iFrame = (JInternalFrame)pane.getParent()).isClosable() && !iFrame.isMaximizable() && !iFrame.isIconifiable()) {
            return new Rectangle(rtl ? 0 : pane.getBounds().width - 1, 0, 0, 0);
        }
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        if (closeButton != null && !closeButton.getBounds().equals(rect)) {
            rect = closeButton.getBounds();
        } else if (toggleButton != null && !toggleButton.getBounds().equals(rect)) {
            rect = toggleButton.getBounds();
        } else if (iconifyButton != null && !iconifyButton.getBounds().equals(rect)) {
            rect = iconifyButton.getBounds();
        }
        if (iFrame != null && iFrame.isIconifiable() || iFrame == null && iconifyButton != null) {
            r = iconifyButton.getBounds();
            if (rtl) {
                rect.width = r.x + r.width - rect.x;
            } else {
                rect.width = rect.x + rect.width - r.x;
                rect.x = r.x;
            }
        } else if (iFrame != null && iFrame.isMaximizable() || iFrame == null && toggleButton != null) {
            r = toggleButton.getBounds();
            if (rtl) {
                rect.width = r.x + r.width - rect.x;
            } else {
                rect.width = rect.x + rect.width - r.x;
                rect.x = r.x;
            }
        }
        return rect;
    }

    protected Rectangle getMenuButtonBounds(BasicInternalFrameTitlePane pane) {
        Rectangle rect;
        JButton menuButton = (JButton)SyntheticaLookAndFeel.findComponent("InternalFrameTitlePane.menuButton", (Container)pane);
        Rectangle rectangle = rect = menuButton == null ? new Rectangle(0, 0, 0, 0) : menuButton.getBounds();
        if (menuButton == null) {
            rect.x = this.isRTL(pane) ? pane.getBounds().width - 1 : 0;
            rect.y = pane.getBounds().y;
        }
        return rect;
    }

    protected boolean isRTL(BasicInternalFrameTitlePane pane) {
        return !pane.getRootPane().getComponentOrientation().isLeftToRight();
    }

    @Override
    public Cacheable.ScaleType getCacheScaleType(String id) {
        if (id.equals("paintInternalFrameBorder") || id.equals("paintInternalFrameBackground")) {
            return Cacheable.ScaleType.NINE_SQUARE;
        }
        return super.getCacheScaleType(id);
    }
}

