/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.MenuPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.lang.reflect.Method;
import javax.accessibility.Accessible;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;

public class ComboBoxPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ComboBoxPainter";

    protected ComboBoxPainter() {
    }

    public static ComboBoxPainter getInstance() {
        return ComboBoxPainter.getInstance(null);
    }

    public static ComboBoxPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(ComboBoxPainter.getPainterClassName(sc, ComboBoxPainter.class, UI_KEY));
        if (instance == null) {
            instance = ComboBoxPainter.getInstance(sc, ComboBoxPainter.class, UI_KEY);
        }
        return (ComboBoxPainter)instance;
    }

    public void paintComboBoxBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JComboBox combo;
        if (sc.getComponent() instanceof JComboBox && this.hasFocus(combo = (JComboBox)sc.getComponent())) {
            FocusPainter.paintFocus(combo.isEditable() ? "focus.comboBox" : "focus.comboBox.locked", sc, g, x, y, w, h);
        }
    }

    protected boolean hasFocus(JComboBox<?> combo) {
        Component editor = null;
        if (combo.isEditable()) {
            editor = combo.getEditor().getEditorComponent();
        }
        return combo.hasFocus() || editor != null && editor.hasFocus();
    }

    public void paintComboBoxBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        String key_;
        boolean keyExists;
        boolean innerBorderIsDefault;
        boolean locked;
        JComboBox combo;
        combo.putClientProperty("Synthetica.flipHorizontal", !(combo = (JComboBox)sc.getComponent()).getComponentOrientation().isLeftToRight());
        SyntheticaLookAndFeel.setChildrenOpaque(combo, false);
        Color background = combo.getBackground();
        boolean defaultBackground = background == null || background instanceof ColorUIResource;
        boolean keepLockedBorderIfColored = SyntheticaLookAndFeel.getBoolean("Synthetica.comboBox.keepLockedBorderIfColored", combo);
        boolean noBorderIfColored = SyntheticaLookAndFeel.getBoolean("Synthetica.comboBox.noBorderIfColored", combo);
        boolean opaque = SyntheticaLookAndFeel.isOpaque(combo);
        boolean enabled = combo.isEnabled();
        boolean bl = locked = !combo.isEditable();
        if (!opaque) {
            return;
        }
        if (defaultBackground) {
            if (this.hasFocus(combo)) {
                sc = new SynthContext(combo, Region.COMBO_BOX, sc.getStyle(), sc.getComponentState() | 0x100);
            }
            if (!enabled) {
                background = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.disabled.backgroundColor", combo);
            } else if (locked) {
                background = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.locked.backgroundColor", combo);
                if (background == null) {
                    background = sc.getStyle().getColor(sc, ColorType.BACKGROUND);
                }
            } else {
                background = sc.getStyle().getColor(sc, ColorType.BACKGROUND);
            }
        }
        SyntheticaPainterState state = this.createState(sc, combo);
        UIKey key = this.getUIKey(combo, "comboBox", state);
        Boolean fillBackground = (Boolean)SyntheticaLookAndFeel.get(key.get("fillBackground"), combo);
        Border border = combo.getBorder();
        Border defaultBorder = SyntheticaLookAndFeel.findDefaultBorder(border);
        boolean defaultBorderIsSynth = defaultBorder == null ? false : defaultBorder.getClass().getName().equals("javax.swing.plaf.synth.SynthBorder");
        boolean bl2 = innerBorderIsDefault = border instanceof CompoundBorder && ((CompoundBorder)border).getInsideBorder() == defaultBorder;
        if (innerBorderIsDefault) {
            Insets ins = border.getBorderInsets(combo);
            Insets ins_ = defaultBorder.getBorderInsets(combo);
            x += ins.left - ins_.left;
            y += ins.top - ins_.top;
            w -= ins.left - ins_.left + ins.right - ins_.right;
            h -= ins.top - ins_.top + ins.bottom - ins_.bottom;
        }
        if (fillBackground == null || fillBackground.booleanValue()) {
            this.fillBackground(combo, border, defaultBorder, defaultBorderIsSynth, g, background, x, y, w, h);
        }
        if (!defaultBackground && noBorderIfColored) {
            return;
        }
        SyntheticaState state_ = new SyntheticaState(state.getState());
        state_.resetState(SyntheticaState.State.HOVER);
        state_.resetState(SyntheticaState.State.PRESSED);
        if (!defaultBackground && !keepLockedBorderIfColored) {
            state_.resetState(SyntheticaState.State.LOCKED);
        }
        boolean bl3 = keyExists = SyntheticaLookAndFeel.get(key_ = (key = this.getUIKey(combo, "comboBox.border", state_)).get(), combo) != null;
        if (key_.equals("Synthetica.comboBox.border.disabled") && !keyExists || key_.equals("Synthetica.comboBox.border.locked") && !keyExists || key_.equals("Synthetica.comboBox.border.disabled.locked") && !keyExists) {
            key = this.getUIKey(combo, "textField.border", state_);
        }
        String imagePath = key.resolveImagePath(sc, 1);
        if (state.isSet(SyntheticaState.State.FOCUSED) && this.resolveImagePath(String.valueOf(key.get()) + ".focused", combo) != null) {
            imagePath = this.resolveImagePath(String.valueOf(key.get()) + ".focused", combo);
        }
        if (combo.isPopupVisible() && this.resolveImagePath(String.valueOf(key.get()) + ".opened", combo) != null) {
            BasicComboPopup popup;
            block24: {
                imagePath = this.resolveImagePath(String.valueOf(key.get()) + ".opened", combo);
                popup = null;
                try {
                    ComboBoxUI ui = combo.getUI();
                    Method m = ui.getClass().getDeclaredMethod("getPopup", null);
                    popup = (BasicComboPopup)m.invoke((Object)ui, null);
                }
                catch (Exception e) {
                    Accessible a = combo.getUI().getAccessibleChild(combo, 0);
                    if (!(a instanceof BasicComboPopup)) break block24;
                    popup = (BasicComboPopup)a;
                }
            }
            Boolean popupIsBelow = popup == null ? true : MenuPainter.popupIsBelowInvoker(combo, popup);
            if (!(popupIsBelow != null && popupIsBelow.booleanValue() || this.resolveImagePath(String.valueOf(key.get()) + ".openedAndPopupNotBelow", combo) == null)) {
                imagePath = this.resolveImagePath(String.valueOf(key.get()) + ".openedAndPopupNotBelow", combo);
            }
        }
        Insets sInsets = this.getImageInsets("Synthetica.comboBox.border.insets", combo);
        Insets dInsets = this.getImageInsets("Synthetica.comboBox.border.dInsets", combo, sInsets);
        if (!defaultBorderIsSynth) {
            Insets insets = combo.getInsets();
            x += insets.left;
            y += insets.top;
            w += -insets.left - insets.right;
            h += -insets.top - insets.bottom;
            dInsets = new Insets(0, 0, 0, 0);
        }
        ImagePainter imagePainter = new ImagePainter(combo, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        if (!defaultBackground && !keepLockedBorderIfColored) {
            imagePainter.drawBorder();
        } else if (!defaultBorderIsSynth) {
            imagePainter.drawCenter();
        } else {
            imagePainter.draw();
        }
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.comboBox.hoverAndPressed.enabled", combo)) {
            this.paintHoverPressed(combo, state, border, defaultBorder, innerBorderIsDefault, g, x, y, w, h, sInsets, dInsets);
        }
    }

    private void fillBackground(JComponent c, Border border, Border defaultBorder, boolean defaultBorderIsSynth, Graphics g, Color background, int x, int y, int w, int h) {
        Color color = g.getColor();
        g.setColor(background);
        Insets insets = c.getInsets();
        if (border == null || insets.equals(new Insets(0, 0, 0, 0))) {
            g.fillRect(x, y, w, h);
        } else if (!defaultBorderIsSynth) {
            g.fillRect(x + insets.left, y + insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
        } else {
            Insets fillInsets = SyntheticaLookAndFeel.getInsets("Synthetica.comboBox.border.fillInsets", (Component)c, false, true);
            int arcWidth = SyntheticaLookAndFeel.getInt("Synthetica.comboBox.border.arcWidth", c, 8, true);
            int arcHeight = SyntheticaLookAndFeel.getInt("Synthetica.comboBox.border.arcHeight", c, 8, true);
            Graphics2D g2 = (Graphics2D)g;
            RenderingHints rh = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.fillRoundRect(x + fillInsets.left, y + fillInsets.top, w - fillInsets.left - fillInsets.right, h - fillInsets.top - fillInsets.bottom, arcWidth, arcHeight);
            g2.setRenderingHints(rh);
        }
        g.setColor(color);
    }

    private SyntheticaPainterState createState(SynthContext sc, JComboBox<?> cb) {
        int state = 0;
        JButton b = (JButton)SyntheticaLookAndFeel.findComponent(JButton.class, cb);
        if (b != null && b.getModel().isPressed()) {
            state = 4;
        }
        return new SyntheticaPainterState(sc, state, true);
    }

    private void paintHoverPressed(JComboBox<?> combo, SyntheticaPainterState state, Border border, Border defaultBorder, boolean innerBorderIsDefault, Graphics g, int x, int y, int w, int h, Insets sInsets, Insets dInsets) {
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.comboBox.stateChange4ButtonOnly", combo)) {
            boolean ltr = combo.getComponentOrientation().isLeftToRight();
            if (sInsets.equals(dInsets)) {
                dInsets = new Insets(sInsets.top, 0, sInsets.bottom, sInsets.right);
            }
            int buttonWidth = SyntheticaLookAndFeel.findComponent(JButton.class, combo).getWidth();
            Insets insets = innerBorderIsDefault ? defaultBorder.getBorderInsets(combo) : combo.getInsets();
            int relX = SyntheticaLookAndFeel.getInt("Synthetica.comboBox.button.relativeX", combo, 0, true);
            if (defaultBorder != null) {
                x += ltr ? w - insets.right - buttonWidth + relX : 0;
                w = buttonWidth + (ltr ? insets.right : insets.left) - relX;
            } else {
                x += ltr ? w - buttonWidth + relX : 0;
                w = buttonWidth - relX;
            }
        }
        UIKey key = this.getUIKey(combo, "comboBox", state);
        UIKey borderKey = this.getUIKey(combo, "comboBox.border", state);
        String imagePath = UIKey.resolveImagePath(combo, borderKey.get(), null, 1);
        int cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), combo, 1);
        int delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), combo, 50);
        int type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), combo, 2);
        if (state.isSet(SyntheticaState.State.HOVER) || state.isSet(SyntheticaState.State.PRESSED)) {
            type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), combo, 1);
        } else if (!SyntheticaLookAndFeel.getBoolean("Synthetica.animation.enabled", combo, false)) {
            return;
        }
        ImagePainter imagePainter = new ImagePainter(combo, cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        if (defaultBorder == null) {
            imagePainter.drawCenter();
        } else {
            imagePainter.draw();
        }
    }

    protected UIKey getUIKey(JComponent c, String type, SyntheticaState state) {
        return new UIKey(type, state);
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        JComponent c = sc.getComponent();
        int hash = super.getCacheHash(sc, w, h, meta, id);
        if (c instanceof JComboBox) {
            JComboBox combo = (JComboBox)sc.getComponent();
            boolean locked = !combo.isEditable();
            boolean hover = combo.getClientProperty("Synthetica.MOUSE_OVER") == null ? false : (Boolean)combo.getClientProperty("Synthetica.MOUSE_OVER");
            hash = 31 * hash + (locked ? 0 : 1);
            hash = 31 * hash + (hover ? 0 : 1);
            hash = 31 * hash + (this.hasFocus(combo) ? 0 : 1);
        }
        return hash;
    }
}

