/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.GraphicsUtils;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;

public class CheckBoxPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.CheckBoxPainter";
    private static boolean cellRendererSelectionBackgroundEnabled;
    private static SynthStyle tableStyle;
    private static int tableHash;
    private static SynthStyle listStyle;
    private static int listHash;

    protected CheckBoxPainter() {
    }

    public static CheckBoxPainter getInstance() {
        return CheckBoxPainter.getInstance(null);
    }

    public static CheckBoxPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(CheckBoxPainter.getPainterClassName(sc, CheckBoxPainter.class, UI_KEY));
        if (instance == null) {
            instance = CheckBoxPainter.getInstance(sc, CheckBoxPainter.class, UI_KEY);
        }
        return (CheckBoxPainter)instance;
    }

    public static void reinitialize() {
        cellRendererSelectionBackgroundEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.cellRenderer.selectionBackground.enabled", null, false);
        tableHash = 0;
    }

    public void paintCheckBoxBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        SynthContext sc_;
        SynthStyle ss;
        int hashCode;
        AbstractButton b = (AbstractButton)sc.getComponent();
        SyntheticaPainterState state = new SyntheticaPainterState(sc);
        Container parent = b.getParent();
        Container grandParent = parent == null ? null : parent.getParent();
        String cName = b.getName();
        if (cellRendererSelectionBackgroundEnabled && "Table.cellRenderer".equals(cName) && grandParent instanceof JTable) {
            JTable table = (JTable)grandParent;
            hashCode = this.getHashCode(table);
            if (hashCode != tableHash) {
                tableHash = hashCode;
                tableStyle = SynthLookAndFeel.getStyle(table, Region.TABLE);
            }
            ss = tableStyle;
            sc_ = new SynthContext(table, Region.TABLE, ss, 512);
            if (b.getBackground().equals(ss.getColor(sc_, ColorType.TEXT_BACKGROUND))) {
                ((GraphicsUtils)ss.getGraphicsUtils(sc_)).paintTableCellRendererSelectionBackground(table, b, g, x, y, w, h);
            }
        } else if (cellRendererSelectionBackgroundEnabled && this.isListCellRenderer(cName) && grandParent instanceof JList) {
            JList list = (JList)grandParent;
            hashCode = this.getHashCode(list);
            if (hashCode != listHash) {
                listHash = hashCode;
                listStyle = SynthLookAndFeel.getStyle(list, Region.LIST);
            }
            ss = listStyle;
            sc_ = new SynthContext(list, Region.LIST, ss, 512);
            if (b.getBackground().equals(ss.getColor(sc_, ColorType.TEXT_BACKGROUND))) {
                ((GraphicsUtils)ss.getGraphicsUtils(sc_)).paintListCellRendererSelectionBackground(list, b, g, x, y, w, h);
            }
        }
        if (SyntheticaLookAndFeel.get("Synthetica.checkBox.image", b) != null) {
            boolean custom;
            Insets sInsets;
            UIKey key = new UIKey("checkBox", state);
            Insets dInsets = sInsets = new Insets(0, 0, 0, 0);
            Insets insets = b.getInsets();
            String imagePath = this.resolveImagePath(key.get("image"), b);
            if (b.hasFocus() && this.resolveImagePath(String.valueOf(key.get()) + ".focused.image", b) != null) {
                imagePath = this.resolveImagePath(String.valueOf(key.get()) + ".focused.image", b);
            }
            int cycles = SyntheticaLookAndFeel.getInt(key.get("animation.cycles"), (Component)b, 1);
            int delay = SyntheticaLookAndFeel.getInt(key.get("animation.delay"), (Component)b, 50);
            int type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)b, 2);
            if (state.isSet(SyntheticaState.State.HOVER) || state.isSet(SyntheticaState.State.PRESSED)) {
                type = SyntheticaLookAndFeel.getInt(key.get("animation.type"), (Component)b, 1);
            }
            Rectangle viewRect = new Rectangle(x + insets.left, y + insets.top, w - insets.left - insets.right, h - insets.top - insets.bottom);
            Rectangle textRect = new Rectangle();
            Rectangle iconRect = new Rectangle();
            Icon icon = sc.getStyle().getIcon(sc, "CheckBox.icon");
            sc.getStyle().getGraphicsUtils(sc).layoutText(sc, g.getFontMetrics(), b.getText(), icon, b.getHorizontalAlignment(), b.getVerticalAlignment(), b.getHorizontalTextPosition(), b.getVerticalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
            boolean bl = custom = b.getIcon() != null;
            if (!custom) {
                ImagePainter imagePainter = new ImagePainter((JComponent)b, cycles, delay, type, state.getState(), g, iconRect.x, iconRect.y, iconRect.width, iconRect.height, imagePath, sInsets, dInsets, 0, 0);
                if (!state.isSet(SyntheticaState.State.PRESSED) || b.getPressedIcon() == null) {
                    imagePainter.drawCenter();
                }
            }
            if (state.isSet(SyntheticaState.State.FOCUSED) && b.isFocusPainted() && SyntheticaLookAndFeel.get("Synthetica.checkBox.focus", b) != null) {
                String name = SyntheticaLookAndFeel.getStyleName(b);
                String propertyKey = "focus.checkBox";
                cycles = SyntheticaLookAndFeel.getInt(propertyKey, "animation.cycles", name, true, -1);
                delay = SyntheticaLookAndFeel.getInt(propertyKey, "animation.delay", name, true, 60);
                type = SyntheticaLookAndFeel.getInt(propertyKey, "animation.type", name, true, 3);
                imagePath = this.resolveImagePath("Synthetica.checkBox.focus", b);
                ImagePainter imagePainter = new ImagePainter(b, "", cycles, delay, type, state.getState(), g, iconRect.x, iconRect.y, iconRect.width, iconRect.height, imagePath, sInsets, dInsets, 0, 0);
                imagePainter.drawCenter();
            }
        }
        if (state.isSet(SyntheticaState.State.FOCUSED) && b.isFocusPainted()) {
            boolean isHtml;
            Icon icon = b.getIcon() == null ? sc.getStyle().getIcon(sc, "CheckBox.icon") : b.getIcon();
            String text = b.getText();
            int textGap = text == null || text.length() == 0 ? 0 : b.getIconTextGap();
            int w_ = b.getInsets().left + b.getInsets().right + textGap + (icon == null ? 0 : icon.getIconWidth());
            boolean bl = isHtml = b.getClientProperty("html") != null;
            if (!isHtml) {
                FontMetrics fm = b.getFontMetrics(sc.getStyle().getFont(sc));
                if (text != null) {
                    w_ += fm.stringWidth(text);
                }
            } else {
                w_ = (int)((float)w_ + ((View)b.getClientProperty("html")).getPreferredSpan(0));
            }
            FocusPainter.paintFocus("focus.checkBox", sc, g, x, y, w_, h);
        }
    }

    private boolean isListCellRenderer(String name) {
        return name == null ? false : name.startsWith("List.cellRenderer");
    }

    public void paintCheckBoxBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        JCheckBox cb = (JCheckBox)context.getComponent();
        if (cb.isBorderPainted()) {
            Insets sInsets;
            Insets dInsets = sInsets = this.getImageInsets("Synthetica.checkBox.border.insets", cb);
            String imagePath = this.resolveImagePath("Synthetica.checkBox.border", cb);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.drawBorder();
        }
    }

    private int getHashCode(JComponent c) {
        int hash = c.hashCode();
        String name = SyntheticaLookAndFeel.getStyleName(c);
        if (name == null) {
            return hash;
        }
        return 31 * hash + name.hashCode();
    }
}

