/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.filechooser;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.io.FileOperationEvent;
import de.javasoft.plaf.synthetica.io.FileOperationListener;
import de.javasoft.plaf.synthetica.io.FileProperties;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class FilePropertiesDialog
extends JDialog
implements FileOperationListener,
Runnable {
    private boolean abort;
    private long counter = 0L;
    private JLabel location;
    private JLabel files;
    private JLabel size;
    private JLabel date;
    private FileProperties props;
    private Color brightLabelColor;
    private Color labelColor;
    private static final int xGap = SyntheticaLookAndFeel.getInstance().scaleInteger(10);
    private static final int yGap = SyntheticaLookAndFeel.getInstance().scaleInteger(10);
    String title = "";
    String imagePath = "";
    Insets imageInsets;

    public FilePropertiesDialog(Window owner) {
        super(owner);
        this.init(owner);
    }

    private void init(Window owner) {
        Image iconImage = null;
        this.title = UIManager.getString("FilePropertiesDialog.title");
        this.imagePath = UIManager.getString("Synthetica.filePropertiesDialog.title.background");
        this.imageInsets = SyntheticaLookAndFeel.getInsets("Synthetica.filePropertiesDialog.title.background.insets", null, new Insets(0, 0, 4, 100), false);
        iconImage = (Image)UIManager.get("Synthetica.filePropertiesDialog.iconImage");
        this.setTitle(this.title);
        this.setLayout(new BorderLayout());
        this.getRootPane().putClientProperty("Synthetica.dialog.iconImage", iconImage);
        JPanel topPanel = new JPanel(){
            private Image background;
            {
                this.background = new ImageIcon(SyntheticaLookAndFeel.getResource(FilePropertiesDialog.this.imagePath)).getImage();
            }

            @Override
            public void paintComponent(Graphics g) {
                ImagePainter imagePainter = new ImagePainter(this.background, g, 0, 0, this.getWidth(), SyntheticaLookAndFeel.getInstance().scaleInteger(this.background.getHeight(null)), FilePropertiesDialog.this.imageInsets, FilePropertiesDialog.this.imageInsets);
                imagePainter.draw();
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                int xPos = SyntheticaLookAndFeel.getInt("Synthetica.filePropertiesDialog.title.xPos", null, true);
                int yPos = SyntheticaLookAndFeel.getInt("Synthetica.filePropertiesDialog.title.yPos", null, true);
                g2.drawString(FilePropertiesDialog.this.title, xPos, yPos);
                g2.dispose();
            }

            @Override
            public Dimension getPreferredSize() {
                int w = SyntheticaLookAndFeel.getInstance().scaleInteger(this.background.getWidth(null));
                int h = SyntheticaLookAndFeel.getInstance().scaleInteger(this.background.getHeight(null));
                return new Dimension(w, h);
            }
        };
        float fontSize = SyntheticaLookAndFeel.getInstance().scaleFontSize(UIManager.getInt("Synthetica.filePropertiesDialog.title.size"));
        topPanel.setFont(topPanel.getFont().deriveFont(1, fontSize));
        topPanel.setForeground(UIManager.getColor("Synthetica.filePropertiesDialog.title.color"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(yGap, xGap, yGap, xGap));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JPanel aniPanel = new JPanel(new BorderLayout());
        panel.add((Component)aniPanel, gbc);
        gbc.insets = new Insets(0, 0, yGap, 0);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.files = new JLabel("!");
        this.labelColor = this.files.getForeground();
        this.brightLabelColor = new Color(this.labelColor.getRGB() + 0x606060);
        this.files.setForeground(this.brightLabelColor);
        panel.add((Component)this.files, gbc);
        gbc.insets = new Insets(0, 0, yGap / 4, xGap);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        JLabel locationLabel = new JLabel(UIManager.getString("FilePropertiesDialog.location"));
        panel.add((Component)locationLabel, gbc);
        gbc.insets = new Insets(0, 0, yGap / 4, 0);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.location = new JLabel();
        panel.add((Component)this.location, gbc);
        gbc.insets = new Insets(0, 0, yGap / 4, xGap);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        JLabel sizeLabel = new JLabel(UIManager.getString("FilePropertiesDialog.size"));
        panel.add((Component)sizeLabel, gbc);
        gbc.insets = new Insets(0, 0, yGap / 4, 0);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.size = new JLabel();
        this.size.setForeground(this.brightLabelColor);
        panel.add((Component)this.size, gbc);
        gbc.insets = new Insets(0, 0, yGap * 2, xGap);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        JLabel dateLabel = new JLabel(UIManager.getString("FilePropertiesDialog.date"));
        panel.add((Component)dateLabel, gbc);
        gbc.insets = new Insets(0, 0, yGap * 2, 0);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.date = new JLabel();
        panel.add((Component)this.date, gbc);
        gbc.anchor = owner.getComponentOrientation().isLeftToRight() ? 13 : 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        JButton okButton = new JButton(UIManager.getString("FilePropertiesDialog.ok"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePropertiesDialog.this.abort = true;
                FilePropertiesDialog.this.dispose();
            }
        });
        okButton.setMinimumSize(new Dimension(okButton.getPreferredSize().width * 2, okButton.getPreferredSize().height));
        okButton.setPreferredSize(okButton.getMinimumSize());
        panel.add((Component)okButton, gbc);
        this.add((Component)topPanel, "North");
        this.add(panel);
        this.pack();
        int x = owner.getLocation().x + owner.getSize().width / 2;
        int xLoc = x - this.getSize().width / 2;
        int y = owner.getLocation().y + owner.getSize().height / 2;
        int yLoc = y - this.getSize().height / 2;
        this.setLocation(xLoc, yLoc);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FilePropertiesDialog.this.abort = true;
            }
        });
    }

    @Override
    public boolean processFileOperationEvent(FileOperationEvent evt) {
        ++this.counter;
        this.props = (FileProperties)evt.getSource();
        if (this.counter % 100L == 0L || this.counter < 10L) {
            EventQueue.invokeLater(this);
        }
        return !this.abort;
    }

    @Override
    public void run() {
        NumberFormat nf = NumberFormat.getInstance();
        String filesFormat = UIManager.getString("FilePropertiesDialog.filesFormat");
        String numberOfDirectories = nf.format(this.props.directories);
        String numberOfFiles = nf.format(this.props.files);
        this.files.setText(MessageFormat.format(filesFormat, numberOfFiles, numberOfDirectories));
        String sizeFormat = UIManager.getString("FilePropertiesDialog.sizeFormat");
        String sizeBytes = nf.format(this.props.size);
        nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        String sizeMB = nf.format((double)this.props.size / 1024.0 / 1024.0);
        this.size.setText(MessageFormat.format(sizeFormat, sizeBytes, sizeMB));
        this.location.setText(this.props.location);
        if (this.props.directories + this.props.files == 1L) {
            SimpleDateFormat df = new SimpleDateFormat(UIManager.getString("FilePropertiesDialog.dateFormat"));
            this.date.setText(df.format(new Date(this.props.lastModified)));
        } else {
            this.date.setText("---");
        }
    }

    public void refresh() {
        this.counter = 0L;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FilePropertiesDialog.this.files.setForeground(FilePropertiesDialog.this.labelColor);
                FilePropertiesDialog.this.size.setForeground(FilePropertiesDialog.this.labelColor);
            }
        });
        EventQueue.invokeLater(this);
    }
}

