/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.plaf.UIResource;

public class SyntheticaSpinnerLayoutManager
implements LayoutManager,
UIResource {
    private static Insets editorInsets = new JFormattedTextField((Object)0).getInsets();
    private JComponent nextButton = null;
    private JComponent previousButton = null;
    private JComponent editor = null;

    @Override
    public void addLayoutComponent(String name, Component c) {
        if ("Next".equals(name)) {
            this.nextButton = (JComponent)c;
        } else if ("Previous".equals(name)) {
            this.previousButton = (JComponent)c;
        } else if ("Editor".equals(name)) {
            this.editor = (JComponent)c;
        }
    }

    @Override
    public void removeLayoutComponent(Component c) {
        if (c == this.nextButton) {
            this.nextButton = null;
        } else if (c == this.previousButton) {
            this.previousButton = null;
        } else if (c == this.editor) {
            this.editor = null;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension nextDim = this.getPrefSize(this.nextButton);
        Dimension previousDim = this.getPrefSize(this.previousButton);
        Dimension editorDim = this.getPrefSize(this.editor);
        editorDim.height = (editorDim.height + 1) / 2 * 2 + SyntheticaSpinnerLayoutManager.editorInsets.top + SyntheticaSpinnerLayoutManager.editorInsets.bottom;
        Dimension size = new Dimension(editorDim.width, editorDim.height);
        size.width += Math.max(nextDim.width, previousDim.width);
        Insets insets = parent.getInsets();
        size.width += insets.left + insets.right;
        return size;
    }

    private Dimension getPrefSize(Component c) {
        return c == null ? new Dimension(0, 0) : c.getPreferredSize();
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        int buttonsX;
        int editorX;
        Insets insets = parent.getInsets();
        int width = parent.getWidth() - insets.left - insets.right;
        int height = parent.getHeight() - insets.top - insets.bottom;
        int buttonsWidth = Math.max(this.getPrefSize((Component)this.nextButton).width, this.getPrefSize((Component)this.previousButton).width);
        int editorWidth = width - buttonsWidth;
        if (parent.getComponentOrientation().isLeftToRight()) {
            editorX = insets.left;
            buttonsX = editorX + editorWidth;
        } else {
            buttonsX = insets.left;
            editorX = buttonsX + buttonsWidth;
        }
        this.setChildBounds(this.editor, editorX, insets.top, editorWidth, height);
        int nextHeight = height / 2;
        int previousHeight = height - nextHeight;
        this.setChildBounds(this.nextButton, buttonsX, insets.top, buttonsWidth, nextHeight);
        this.setChildBounds(this.previousButton, buttonsX, insets.top + nextHeight, buttonsWidth, previousHeight);
    }

    private void setChildBounds(Component c, int x, int y, int width, int height) {
        if (c != null) {
            c.setBounds(x, y, width, height);
        }
    }
}

