/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaMenuItemUI;
import de.javasoft.plaf.synthetica.painter.MenuPainter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthConstants;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaMenuUI
extends BasicMenuUI
implements PropertyChangeListener,
SynthConstants {
    private String acceleratorDelimiter;

    public static ComponentUI createUI(JComponent x) {
        return new SyntheticaMenuUI();
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.menuItem);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.menuItem.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuItem mi) {
        String prefix = this.getPropertyPrefix();
        SynthContext sc = SyntheticaMenuItemUI.getContext((JComponent)mi, 1);
        SynthStyle style = SyntheticaMenuItemUI.getStyle(mi);
        style.installDefaults(sc);
        this.defaultTextIconGap = style.getInt(sc, String.valueOf(prefix) + ".textIconGap", 4);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            Insets insets = (Insets)style.get(sc, String.valueOf(prefix) + ".margin");
            if (insets == null) {
                insets = new InsetsUIResource(0, 0, 0, 0);
            }
            this.menuItem.setMargin(insets);
        }
        this.acceleratorDelimiter = style.getString(sc, String.valueOf(prefix) + ".acceleratorDelimiter", "+");
        this.arrowIcon = style.getIcon(sc, String.valueOf(prefix) + ".arrowIcon");
        this.checkIcon = style.getIcon(sc, String.valueOf(prefix) + ".checkIcon");
        ((JMenu)this.menuItem).setDelay(style.getInt(sc, String.valueOf(prefix) + ".delay", 200));
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        SynthContext sc = SyntheticaMenuItemUI.getMenuItemContext(c);
        SynthContext accContext = SyntheticaMenuItemUI.getContext(c, Region.MENU_ITEM_ACCELERATOR);
        Dimension value = SyntheticaMenuItemUI.getPreferredMenuItemSize(sc, accContext, this.isTopLevelMenu(), c, checkIcon, arrowIcon, defaultTextIconGap, this.acceleratorDelimiter);
        return value;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext sc = SyntheticaMenuItemUI.getContext(c);
        this.paintBackground(sc, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(sc, g);
        this.paintBorder(sc, g, 0, 0, c.getWidth(), c.getHeight());
    }

    private void paintBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintMenuBackground(sc, g, x, y, w, h);
    }

    private void paintBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        MenuPainter.getInstance(sc).paintMenuBorder(sc, g, x, y, w, h);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paint(SyntheticaMenuItemUI.getContext(c), g);
    }

    private void paint(SynthContext sc, Graphics g) {
        SynthStyle ss = sc.getStyle();
        String prefix = this.getPropertyPrefix();
        Icon arrowIcon = ss.getIcon(sc, String.valueOf(prefix) + ".arrowIcon");
        Icon checkIcon = ss.getIcon(sc, String.valueOf(prefix) + ".checkIcon");
        SynthContext accContext = SyntheticaMenuItemUI.getContext((JComponent)this.menuItem, Region.MENU_ITEM_ACCELERATOR);
        sc = SyntheticaMenuItemUI.getMenuItemContext(sc.getComponent());
        SyntheticaMenuItemUI.paint(sc, accContext, g, checkIcon, arrowIcon, this.isTopLevelMenu(), this.acceleratorDelimiter, this.defaultTextIconGap);
    }

    private boolean isTopLevelMenu() {
        return ((JMenu)this.menuItem).isTopLevelMenu();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (SyntheticaLookAndFeel.shouldUpdateStyle(evt)) {
            this.updateStyle((JMenu)evt.getSource());
        }
    }
}

