/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.AddonsXMLProvider;
import de.javasoft.plaf.synthetica.ExtKeyEventProcessor;
import de.javasoft.plaf.synthetica.PopupFactory;
import de.javasoft.plaf.synthetica.ResourceBaseProvider;
import de.javasoft.plaf.synthetica.ScalableIcon;
import de.javasoft.plaf.synthetica.StyleFactory;
import de.javasoft.plaf.synthetica.SyntheticaDefaultLookup;
import de.javasoft.plaf.synthetica.SyntheticaInputDefaults;
import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import de.javasoft.plaf.synthetica.SyntheticaScrollPaneCorner;
import de.javasoft.plaf.synthetica.SyntheticaTitledBorder;
import de.javasoft.plaf.synthetica.SyntheticaWindowShape;
import de.javasoft.plaf.synthetica.painter.CheckBoxPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.LabelPainter;
import de.javasoft.plaf.synthetica.painter.MenuPainter;
import de.javasoft.plaf.synthetica.painter.TabbedPanePainter;
import de.javasoft.plaf.synthetica.painter.TreePainter;
import de.javasoft.plaf.synthetica.styles.InternalFrameTitlePaneStyle;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import de.javasoft.plaf.synthetica.util.OS;
import de.javasoft.util.IVersion;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlException;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import sun.swing.DefaultLookup;
import sun.swing.plaf.synth.DefaultSynthStyle;

public abstract class SyntheticaLookAndFeel
extends SynthLookAndFeel {
    public static final Logger logger = Logger.getLogger(SyntheticaLookAndFeel.class.getName());
    private static Font defaultFont;
    private static boolean antiAliasEnabled;
    private static Dimension toolbarSeparatorDimension;
    private static HashMap<String, Icon> iconCache;
    private static int systemScaleFactor;
    private static Boolean uiScaleEnabled;
    private static SyntheticaLookAndFeel activeInstance;
    private static boolean decorated;
    private static boolean extendedFileChooserEnabled;
    private static Boolean rememberFileChooserPreferences;
    private static boolean useSystemFileIcons;
    private static boolean defaultsCompatibilityMode;
    private KeyEventPostProcessor extKeyEventProcessor;
    private PropertyChangeListener lafChangeListener;
    private UIDefaults orgDefaults;
    private static boolean debug;
    private static boolean outputVersion;
    private static final boolean NOSTYLE = false;
    private static UIDefaults uiDefaults;
    private HashMap<String, Class<?>> imageResourceBaseMap = new HashMap();
    private String lafXMLFile;
    private boolean menuOffsetsScaled;
    private ResourceBaseProvider resourceBaseProvider;

    static {
        iconCache = new HashMap();
        systemScaleFactor = SyntheticaLookAndFeel.getSystemPropertyInt("synthetica.scaleFactor", 100);
        decorated = true;
        extendedFileChooserEnabled = true;
        useSystemFileIcons = true;
        defaultsCompatibilityMode = true;
        debug = SyntheticaLookAndFeel.isSystemPropertySet("synthetica.debug");
        outputVersion = SyntheticaLookAndFeel.isSystemPropertySet("synthetica.version");
        Thread t = new Thread(){
            private boolean dialogOpen;
            private int millis = 15000;

            @Override
            public void run() {
                block2: while (true) {
                    try {
                        while (true) {
                            1.sleep(this.millis);
                            this.millis = (1800 + new Random().nextInt(3600)) * 1000;
                            if (this.check()) break block2;
                            if (this.dialogOpen) continue;
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.showDialog();
                                }
                            });
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private boolean check() {
                String iKey = "Synthetica.license.info";
                String kKey = "Synthetica.license.key";
                String[] li = (String[])UIManager.get(iKey);
                String lk = (String)UIManager.get(kKey);
                if (li == null) {
                    try {
                        Properties p = new Properties();
                        p.load(this.getClass().getResourceAsStream("/de/javasoft/synthetica/license/synthetica.lic"));
                        li = ((String)p.get(iKey)).split(",");
                        lk = (String)p.get(kKey);
                    }
                    catch (Exception p) {
                        // empty catch block
                    }
                    if (li == null) {
                        try {
                            li = System.getProperty(iKey).split(",");
                            lk = System.getProperty(kKey);
                        }
                        catch (Exception p) {
                            // empty catch block
                        }
                    }
                }
                if (li == null || lk == null) return false;
                try {
                    SimpleDateFormat sdf;
                    Date d;
                    TreeMap<String, String> map = new TreeMap<String, String>();
                    String[] stringArray = li;
                    int n = li.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        String[] entry = s.split("=");
                        map.put(entry[0], entry[1]);
                        ++n2;
                    }
                    if (!lk.equals(this.createKey(map)) || !"Synthetica".equals(map.get("Product"))) {
                        throw new RuntimeException();
                    }
                    String exp = map.get("ExpireDate");
                    if (!"--.--.----".equals(exp) && new Date().after(d = (sdf = new SimpleDateFormat("dd.MM.yyyy")).parse(exp))) {
                        throw new RuntimeException();
                    }
                    String lrn = map.get("LicenseRegistrationNumber");
                    HashMap<String, String> banned = new HashMap<String, String>();
                    banned.put("347713735", "01.01.2004");
                    banned.put("139066605", "01.01.2004");
                    for (Map.Entry entry : banned.entrySet()) {
                        Date d2;
                        Date current;
                        if (!((String)entry.getKey()).equals(lrn) || !(current = new Date()).after(d2 = new SimpleDateFormat("dd.MM.yyyy").parse((String)entry.getValue())) || current.getTime() % 3L != 0L) continue;
                        throw new RuntimeException();
                    }
                    String[] stringArray2 = map.get("MaxVersion").split("\\.");
                    int maj = Integer.parseInt(stringArray2[0]);
                    int min = Integer.parseInt(stringArray2[1]);
                    int rev = Integer.parseInt(stringArray2[2]);
                    Version v = new Version();
                    if (v.getMajor() <= maj && (v.getMajor() != maj || v.getMinor() <= min) && (v.getMajor() != maj || v.getMinor() != min || v.getRevision() <= rev)) return true;
                    throw new RuntimeException();
                }
                catch (Exception exception) {
                    try {
                        return false;
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                return false;
            }

            private String createKey(TreeMap<String, String> m) throws Exception {
                StringBuilder sbm = new StringBuilder();
                for (Map.Entry<String, String> entry : m.entrySet()) {
                    sbm.append(entry).append("\n");
                }
                MessageDigest d = MessageDigest.getInstance("SHA3-256");
                d.reset();
                d.update(sbm.toString().getBytes("UTF-8"));
                byte[] b = d.digest();
                StringBuilder sb = new StringBuilder(b.length * 2);
                int i = 0;
                while (i < b.length) {
                    int v = b[i] & 0xFF;
                    if (v < 16) {
                        sb.append('0');
                    }
                    sb.append(Integer.toHexString(v));
                    if (i % 4 == 3 && i < b.length - 1) {
                        sb.append("-");
                    }
                    ++i;
                }
                return sb.toString().toUpperCase();
            }

            private void showDialog() {
                this.dialogOpen = true;
                String message = "<html>It looks like you are using an invalid or outdated <b>Synthetica</b> license.<br>Please post your License Registration Number to the <b>Support Center</b><br> and request a valid license key.";
                Window w = FocusManager.getCurrentManager().getActiveWindow();
                JOptionPane.showMessageDialog(w, message, "Synthetica License Warning", 2);
                this.dialogOpen = false;
            }
        };
        t.setDaemon(true);
        if (!SyntheticaRootPaneUI.isEvalCopy()) {
            t.start();
        }
    }

    public SyntheticaLookAndFeel() throws ParseException {
    }

    public SyntheticaLookAndFeel(String fileName) throws ParseException {
        this(fileName, null);
    }

    public SyntheticaLookAndFeel(String fileName, String xmlProviderPath) throws ParseException {
        this.lafXMLFile = fileName;
        if (this.getVersion().getMajor() < 3) {
            throw new RuntimeException("Version conflict - please make sure a Synthetica V3 theme is specified or migrate theme '" + this.getName() + "' " + this.getVersion() + " to V3!");
        }
        this.loadXMLConfig(null, fileName);
        if (fileName.endsWith(".xml")) {
            this.loadAddonsXMLConfig(null, xmlProviderPath == null ? "addon" : xmlProviderPath);
        }
        this.loadCustomXML();
    }

    public String getConfigFileName() {
        return this.lafXMLFile;
    }

    protected void loadCustomXML() throws ParseException {
    }

    protected void loadAddonsXMLConfig(Class<?> resourceBase, String path) throws ParseException {
        String packageName = path.replace("/", ".");
        if (packageName.startsWith(".")) {
            packageName = packageName.substring(1);
        } else {
            Class<?> clazz = resourceBase == null ? this.getResourceBase(path) : resourceBase;
            packageName = String.valueOf(clazz.getPackage().getName()) + "." + path.replace("/", ".");
        }
        try {
            Class<?> providerClass = Class.forName(String.valueOf(packageName) + ".XMLProvider");
            AddonsXMLProvider provider = (AddonsXMLProvider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String[] stringArray = provider.getXMLFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                InputStream is = providerClass.getResourceAsStream(fileName);
                if (is == null) {
                    throw new RuntimeException("File not found: " + fileName);
                }
                this.load(is, providerClass);
                ++n2;
            }
        }
        catch (ClassNotFoundException providerClass) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void loadXMLConfig(Class<?> resourceBase, String fileName) throws ParseException {
        Class<?> clazz;
        long start = System.currentTimeMillis();
        Class<?> clazz2 = clazz = resourceBase == null ? this.getResourceBase(fileName) : resourceBase;
        if (fileName.endsWith(".xml")) {
            InputStream is = clazz.getResourceAsStream(fileName);
            if (is == null) {
                throw new RuntimeException("File not found: " + fileName);
            }
            try {
                this.load(is, clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String[] paths = new String[]{fileName};
        String syntheticaPath = clazz.getPackage().getName().replace(".", "/");
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try {
                String fullPath;
                fullPath = path.startsWith("/") ? (fullPath = path.substring(1)) : String.valueOf(syntheticaPath) + "/" + path;
                Enumeration<URL> urls = clazz.getClassLoader().getResources(fullPath);
                while (urls.hasMoreElements()) {
                    File[] files;
                    URL url = urls.nextElement();
                    if (url.getProtocol().equalsIgnoreCase("jar")) {
                        JarURLConnection conn = (JarURLConnection)url.openConnection();
                        JarFile jar = conn.getJarFile();
                        for (JarEntry entry : Collections.list(jar.entries())) {
                            if (!entry.getName().endsWith(".xml") || !entry.getName().startsWith(fullPath)) continue;
                            this.load(clazz.getResourceAsStream("/" + entry.getName()), clazz);
                        }
                        continue;
                    }
                    URI uri = new URI(url.toString());
                    File[] fileArray = files = new File(uri.getPath()).listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.getName().endsWith(".xml");
                        }
                    });
                    int n3 = files.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File f = fileArray[n4];
                        this.load(f.toURI().toURL().openStream(), clazz);
                        ++n4;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        if (SyntheticaLookAndFeel.isSystemPropertySet("synthetica.enhancedXMLLookup")) {
            try {
                String syntheticaFileName = "Synthetica.xml";
                this.load(clazz.getResourceAsStream("/" + syntheticaFileName), clazz);
                if (debug) {
                    System.out.println("[Info] Found '" + syntheticaFileName + "' configuration file.");
                }
            }
            catch (IllegalArgumentException syntheticaFileName) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String className = this.getClass().getName();
            try {
                String syntheticaFileName = String.valueOf(className.substring(className.lastIndexOf(".") + 1)) + ".xml";
                this.load(clazz.getResourceAsStream("/" + syntheticaFileName), clazz);
                if (debug) {
                    System.out.println("[Info] Found '" + syntheticaFileName + "' configuration file.");
                }
            }
            catch (IllegalArgumentException syntheticaFileName) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        long stop = System.currentTimeMillis();
        if (SyntheticaLookAndFeel.isSystemPropertySet("synthetica.loadTime")) {
            System.out.println("Time for loading LAF: " + (stop - start) + "ms");
        }
        if (SyntheticaLookAndFeel.isSystemPropertySet("synthetica.blockLAFChange")) {
            System.out.println("LAF switchings will be blocked!");
            this.blockLAFChange();
        }
        if (debug) {
            System.out.println("Synthetica debug mode is enabled!");
        }
        if (outputVersion) {
            System.out.format("Synthetica V%s\n%s V%s\n", this.getSyntheticaVersion().toString(), this.getName(), this.getVersion().toString());
        }
    }

    @Override
    public void load(InputStream input, Class<?> resourceBase) throws ParseException {
        HashMap<Object, Object> oldMap = new HashMap<Object, Object>();
        oldMap.putAll(this.getDefaults());
        super.load(input, resourceBase);
        HashMap<Object, Object> newMap = new HashMap<Object, Object>();
        newMap.putAll(this.getDefaults());
        newMap.entrySet().removeAll(oldMap.entrySet());
        for (Map.Entry entry : newMap.entrySet()) {
            String[] paths;
            Object val = entry.getValue();
            if (!(val instanceof String) || !((String)val).endsWith(".png") && !((String)val).endsWith(".jpg")) continue;
            String[] stringArray = paths = ((String)val).split(",");
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (resourceBase.getResource(path) != null) {
                    this.imageResourceBaseMap.put(path, resourceBase);
                }
                ++n2;
            }
        }
    }

    @Override
    public abstract String getID();

    @Override
    public abstract String getName();

    @Override
    public String getDescription() {
        return "Synthetica - the extended Synth Look and Feel.";
    }

    public IVersion getVersion() {
        String packageName = String.valueOf(this.getResourceBase(null).getPackage().getName().replace('.', '/')) + "/resources";
        String bundleName = String.valueOf(packageName) + "/" + "version";
        ResourceBundle rb = ResourceBundle.getBundle(bundleName, this.getClass().getModule());
        final int major = Integer.parseInt(rb.getString("major"));
        final int minor = Integer.parseInt(rb.getString("minor"));
        final int revision = Integer.parseInt(rb.getString("revision"));
        final int build = Integer.parseInt(rb.getString("build"));
        return new IVersion(){

            @Override
            public int getMajor() {
                return major;
            }

            @Override
            public int getMinor() {
                return minor;
            }

            @Override
            public int getRevision() {
                return revision;
            }

            @Override
            public int getBuild() {
                return build;
            }

            @Override
            public String toString() {
                return String.valueOf(major) + "." + minor + "." + revision + " Build " + build;
            }
        };
    }

    static boolean shouldUpdateStyle(PropertyChangeEvent evt) {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return laf instanceof SyntheticaLookAndFeel && ((SyntheticaLookAndFeel)laf).shouldUpdateStyleOnEvent(evt);
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    public static SyntheticaLookAndFeel getInstance() {
        return activeInstance;
    }

    public static URL getResource(String name) {
        return SyntheticaLookAndFeel.getImageResourceBase(name).getResource(name);
    }

    private static Class<?> getImageResourceBase(String name) {
        Class<?> resourceBase = SyntheticaLookAndFeel.getInstance().imageResourceBaseMap.get(name);
        if (resourceBase == null) {
            resourceBase = SyntheticaLookAndFeel.getInstance().getResourceBase(name);
        }
        return resourceBase;
    }

    public void registerImageResourceBase(Class<?> resourceBase, String path) {
        this.imageResourceBaseMap.put(path, resourceBase);
    }

    public void unregisterImageResourceBase(String path) {
        this.imageResourceBaseMap.remove(path);
    }

    public Class<?> getResourceBase(Object resource) {
        Class<?> resourceBase;
        ResourceBaseProvider provider = this.getResourceBaseProvider();
        if (provider != null && (resourceBase = provider.getResourceBase(resource)) != null) {
            return resourceBase;
        }
        Class<?> clazz = this.getClass();
        while (clazz.getSuperclass() != SyntheticaLookAndFeel.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public void setResourceBaseProvider(ResourceBaseProvider provider) {
        this.resourceBaseProvider = provider;
    }

    protected ResourceBaseProvider getResourceBaseProvider() {
        return this.resourceBaseProvider;
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults defaults = super.getDefaults();
        return defaults;
    }

    private void addResourceBundleToDefaults(String name, Map<Object, Object> defaults) {
        ResourceBundle resBundle = SyntheticaLookAndFeel.getResourceBundle(name, Locale.getDefault(), this.getClass().getModule());
        Enumeration<String> enumeration = resBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            String value = resBundle.getString(key);
            defaults.put(key, value);
        }
    }

    @Override
    public void initialize() {
        PropertyChangeListener l;
        PropertyChangeListener[] listeners;
        activeInstance = this;
        super.initialize();
        this.orgDefaults = (UIDefaults)UIManager.getDefaults().clone();
        if (SyntheticaLookAndFeel.getJVMCompatibilityMode() == JVMCompatibilityMode.SUN) {
            try {
                Class<?> clazz = Class.forName("sun.swing.DefaultLookup");
                Method m = clazz.getMethod("setDefaultLookup", DefaultLookup.class);
                m.invoke(clazz, new SyntheticaDefaultLookup());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        StyleFactory styleFactory = new StyleFactory(SyntheticaLookAndFeel.getStyleFactory());
        SynthLookAndFeel.setStyleFactory(styleFactory);
        PopupFactory.install();
        this.lafChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String fontSize;
                String font;
                SyntheticaLookAndFeel.setFont(null);
                SyntheticaLookAndFeel.this.reinit();
                SyntheticaLookAndFeel.this.installSyntheticaDefaults();
                if (defaultsCompatibilityMode) {
                    SyntheticaLookAndFeel.this.installCompatibilityDefaults();
                }
                if ((font = System.getProperty("synthetica.font")) != null) {
                    SyntheticaLookAndFeel.setFont(new Font(font, SyntheticaLookAndFeel.getFont().getStyle(), SyntheticaLookAndFeel.getFont().getSize()));
                }
                if ((fontSize = System.getProperty("synthetica.fontsize")) != null) {
                    SyntheticaLookAndFeel.setFont(SyntheticaLookAndFeel.getFont().deriveFont(Float.parseFloat(fontSize)));
                }
                SyntheticaLookAndFeel.updateAllWindowShapes();
            }
        };
        PropertyChangeListener[] propertyChangeListenerArray = listeners = UIManager.getPropertyChangeListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            l = propertyChangeListenerArray[n2];
            UIManager.removePropertyChangeListener(l);
            ++n2;
        }
        UIManager.addPropertyChangeListener(this.lafChangeListener);
        propertyChangeListenerArray = listeners;
        n = listeners.length;
        n2 = 0;
        while (n2 < n) {
            l = propertyChangeListenerArray[n2];
            UIManager.addPropertyChangeListener(l);
            ++n2;
        }
    }

    private void reinit() {
        this.menuOffsetsScaled = false;
        iconCache.clear();
        LabelPainter.reinitialize();
        CheckBoxPainter.reinitialize();
        MenuPainter.reinitialize();
        TreePainter.reinitialize();
        TabbedPanePainter.reinitialize();
        ImagePainter.clearImageCache();
        StyleWrapper.reinitialize();
        StyleFactory.reinitialize();
    }

    protected void installSyntheticaDefaults() {
        uiDefaults = UIManager.getDefaults();
        uiDefaults.put("HyperlinkUI", "de.javasoft.syntheticaaddons.ui.HyperlinkUI");
        uiDefaults.put("StatusBarUI", "de.javasoft.syntheticaaddons.ui.StatusBarUI");
        uiDefaults.put("LoginPanelUI", "de.javasoft.syntheticaaddons.ui.LoginPanelUI");
        uiDefaults.put("LoginPaneUI", "de.javasoft.syntheticaaddons.ui.LoginPanelUI");
        uiDefaults.put("MonthViewUI", "de.javasoft.syntheticaaddons.ui.MonthViewUI");
        uiDefaults.put("TitledPanelUI", "de.javasoft.syntheticaaddons.ui.TitledPanelUI");
        uiDefaults.put("HeaderUI", "de.javasoft.syntheticaaddons.ui.HeaderUI");
        uiDefaults.put("swingx/GroupableTableHeaderUI", "de.javasoft.syntheticaaddons.ui.GroupableTableHeaderUI");
        uiDefaults.put("swingx/TaskPaneUI", "de.javasoft.syntheticaaddons.ui.TaskPaneUI");
        uiDefaults.put("swingx/TaskPaneContainerUI", "de.javasoft.syntheticaaddons.ui.TaskPaneContainerUI");
        uiDefaults.put("swingx/TipOfTheDayUI", "de.javasoft.syntheticaaddons.ui.TipOfTheDayUI");
        this.addResourceBundleToDefaults("synthetica", uiDefaults);
        if (UIManager.getBoolean("Synthetica.window.decoration")) {
            uiDefaults.put("RootPaneUI", "de.javasoft.plaf.synthetica.SyntheticaRootPaneUI");
        } else {
            decorated = false;
        }
        JFrame.setDefaultLookAndFeelDecorated(decorated);
        JDialog.setDefaultLookAndFeelDecorated(decorated);
        if (!UIManager.getBoolean("Synthetica.menuItem.useSynthUIDelegates")) {
            uiDefaults.put("MenuUI", "de.javasoft.plaf.synthetica.SyntheticaMenuUI");
            uiDefaults.put("MenuItemUI", "de.javasoft.plaf.synthetica.SyntheticaMenuItemUI");
            uiDefaults.put("CheckBoxMenuItemUI", "de.javasoft.plaf.synthetica.SyntheticaCheckBoxMenuItemUI");
            uiDefaults.put("RadioButtonMenuItemUI", "de.javasoft.plaf.synthetica.SyntheticaRadioButtonMenuItemUI");
        }
        if (!UIManager.getBoolean("Synthetica.slider.useSynthUIDelegate")) {
            uiDefaults.put("SliderUI", "de.javasoft.plaf.synthetica.SyntheticaSliderUI");
        }
        extendedFileChooserEnabled = UIManager.getBoolean("Synthetica.extendedFileChooser.enabled");
        SyntheticaLookAndFeel.setExtendedFileChooserEnabled(extendedFileChooserEnabled);
        useSystemFileIcons = UIManager.getBoolean("Synthetica.extendedFileChooser.useSystemFileIcons");
        UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
        HashMap map = new HashMap();
        for (Map.Entry entry : lafDefaults.entrySet()) {
            if (uiDefaults.containsKey(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        uiDefaults.putAll(map);
        this.extKeyEventProcessor = new ExtKeyEventProcessor();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.extKeyEventProcessor);
        if (ExtKeyEventProcessor.showMnemonicsOnAltKeyOnly()) {
            MenuSelectionManager.defaultManager().addChangeListener(new ChangeListener(){
                boolean repaint = true;

                @Override
                public void stateChanged(ChangeEvent evt) {
                    boolean inactive;
                    Window w = FocusManager.getCurrentManager().getFocusedWindow();
                    JMenuBar mBar = null;
                    if (w instanceof JFrame) {
                        mBar = ((JFrame)w).getJMenuBar();
                    } else if (w instanceof JDialog) {
                        mBar = ((JDialog)w).getJMenuBar();
                    }
                    boolean bl = inactive = MenuSelectionManager.defaultManager().getSelectedPath().length == 0;
                    if (inactive) {
                        ExtKeyEventProcessor.setMenuActive(false);
                    }
                    if (mBar != null && (this.repaint || inactive)) {
                        mBar.repaint();
                        this.repaint = inactive;
                    }
                }
            });
        }
    }

    protected void installCompatibilityDefaults() {
        this.installCompatibilityDefaults(UIManager.getDefaults());
        if (SyntheticaLookAndFeel.isSystemPropertySet("synthetica.defaults.initLAFDefaults") || System.getProperty("synthetica.defaults.initLAFDefaults") == null && SyntheticaLookAndFeel.isSystemPropertySet("nb.forceui", "de.javasoft.synthetica.netbeans.SyntheticaLFCustoms")) {
            this.installCompatibilityDefaults(UIManager.getLookAndFeelDefaults());
        }
    }

    private void installCompatibilityDefaults(UIDefaults defaults) {
        Integer rowHeight;
        this.initSystemColorDefaults(defaults);
        Object[] allAuditoryCues = new Object[]{"OptionPane.errorSound", "OptionPane.informationSound", "OptionPane.questionSound", "OptionPane.warningSound", "InternalFrame.closeSound", "InternalFrame.maximizeSound", "InternalFrame.minimizeSound", "InternalFrame.restoreDownSound", "InternalFrame.restoreUpSound", "PopupMenu.popupSound", "MenuItem.commandSound", "CheckBoxMenuItem.commandSound", "RadioButtonMenuItem.commandSound"};
        Object[] uiDefaults = new Object[]{"Caret.width", this.scaleInteger(1), "FileChooser.usesSingleFilePane", true, "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "F2", "editFileName", "F5", "refresh", "ENTER", "approveSelection", "BACK_SPACE", "Go Up"}), "List.selectionForeground", new ColorUIResource(Color.white), "SplitPane.dividerSize", this.scaleInteger(8), "List.focusCellHighlightBorder", this.createLineBorder(defaults.getColor("Synthetica.list.focusCellHighlightBorder.color"), 1, true, true), "Table.focusCellHighlightBorder", this.createLineBorder(defaults.getColor("Synthetica.table.focusCellHighlightBorder.color"), 1, true, true), "TitledBorder.border", new BorderUIResource(new SyntheticaTitledBorder()), "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}, "controlLtHighlight", new ColorUIResource(Color.WHITE), "controlHighlight", new ColorUIResource(Color.LIGHT_GRAY), "controlShadow", new ColorUIResource(Color.DARK_GRAY), "controlDkShadow", new ColorUIResource(Color.BLACK), "ScrollBar.minimumThumbSize", new DimensionUIResource(8, 8), "ScrollBar.maximumThumbSize", new DimensionUIResource(4096, 4096), "AuditoryCues.cueList", allAuditoryCues, "AuditoryCues.defaultCueList", new Object[]{"OptionPane.informationSound", "OptionPane.warningSound", "OptionPane.questionSound", "OptionPane.errorSound"}, "AuditoryCues.allAuditoryCues", allAuditoryCues, "AuditoryCues.noAuditoryCues", new Object[]{"mute"}, "OptionPane.informationSound", "/javax/swing/plaf/metal/sounds/OptionPaneInformation.wav", "OptionPane.warningSound", "/javax/swing/plaf/metal/sounds/OptionPaneWarning.wav", "OptionPane.errorSound", "/javax/swing/plaf/metal/sounds/OptionPaneError.wav", "OptionPane.questionSound", "/javax/swing/plaf/metal/sounds/OptionPaneQuestion.wav", "InternalFrame.closeSound", "/javax/swing/plaf/metal/sounds/FrameClose.wav", "InternalFrame.maximizeSound", "/javax/swing/plaf/metal/sounds/FrameMaximize.wav", "InternalFrame.minimizeSound", "/javax/swing/plaf/metal/sounds/FrameMinimize.wav", "InternalFrame.restoreDownSound", "/javax/swing/plaf/metal/sounds/FrameRestoreDown.wav", "InternalFrame.restoreUpSound", "/javax/swing/plaf/metal/sounds/FrameRestoreUp.wav", "MenuItem.commandSound", "/javax/swing/plaf/metal/sounds/MenuItemCommand.wav", "PopupMenu.popupSound", "/javax/swing/plaf/metal/sounds/PopupMenuPopup.wav", "CheckBoxMenuItem.commandSound", "/javax/swing/plaf/metal/sounds/MenuItemCommand.wav", "RadioButtonMenuItem.commandSound", "/javax/swing/plaf/metal/sounds/MenuItemCommand.wav"};
        defaults.putDefaults(uiDefaults);
        defaults.putDefaults(SyntheticaInputDefaults.getInputMapDefaults());
        SynthStyle ss = null;
        SynthContext sc = null;
        SynthStyleFactory ssf = SyntheticaLookAndFeel.getStyleFactory();
        String[] inKeys = null;
        String[] keys = null;
        Font font = null;
        JButton button = new JButton();
        ss = ssf.getStyle(button, Region.BUTTON);
        sc = new SynthContext(button, Region.BUTTON, ss, 1);
        defaults.put("Button.focusInputMap", ss.get(sc, "Button.focusInputMap"));
        font = ss.getFont(sc);
        defaults.put("Button.font", font);
        defaults.put("ToggleButton.font", font);
        defaults.put("Button.textShiftOffset", (Object)ss.getInt(sc, "Button.textShiftOffset", 0));
        defaults.put("Button.foreground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        sc = new SynthContext(button, Region.BUTTON, ss, 8);
        defaults.put("Button.disabledForeground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        JComboBox cb = new JComboBox();
        ss = ssf.getStyle(cb, Region.COMBO_BOX);
        sc = new SynthContext(cb, Region.COMBO_BOX, ss, 0);
        defaults.put("ComboBox.focusInputMap", ss.get(sc, "ComboBox.focusInputMap"));
        Color cbBackground = ss.getColor(sc, ColorType.BACKGROUND);
        defaults.put("ComboBox.background", cbBackground);
        Color cbForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("ComboBox.foreground", cbForeground);
        defaults.put("ComboBox.font", ss.getFont(sc));
        ss = ssf.getStyle(cb, Region.LIST);
        sc = new SynthContext(cb, Region.LIST, ss, 512);
        defaults.put("ComboBox.selectionForeground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        defaults.put("ComboBox.selectionBackground", ss.getColor(sc, ColorType.TEXT_BACKGROUND));
        JLabel label = new JLabel();
        ss = ssf.getStyle(label, Region.LABEL);
        sc = new SynthContext(label, Region.LABEL, ss, 0);
        font = ss.getFont(sc);
        defaults.put("Label.font", font);
        if (defaults.get("JXMonthView.font") == null) {
            defaults.put("JXMonthView.font", font);
        }
        if (defaults.get("JXTitledPanel.titleFont") == null) {
            defaults.put("JXTitledPanel.titleFont", font.deriveFont(1));
        }
        Color labelForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("Label.foreground", labelForeground);
        sc = new SynthContext(label, Region.LABEL, ss, 8);
        labelForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("Label.disabledForeground", labelForeground);
        Insets labelInsets = label.getInsets();
        label.setName("Table.cellRenderer");
        if (!labelInsets.equals(label.getInsets())) {
            Border noFocusBorder = label.getBorder();
            Insets nfInsets = noFocusBorder.getBorderInsets(label);
            defaults.put("Table.cellNoFocusBorder", noFocusBorder);
            Border focusBorder = defaults.getBorder("Table.focusCellHighlightBorder");
            Insets fInsets = focusBorder.getBorderInsets(label);
            Insets insets = new Insets(nfInsets.top - fInsets.top, nfInsets.left - fInsets.left, nfInsets.bottom - fInsets.bottom, nfInsets.right - fInsets.right);
            focusBorder = new BorderUIResource(new CompoundBorder(focusBorder, new EmptyBorder(insets)));
            defaults.put("Table.focusCellHighlightBorder", focusBorder);
        }
        JPanel panel = new JPanel();
        ss = ssf.getStyle(panel, Region.PANEL);
        sc = new SynthContext(panel, Region.PANEL, ss, 0);
        Color panelBackground = ss.getColor(sc, ColorType.BACKGROUND);
        defaults.put("Panel.background", panelBackground);
        defaults.put("SplitPane.background", panelBackground);
        defaults.put("Label.background", panelBackground);
        defaults.put("ColorChooser.swatchesDefaultRecentColor", panelBackground);
        defaults.put("control", panelBackground);
        Color panelForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("Panel.foreground", panelForeground);
        font = ss.getFont(sc);
        defaults.put("Panel.font", font);
        defaults.put("TitledBorder.font", this.getTitledBorderFont(font));
        JList list = new JList();
        ss = ssf.getStyle(list, Region.LIST);
        sc = new SynthContext(list, Region.LIST, ss, 0);
        defaults.put("List.focusInputMap", ss.get(sc, "List.focusInputMap"));
        Color listBackground = ss.getColor(sc, ColorType.TEXT_BACKGROUND);
        defaults.put("List.background", listBackground);
        Color listForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("List.foreground", listForeground);
        sc = new SynthContext(list, Region.LIST, ss, 512);
        listBackground = ss.getColor(sc, ColorType.TEXT_BACKGROUND);
        defaults.put("List.selectionBackground", listBackground);
        listForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("List.selectionForeground", listForeground);
        if (defaults.get("List.dropLineColor") == null) {
            defaults.put("List.dropLineColor", new ColorUIResource(Color.RED));
        }
        JTable table = new JTable();
        ss = ssf.getStyle(table, Region.TABLE_HEADER);
        sc = new SynthContext(table, Region.TABLE_HEADER, ss, 0);
        Color tableHeaderBackground = ss.getColor(sc, ColorType.BACKGROUND);
        defaults.put("TableHeader.background", tableHeaderBackground);
        Color tableHeaderForeground = ss.getColor(sc, ColorType.FOREGROUND);
        defaults.put("TableHeader.foreground", tableHeaderForeground);
        defaults.put("TableHeader.font", ss.getFont(sc));
        ss = ssf.getStyle(table, Region.TABLE);
        sc = new SynthContext(table, Region.TABLE, ss, 0);
        defaults.put("Table.gridColor", ss.get(sc, "Table.gridColor"));
        Color tableBackground = ss.getColor(sc, ColorType.BACKGROUND);
        defaults.put("Table.background", tableBackground);
        Color tableForeground = ss.getColor(sc, ColorType.FOREGROUND);
        defaults.put("Table.foreground", tableForeground);
        defaults.put("Table.font", ss.getFont(sc));
        sc = new SynthContext(table, Region.TABLE, ss, 512);
        tableBackground = ss.getColor(sc, ColorType.TEXT_BACKGROUND);
        defaults.put("Table.selectionBackground", tableBackground);
        tableForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("Table.selectionForeground", tableForeground);
        Border tableScrollPaneBorder = null;
        if (defaults.get("Synthetica.table.scrollPaneBorder.className") != null) {
            try {
                tableScrollPaneBorder = (Border)Class.forName(defaults.getString("Synthetica.table.scrollPaneBorder.className")).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (defaults.getBoolean("Synthetica.table.useScrollPaneBorder")) {
            tableScrollPaneBorder = new JScrollPane().getBorder();
        } else {
            int size = defaults.containsKey("Synthetica.table.scrollPane.border.size") ? defaults.getInt("Synthetica.table.scrollPane.border.size") : 1;
            tableScrollPaneBorder = new BorderUIResource.LineBorderUIResource(defaults.getColor("Synthetica.table.scrollPane.border.color"), size);
        }
        defaults.put("Table.scrollPaneBorder", tableScrollPaneBorder);
        if (defaults.getBoolean("Synthetica.scrollPane.cornerPainter.enabled")) {
            defaults.put("Table.scrollPaneCornerComponent", SyntheticaScrollPaneCorner.TableUpperTrailingCorner.class);
        }
        if (defaults.get("JXTable.rowHeight") == null && (rowHeight = (Integer)ss.get(sc, "Table.rowHeight")) != null) {
            defaults.put("JXTable.rowHeight", rowHeight);
        }
        defaults.put("ColumnHeaderRenderer.upIcon", SyntheticaLookAndFeel.loadIcon("Synthetica.arrow.up", null, true));
        defaults.put("ColumnHeaderRenderer.downIcon", SyntheticaLookAndFeel.loadIcon("Synthetica.arrow.down", null, true));
        Icon sortIcon = SyntheticaLookAndFeel.loadIcon("Synthetica.tableHeader.ascendingSort.icon", null, true);
        defaults.put("Table.ascendingSortIcon", sortIcon == null ? SyntheticaLookAndFeel.loadIcon("Synthetica.arrow.up", null, true) : sortIcon);
        sortIcon = SyntheticaLookAndFeel.loadIcon("Synthetica.tableHeader.descendingSort.icon", null, true);
        defaults.put("Table.descendingSortIcon", sortIcon == null ? SyntheticaLookAndFeel.loadIcon("Synthetica.arrow.down", null, true) : sortIcon);
        String cellBorderClassName = defaults.getString("Synthetica.tableHeader.cellBorder.className");
        if (defaults.get("TableHeader.cellBorder") == null && cellBorderClassName != null) {
            try {
                defaults.put("TableHeader.cellBorder", Class.forName(cellBorderClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (defaults.get("Table.dropLineColor") == null) {
            defaults.put("Table.dropLineColor", defaults.get("Table.foreground"));
        }
        if (defaults.get("Table.dropLineShortColor") == null) {
            defaults.put("Table.dropLineShortColor", new ColorUIResource(Color.RED));
        }
        JTree tree = new JTree();
        ss = ssf.getStyle(tree, Region.TREE);
        sc = new SynthContext(tree, Region.TREE, ss, 0);
        if (SyntheticaLookAndFeel.getJVMCompatibilityMode() == JVMCompatibilityMode.SUN) {
            font = ss.getFont(sc);
            defaults.put("Tree.font", font);
        }
        defaults.put("Tree.focusInputMap", ss.get(sc, "Tree.focusInputMap"));
        defaults.put("Tree.foreground", ss.getColor(sc, ColorType.FOREGROUND));
        defaults.put("Tree.background", ss.getColor(sc, ColorType.BACKGROUND));
        keys = new String[]{"Tree.expandedIcon", "Tree.collapsedIcon"};
        this.putIcons2Defaults(defaults, keys, keys, ss, sc);
        defaults.put("Tree.rowHeight", ss.get(sc, "Tree.rowHeight"));
        defaults.put("Tree.leftChildIndent", ss.get(sc, "Tree.leftChildIndent"));
        defaults.put("Tree.rightChildIndent", ss.get(sc, "Tree.rightChildIndent"));
        ss = ssf.getStyle(tree, Region.TREE_CELL);
        sc = new SynthContext(tree, Region.TREE_CELL, ss, 0);
        defaults.put("Tree.textForeground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        defaults.put("Tree.textBackground", ss.getColor(sc, ColorType.TEXT_BACKGROUND));
        sc = new SynthContext(tree, Region.TREE_CELL, ss, 512);
        defaults.put("Tree.selectionForeground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        defaults.put("Tree.selectionBackground", ss.getColor(sc, ColorType.TEXT_BACKGROUND));
        defaults.put("Tree.hash", defaults.get("Synthetica.tree.line.color.vertical"));
        if (defaults.get("Tree.dropLineColor") == null) {
            defaults.put("Tree.dropLineColor", new ColorUIResource(Color.RED));
        }
        JInternalFrame iFrame = new JInternalFrame();
        ss = ssf.getStyle(iFrame, Region.INTERNAL_FRAME_TITLE_PANE);
        if (SyntheticaLookAndFeel.getJVMCompatibilityMode() == JVMCompatibilityMode.SUN) {
            DefaultSynthStyle ss_ = (DefaultSynthStyle)((InternalFrameTitlePaneStyle)ss).getStyle();
            Color iFrameForeground = ss_.getColor(iFrame, Region.INTERNAL_FRAME_TITLE_PANE, 512, ColorType.FOREGROUND);
            defaults.put("InternalFrame.activeTitleForeground", iFrameForeground);
            iFrameForeground = ss_.getColor(iFrame, Region.INTERNAL_FRAME_TITLE_PANE, 0, ColorType.FOREGROUND);
            defaults.put("InternalFrame.inactiveTitleForeground", iFrameForeground);
            Color iFrameBackground = ss_.getColor(iFrame, Region.INTERNAL_FRAME_TITLE_PANE, 512, ColorType.BACKGROUND);
            defaults.put("InternalFrame.activeTitleBackground", iFrameBackground);
            defaults.put("activeCaption", iFrameBackground);
            iFrameBackground = ss_.getColor(iFrame, Region.INTERNAL_FRAME_TITLE_PANE, 0, ColorType.BACKGROUND);
            defaults.put("InternalFrame.inactiveTitleBackground", iFrameBackground);
            defaults.put("inactiveCaption", iFrameBackground);
        }
        sc = new SynthContext(iFrame, Region.INTERNAL_FRAME_TITLE_PANE, ss, 0);
        inKeys = new String[]{"InternalFrameTitlePane.closeIcon", "InternalFrameTitlePane.maximizeIcon", "InternalFrameTitlePane.minimizeIcon", "InternalFrameTitlePane.iconifyIcon"};
        keys = new String[]{"InternalFrame.closeIcon", "InternalFrame.maximizeIcon", "InternalFrame.minimizeIcon", "InternalFrame.iconifyIcon"};
        this.putIcons2Defaults(defaults, inKeys, keys, ss, sc);
        ss = ssf.getStyle(iFrame, Region.INTERNAL_FRAME);
        sc = new SynthContext(iFrame, Region.INTERNAL_FRAME, ss, 0);
        keys = new String[]{"InternalFrame.icon"};
        this.putIcons2Defaults(defaults, keys, keys, ss, sc);
        JMenu menu = new JMenu();
        ss = ssf.getStyle(menu, Region.MENU);
        sc = new SynthContext(menu, Region.MENU, ss, 0);
        defaults.put("MenuItem.background", ss.getColor(sc, ColorType.BACKGROUND));
        Color menuForeground = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("Menu.foreground", menuForeground);
        defaults.put("MenuItem.foreground", menuForeground);
        if (!this.menuOffsetsScaled) {
            defaults.put("Menu.menuPopupOffsetX", (Object)SyntheticaLookAndFeel.getInt("Menu.menuPopupOffsetX", null, 0, true));
            defaults.put("Menu.menuPopupOffsetY", (Object)SyntheticaLookAndFeel.getInt("Menu.menuPopupOffsetY", null, 0, true));
            defaults.put("Menu.submenuPopupOffsetX", (Object)SyntheticaLookAndFeel.getInt("Menu.submenuPopupOffsetX", null, 0, true));
            defaults.put("Menu.submenuPopupOffsetY", (Object)SyntheticaLookAndFeel.getInt("Menu.submenuPopupOffsetY", null, 0, true));
            this.menuOffsetsScaled = true;
        }
        JOptionPane oPane = new JOptionPane();
        ss = ssf.getStyle(oPane, Region.OPTION_PANE);
        sc = new SynthContext(oPane, Region.OPTION_PANE, ss, 0);
        keys = new String[]{"OptionPane.informationIcon", "OptionPane.questionIcon", "OptionPane.warningIcon", "OptionPane.errorIcon"};
        this.putIcons2Defaults(defaults, keys, keys, ss, sc);
        JCheckBox checkBox = new JCheckBox();
        ss = ssf.getStyle(checkBox, Region.CHECK_BOX);
        sc = new SynthContext(checkBox, Region.CHECK_BOX, ss, 0);
        defaults.put("CheckBox.focusInputMap", ss.get(sc, "CheckBox.focusInputMap"));
        keys = new String[]{"CheckBox.icon"};
        this.putIcons2Defaults(defaults, keys, keys, ss, sc);
        JRadioButton radioButton = new JRadioButton();
        ss = ssf.getStyle(radioButton, Region.RADIO_BUTTON);
        sc = new SynthContext(radioButton, Region.RADIO_BUTTON, ss, 0);
        defaults.put("RadioButton.focusInputMap", ss.get(sc, "RadioButton.focusInputMap"));
        keys = new String[]{"RadioButton.icon"};
        this.putIcons2Defaults(defaults, keys, keys, ss, sc);
        JScrollBar scrollBar = new JScrollBar();
        ss = ssf.getStyle(scrollBar, Region.SCROLL_BAR);
        sc = new SynthContext(scrollBar, Region.SCROLL_BAR, ss, 0);
        defaults.put("ScrollBar.width", ss.get(sc, "ScrollBar.thumbHeight"));
        JTabbedPane tPane = new JTabbedPane();
        ss = ssf.getStyle(tPane, Region.TABBED_PANE);
        sc = new SynthContext(tPane, Region.TABBED_PANE, ss, 0);
        defaults.put("TabbedPane.focusInputMap", ss.get(sc, "TabbedPane.focusInputMap"));
        ss = ssf.getStyle(tPane, Region.TABBED_PANE_TAB_AREA);
        sc = new SynthContext(tPane, Region.TABBED_PANE_TAB_AREA, ss, 0);
        defaults.put("TabbedPane.tabAreaInsets", ss.getInsets(sc, null));
        ss = ssf.getStyle(tPane, Region.TABBED_PANE_TAB);
        sc = new SynthContext(tPane, Region.TABBED_PANE_TAB, ss, 0);
        defaults.put("TabbedPane.tabInsets", ss.getInsets(sc, null));
        defaults.put("TabbedPane.tabForeground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        ss = ssf.getStyle(tPane, Region.TABBED_PANE_TAB);
        sc = new SynthContext(tPane, Region.TABBED_PANE_TAB, ss, 512);
        defaults.put("TabbedPane.selectedTabPadInsets", ss.getInsets(sc, null));
        defaults.put("TabbedPane.selectedTabForeground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        ss = ssf.getStyle(tPane, Region.TABBED_PANE_CONTENT);
        sc = new SynthContext(tPane, Region.TABBED_PANE_CONTENT, ss, 0);
        defaults.put("TabbedPane.contentBorderInsets", ss.getInsets(sc, null));
        defaults.put("TabbedPane.foreground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        defaults.put("TabbedPane.shadow", Color.GRAY);
        JTextField tf = new JTextField();
        defaults.put("TextField.border", tf.getBorder());
        defaults.put("FormattedTextField.border", tf.getBorder());
        ss = ssf.getStyle(tf, Region.TEXT_FIELD);
        sc = new SynthContext(tf, Region.TEXT_FIELD, ss, 0);
        Object inputMap = ss.get(sc, "TextField.focusInputMap");
        defaults.put("TextField.focusInputMap", inputMap);
        defaults.put("PasswordField.focusInputMap", inputMap);
        font = ss.getFont(sc);
        defaults.put("TextField.font", font);
        defaults.put("FormattedTextField.font", font);
        defaults.put("PasswordField.font", font);
        defaults.put("TextArea.font", font);
        Color color = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("TextField.foreground", color);
        defaults.put("FormattedTextField.foreground", color);
        defaults.put("PasswordField.foreground", color);
        defaults.put("TextArea.foreground", color);
        color = ss.getColor(sc, ColorType.TEXT_BACKGROUND);
        defaults.put("TextField.background", color);
        defaults.put("FormattedTextField.background", color);
        defaults.put("PasswordField.background", color);
        defaults.put("TextArea.background", color);
        sc = new SynthContext(tf, Region.TEXT_FIELD, ss, 8);
        color = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("TextField.inactiveForeground", color);
        defaults.put("FormattedTextField.inactiveForeground", color);
        defaults.put("PasswordField.inactiveForeground", color);
        defaults.put("TextArea.inactiveForeground", color);
        color = ss.getColor(sc, ColorType.TEXT_BACKGROUND);
        defaults.put("TextField.inactiveBackground", color);
        defaults.put("FormattedTextField.inactiveBackground", color);
        defaults.put("PasswordField.inactiveBackground", color);
        defaults.put("TextArea.inactiveBackground", color);
        sc = new SynthContext(tf, Region.TEXT_FIELD, ss, 512);
        color = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("TextField.selectionForeground", color);
        defaults.put("FormattedTextField.selectionForeground", color);
        defaults.put("PasswordField.selectionForeground", color);
        defaults.put("TextArea.selectionForeground", color);
        color = ss.getColor(sc, ColorType.TEXT_BACKGROUND);
        defaults.put("TextField.selectionBackground", color);
        defaults.put("FormattedTextField.selectionBackground", color);
        defaults.put("PasswordField.selectionBackground", color);
        defaults.put("TextArea.selectionBackground", color);
        defaults.put("textHighlight", color);
        JTextPane tp = new JTextPane();
        ss = ssf.getStyle(tf, Region.TEXT_PANE);
        inputMap = ss.get(sc, "TextPane.focusInputMap");
        defaults.put("TextPane.focusInputMap", inputMap);
        defaults.put("EditorPane.focusInputMap", inputMap);
        defaults.put("TextArea.focusInputMap", inputMap);
        sc = new SynthContext(tp, Region.TEXT_PANE, ss, 0);
        font = ss.getFont(sc);
        defaults.put("TextPane.font", font);
        defaults.put("EditorPane.font", font);
        color = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("TextPane.foreground", color);
        defaults.put("EditorPane.foreground", color);
        color = ss.getColor(sc, ColorType.TEXT_BACKGROUND);
        defaults.put("TextPane.background", color);
        defaults.put("EditorPane.background", color);
        sc = new SynthContext(tp, Region.TEXT_PANE, ss, 8);
        color = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("TextPane.inactiveForeground", color);
        defaults.put("EditorPane.inactiveForeground", color);
        color = ss.getColor(sc, ColorType.TEXT_BACKGROUND);
        defaults.put("TextPane.inactiveBackground", color);
        defaults.put("EditorPane.inactiveBackground", color);
        sc = new SynthContext(tp, Region.TEXT_PANE, ss, 512);
        color = ss.getColor(sc, ColorType.TEXT_FOREGROUND);
        defaults.put("TextPane.selectionForeground", color);
        defaults.put("EditorPane.selectionForeground", color);
        color = ss.getColor(sc, ColorType.TEXT_BACKGROUND);
        defaults.put("TextPane.selectionBackground", color);
        defaults.put("EditorPane.selectionBackground", color);
        JToolTip tt = new JToolTip();
        sc = new SynthContext(tt, Region.TOOL_TIP, ss, 0);
        ss = ssf.getStyle(tt, Region.TOOL_TIP);
        defaults.put("ToolTip.font", ss.getFont(sc));
        defaults.put("ToolTip.foreground", ss.getColor(sc, ColorType.TEXT_FOREGROUND));
        Color ttBackground = ss.getColor(sc, ColorType.BACKGROUND);
        defaults.put("ToolTip.background", ttBackground == null ? null : new Color(ttBackground.getRGB()));
    }

    private void putIcons2Defaults(UIDefaults defaults, String[] inKeys, String[] keys, SynthStyle ss, SynthContext sc) {
        int i = 0;
        while (i < inKeys.length) {
            Icon icon = ss.getIcon(sc, inKeys[i]);
            defaults.put(keys[i], icon);
            ++i;
        }
    }

    private Font getTitledBorderFont(Font font) {
        if (UIManager.get("Synthetica.titledBorder.title.fontName") != null) {
            font = new FontUIResource(new Font(UIManager.getString("Synthetica.titledBorder.title.fontName"), font.getStyle(), font.getSize()));
        }
        if (UIManager.get("Synthetica.titledBorder.title.fontSize") != null) {
            float size = this.scaleFontSize(UIManager.getInt("Synthetica.titledBorder.title.fontSize"));
            font = new FontUIResource(font.deriveFont(size));
        }
        if (UIManager.get("Synthetica.titledBorder.title.fontStyle") != null) {
            font = new FontUIResource(font.deriveFont(UIManager.getInt("Synthetica.titledBorder.title.fontStyle")));
        }
        return font;
    }

    @Override
    public void uninitialize() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.extKeyEventProcessor);
        ((StyleFactory)SynthLookAndFeel.getStyleFactory()).uninitialize();
        UIDefaults defaults = UIManager.getDefaults();
        Object sLic = UIManager.get("Synthetica.license.info");
        Object sKey = UIManager.get("Synthetica.license.key");
        Object saLic = UIManager.get("SyntheticaAddons.license.info");
        Object saKey = UIManager.get("SyntheticaAddons.license.key");
        if (SyntheticaLookAndFeel.isSystemPropertySet("synthetica.clearPreDefinedDefaults")) {
            defaults.clear();
        } else {
            UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
            UIDefaults d = new UIDefaults();
            Enumeration enumeration = this.orgDefaults.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                if (lafDefaults.containsKey(key)) continue;
                d.put(key, this.orgDefaults.get(key));
            }
            defaults.clear();
            defaults.putAll(d);
        }
        if (sLic != null) {
            UIManager.put("Synthetica.license.info", sLic);
            UIManager.put("Synthetica.license.key", sKey);
        }
        if (saLic != null) {
            defaults.put("SyntheticaAddons.license.info", saLic);
            defaults.put("SyntheticaAddons.license.key", saKey);
        }
        UIManager.removePropertyChangeListener(this.lafChangeListener);
        this.imageResourceBaseMap.clear();
        activeInstance = null;
        super.uninitialize();
    }

    @Override
    protected boolean shouldUpdateStyleOnEvent(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("name".equals(name) || "componentOrientation".equals(name) || "Synthetica.style".equals(name) || "editable".equals(name)) {
            return true;
        }
        if ("ancestor".equals(name) && evt.getNewValue() != null) {
            return this.shouldUpdateStyleOnAncestorChanged();
        }
        return false;
    }

    private void blockLAFChange() {
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Object newLAF = event.getNewValue();
                if (!(newLAF instanceof SyntheticaLookAndFeel)) {
                    try {
                        UIManager.setLookAndFeel(SyntheticaLookAndFeel.this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static SynthContext createContext(JComponent c, Region region, int state) {
        SynthStyle ss = SyntheticaLookAndFeel.getStyle(c, region);
        return new SynthContext(c, region, ss, state);
    }

    public static void setFont(String name, int size) {
        SyntheticaLookAndFeel.setFont(new FontUIResource(name, 0, size));
    }

    public static void setFont(Font font) {
        SyntheticaLookAndFeel.setFont(font, true);
    }

    public static void setFont(Font font, boolean respectScaleFactor) {
        if (font == null) {
            defaultFont = null;
            return;
        }
        if (respectScaleFactor) {
            float size = SyntheticaLookAndFeel.getInstance().scaleFontSize(font.getSize2D());
            defaultFont = font.deriveFont(size);
        } else {
            defaultFont = font;
        }
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (defaultsCompatibilityMode && laf instanceof SyntheticaLookAndFeel) {
            ((SyntheticaLookAndFeel)laf).installCompatibilityDefaults();
        }
    }

    public static Font getFont() {
        return defaultFont;
    }

    public static String getFontName() {
        return defaultFont == null ? null : defaultFont.getFontName();
    }

    public static int getFontSize() {
        return defaultFont == null ? 0 : defaultFont.getSize();
    }

    public static boolean getAntiAliasEnabled() {
        return antiAliasEnabled;
    }

    public static void setAntiAliasEnabled(boolean value) {
        antiAliasEnabled = value;
        System.setProperty("awt.useSystemAAFontSettings", "false");
    }

    public static void setWindowsDecorated(boolean decorated) {
        SyntheticaLookAndFeel.decorated = decorated;
    }

    public static boolean getExtendedFileChooserEnabled() {
        return extendedFileChooserEnabled;
    }

    public static void setExtendedFileChooserEnabled(boolean value) {
        extendedFileChooserEnabled = value;
        if (extendedFileChooserEnabled) {
            UIDefaults defaults = UIManager.getDefaults();
            String ui = null;
            if (OS.getCurrentOS() == OS.Mac) {
                String defaultUI = "ch.randelshofer.quaqua.panther.QuaquaPantherFileChooserUI";
                ui = defaults.get("Synthetica.fileChooserUI") == null ? defaultUI : defaults.getString("Synthetica.fileChooserUI");
                try {
                    Class.forName(ui);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SyntheticaLookAndFeel.initQuaquaFileChooser(uiDefaults);
                        }
                    });
                }
                catch (ClassNotFoundException e) {
                    ui = null;
                }
            }
            ui = ui == null ? "de.javasoft.plaf.synthetica.filechooser.SyntheticaFileChooserUI" : ui;
            defaults.put("FileChooserUI", ui);
        } else {
            UIManager.getDefaults().put("FileChooserUI", "javax.swing.plaf.metal.MetalFileChooserUI");
        }
    }

    private static void initQuaquaFileChooser(UIDefaults defaults) {
        final Color labelForeground = defaults.getColor("Label.foreground");
        defaults.addResourceBundle("ch.randelshofer.quaqua.Labels");
        defaults.put("Browser.expandedIcon", SyntheticaLookAndFeel.loadIcon("Synthetica.arrow.right", null, true));
        defaults.put("Browser.sizeHandleIcon", new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(labelForeground);
                g.drawLine(5, 4, 5, 10);
                g.drawLine(8, 4, 8, 10);
            }

            @Override
            public int getIconWidth() {
                return 15;
            }

            @Override
            public int getIconHeight() {
                return 15;
            }
        });
        defaults.put("Browser.selectionBackground", new ColorUIResource(56, 117, 215));
        defaults.put("Browser.selectionForeground", new ColorUIResource(255, 255, 255));
        defaults.put("Browser.inactiveSelectionBackground", new ColorUIResource(208, 208, 208));
        defaults.put("Browser.inactiveSelectionForeground", new ColorUIResource(0, 0, 0));
        defaults.put("FileChooser.previewLabelForeground", labelForeground);
        defaults.put("FileChooser.previewValueForeground", labelForeground);
        FontUIResource smallSystemFont = new FontUIResource("Lucida Grande", 0, 11);
        defaults.put("FileChooser.previewLabelFont", smallSystemFont);
        defaults.put("FileChooser.previewValueFont", smallSystemFont);
        defaults.put("FileChooser.previewLabelInsets", new InsetsUIResource(0, 0, 0, 4));
        defaults.put("FileChooser.cellTipOrigin", new Point(18, 1));
        defaults.put("FileChooser.autovalidate", Boolean.TRUE);
        defaults.put("Sheet.showAsSheet", Boolean.TRUE);
    }

    @Override
    public Icon getDisabledIcon(JComponent c, Icon icon) {
        if (icon == null || !SyntheticaLookAndFeel.getBoolean("Synthetica.translucency4DisabledIcons.enabled", c)) {
            return super.getDisabledIcon(c, icon);
        }
        int disabledAlpha = SyntheticaLookAndFeel.getInt("Synthetica.translucency4DisabledIcons.alpha", (Component)c, 50);
        BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        AlphaComposite alphaComp = AlphaComposite.getInstance(3, (float)disabledAlpha / 100.0f);
        g2d.setComposite(alphaComp);
        icon.paintIcon(c, g2d, 0, 0);
        g2d.dispose();
        Object description = bi.getProperty("comment", null);
        return new ImageIcon(bi, description instanceof String ? (String)description : "");
    }

    public static boolean getRememberFileChooserPreferences() {
        if (rememberFileChooserPreferences != null) {
            return rememberFileChooserPreferences;
        }
        return SyntheticaLookAndFeel.getBoolean("Synthetica.extendedFileChooser.rememberPreferences", null, false);
    }

    public static void setRememberFileChooserPreferences(boolean value) {
        rememberFileChooserPreferences = value;
    }

    public static boolean getUseSystemFileIcons() {
        return useSystemFileIcons;
    }

    public static void setUseSystemFileIcons(boolean value) {
        useSystemFileIcons = value;
    }

    public static void setDefaultsCompatibilityMode(boolean value) {
        defaultsCompatibilityMode = value;
    }

    public static boolean getDefaultsCompatibilityMode() {
        return defaultsCompatibilityMode;
    }

    public static void setToolbarSeparatorDimension(Dimension dim) {
        toolbarSeparatorDimension = dim;
    }

    public static Dimension getToolbarSeparatorDimension() {
        return toolbarSeparatorDimension;
    }

    private static ResourceBundle getResourceBundle(String name, Locale locale, Module module) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String packageName = String.valueOf(SyntheticaLookAndFeel.class.getPackage().getName().replace('.', '/')) + "/resources";
        String bundleName = String.valueOf(packageName) + "/" + name;
        return ResourceBundle.getBundle(bundleName, locale, module);
    }

    public IVersion getSyntheticaVersion() {
        return new Version();
    }

    public static String getStyleName(Component c) {
        String name = c.getName();
        SynthStyleFactory f = SyntheticaLookAndFeel.getStyleFactory();
        if (!(f instanceof StyleFactory)) {
            return name;
        }
        StyleFactory factory = (StyleFactory)f;
        if (factory != null && factory.isSyntheticaStyleNameSupportEnabled()) {
            Object o;
            if (c instanceof Window) {
                if (c instanceof JFrame) {
                    c = ((JFrame)c).getRootPane();
                } else if (c instanceof JDialog) {
                    c = ((JDialog)c).getRootPane();
                } else if (c instanceof JWindow) {
                    c = ((JWindow)c).getRootPane();
                }
            }
            if (c instanceof JComponent && (o = ((JComponent)c).getClientProperty("Synthetica.style")) != null) {
                name = (String)o;
            }
        }
        return name;
    }

    public static JVMCompatibilityMode getJVMCompatibilityMode() {
        String s = UIManager.getString("Synthetica.JVMCompatibilityMode");
        if (s == null) {
            return JVMCompatibilityMode.SUN;
        }
        return JVMCompatibilityMode.valueOf(s);
    }

    public static <T> T getClientProperty(String key, JComponent c, T defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        Object o = c.getClientProperty(key);
        return (T)(o != null ? o : defaultValue);
    }

    public static Icon loadIcon(String key) {
        return SyntheticaLookAndFeel.loadIcon(key, null);
    }

    public static Icon loadIcon(String key, Component c) {
        return SyntheticaLookAndFeel.loadIcon(key, c, false);
    }

    public static Icon loadIcon(String key, Component c, boolean scaled) {
        Icon icon = null;
        Object iconResource = SyntheticaLookAndFeel.get(key, c);
        if (iconResource instanceof String) {
            String iconRes = (String)iconResource;
            String cacheKey = iconResource + "/" + scaled;
            icon = iconCache.get(cacheKey);
            if (icon != null) {
                return icon;
            }
            String[] resources = iconRes.split(",");
            String name = resources[resources.length - 1];
            URL url = SyntheticaLookAndFeel.getResource(name);
            if (url == null) {
                try {
                    icon = (Icon)Class.forName(iconRes).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (scaled && SyntheticaLookAndFeel.getInstance().getScaleFactor() != 1.0f || SyntheticaLookAndFeel.getInstance().isSwingUIScalingEnabled()) {
                Class<?> resourceBase = SyntheticaLookAndFeel.getImageResourceBase(name);
                String iconResource2x = SyntheticaLookAndFeel.resolveImagePath(key, c);
                String[] resources2x = iconResource2x.split(",");
                String name2x = resources2x[resources2x.length - 1];
                icon = name.equals(name2x) ? new ScalableIcon.ScalableIconUIResource(resourceBase, name) : new ScalableIcon.ScalableIconUIResource(resourceBase, name, name2x);
            } else {
                icon = new IconUIResource(new ImageIcon(url));
            }
            iconCache.put(cacheKey, icon);
        } else if (iconResource instanceof Icon) {
            icon = (Icon)iconResource;
        }
        return icon;
    }

    public static Object get(String propertyKey, String propertyName, String componentName, boolean fallback) {
        return SyntheticaLookAndFeel.get(propertyKey, propertyName, componentName, fallback, false);
    }

    private static Object get(String propertyKey, String propertyName, String componentName, boolean fallback, boolean resolveImagePath) {
        String pKey = propertyKey;
        char delimiter = '.';
        int i = propertyKey.length();
        while (i > -1) {
            StringBuilder key = new StringBuilder("Synthetica.");
            propertyKey = propertyKey.substring(0, i);
            key.append(propertyKey);
            if (propertyName != null) {
                key.append(delimiter);
                key.append(propertyName);
            }
            if (resolveImagePath && SyntheticaLookAndFeel.getInstance().isUIScalingEnabled() && SyntheticaLookAndFeel.getInstance().getPercentageScaleFactor() >= SyntheticaLookAndFeel.getInstance().getHiDpiImageThreshold()) {
                StringBuilder key2x = new StringBuilder(key.toString());
                key2x.append(SyntheticaLookAndFeel.getInstance().getScaleKeyExtension());
                if (componentName != null) {
                    key2x.append(delimiter);
                    key2x.append(componentName);
                }
                if (SyntheticaLookAndFeel.lookup(key2x.toString()) != null || !fallback) {
                    return SyntheticaLookAndFeel.lookup(key2x.toString());
                }
            }
            if (componentName != null) {
                key.append(delimiter);
                key.append(componentName);
            }
            if (SyntheticaLookAndFeel.lookup(key.toString()) != null || !fallback) {
                return SyntheticaLookAndFeel.lookup(key.toString());
            }
            i = propertyKey.lastIndexOf(delimiter);
            if (i != -1 || componentName == null) continue;
            componentName = null;
            propertyKey = pKey;
            i = propertyKey.length();
        }
        return null;
    }

    public static String getString(String propertyKey, String propertyName, String componentName, boolean fallback) {
        return (String)SyntheticaLookAndFeel.get(propertyKey, propertyName, componentName, fallback);
    }

    public static Insets getInsets(String propertyKey, String propertyName, String componentName, boolean fallback) {
        return (Insets)SyntheticaLookAndFeel.get(propertyKey, propertyName, componentName, fallback);
    }

    public static int getInt(String propertyKey, String propertyName, String componentName, boolean fallback, int defaultValue) {
        Object o = SyntheticaLookAndFeel.get(propertyKey, propertyName, componentName, fallback);
        return o != null ? (Integer)o : defaultValue;
    }

    public static Object get(String key, Component c) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "UI-propertyKey: " + key);
        }
        if (c == null || c.getParent() instanceof CellRendererPane) {
            return SyntheticaLookAndFeel.lookup(key);
        }
        return SyntheticaLookAndFeel.get(key, SyntheticaLookAndFeel.getStyleName(c));
    }

    public static Object get(String key, String name) {
        if (name == null) {
            return SyntheticaLookAndFeel.lookup(key);
        }
        Object o = SyntheticaLookAndFeel.lookup(String.valueOf(key) + "." + name);
        if (o != null) {
            return o;
        }
        return SyntheticaLookAndFeel.lookup(key);
    }

    private static Object lookup(String key) {
        if (uiDefaults != null) {
            return uiDefaults.get(key);
        }
        return UIManager.get(key);
    }

    public static boolean getBoolean(String key, Component c) {
        return SyntheticaLookAndFeel.getBoolean(key, c, false);
    }

    public static boolean getBoolean(String key, Component c, boolean defaultValue) {
        Object o = SyntheticaLookAndFeel.get(key, c);
        return o != null ? (Boolean)o : defaultValue;
    }

    public static int getInt(String key, Component c) {
        return SyntheticaLookAndFeel.getInt(key, c, false);
    }

    public static int getInt(String key, Component c, int defaultValue) {
        return SyntheticaLookAndFeel.getInt(key, c, defaultValue, false);
    }

    public static int getInt(String key, Component c, boolean scaled) {
        return SyntheticaLookAndFeel.getInt(key, c, 0, scaled);
    }

    public static int getInt(String key, Component c, int defaultValue, boolean scaled) {
        return SyntheticaLookAndFeel.getInt(key, c, defaultValue, scaled, scaled);
    }

    public static int getInt(String key, Component c, int defaultValue, boolean scaled, boolean scaleDefault) {
        Object value = SyntheticaLookAndFeel.get(key, c);
        if (value instanceof Number) {
            int val = ((Number)value).intValue();
            return scaled ? SyntheticaLookAndFeel.getInstance().scaleInteger(val) : val;
        }
        return scaled && scaleDefault ? SyntheticaLookAndFeel.getInstance().scaleInteger(defaultValue) : defaultValue;
    }

    public static Dimension getDim(String key, Component c) {
        return SyntheticaLookAndFeel.getDim(key, c, null);
    }

    public static Dimension getDim(String key, Component c, Dimension defaultValue) {
        return SyntheticaLookAndFeel.getDim(key, c, defaultValue, false);
    }

    public static Dimension getDim(String key, Component c, Dimension defaultValue, boolean scaled) {
        return SyntheticaLookAndFeel.getDim(key, c, defaultValue, scaled, scaled);
    }

    public static Dimension getDim(String key, Component c, Dimension defaultValue, boolean scaled, boolean scaleDefault) {
        Object o = SyntheticaLookAndFeel.get(key, c);
        Dimension dim = (Dimension)o;
        if (o instanceof Dimension) {
            dim = scaled ? SyntheticaLookAndFeel.getInstance().scaleDimension(dim) : dim;
        } else if (defaultValue != null) {
            dim = scaled && scaleDefault ? SyntheticaLookAndFeel.getInstance().scaleDimension(defaultValue) : defaultValue;
        }
        return dim;
    }

    public static Insets getInsets(String key, Component c) {
        return SyntheticaLookAndFeel.getInsets(key, c, true);
    }

    public static Insets getInsets(String key, Component c, boolean nullAllowed) {
        return SyntheticaLookAndFeel.getInsets(key, c, nullAllowed ? null : new InsetsUIResource(0, 0, 0, 0));
    }

    public static Insets getInsets(String key, Component c, Insets defaultValue) {
        return SyntheticaLookAndFeel.getInsets(key, c, defaultValue, false);
    }

    public static Insets getInsets(String key, Component c, boolean nullAllowed, boolean scaled) {
        return SyntheticaLookAndFeel.getInsets(key, c, nullAllowed ? null : new InsetsUIResource(0, 0, 0, 0), scaled);
    }

    public static Insets getInsets(String key, Component c, Insets defaultValue, boolean scaled) {
        return SyntheticaLookAndFeel.getInsets(key, c, defaultValue, scaled, scaled);
    }

    public static Insets getInsets(String key, Component c, Insets defaultValue, boolean scaled, boolean scaleDefault) {
        Object o = SyntheticaLookAndFeel.get(key, c);
        Insets insets = (Insets)o;
        if (o instanceof Insets) {
            insets = scaled ? SyntheticaLookAndFeel.getInstance().scaleInsets(insets) : insets;
        } else if (defaultValue != null) {
            insets = scaled && scaleDefault ? SyntheticaLookAndFeel.getInstance().scaleInsets(defaultValue) : defaultValue;
        }
        return insets;
    }

    public static String resolveImagePath(String key, Component c) {
        String path;
        if (SyntheticaLookAndFeel.getInstance().isUIScalingEnabled() && SyntheticaLookAndFeel.getInstance().getPercentageScaleFactor() >= SyntheticaLookAndFeel.getInstance().getHiDpiImageThreshold() && (path = SyntheticaLookAndFeel.getString(String.valueOf(key) + SyntheticaLookAndFeel.getInstance().getScaleKeyExtension(), c)) != null) {
            return path;
        }
        return SyntheticaLookAndFeel.getString(key, c);
    }

    public static String resolveImagePath(String propertyKey, String propertyName, String componentName, boolean fallback) {
        return (String)SyntheticaLookAndFeel.get(propertyKey, propertyName, componentName, fallback, true);
    }

    public String getScaleKeyExtension() {
        return ".@2x";
    }

    public int getHiDpiImageThreshold() {
        return SyntheticaLookAndFeel.getInt("Synthetica.hiDpiImageThreshold", null, 120);
    }

    public int getHiDpiImageScaleFactor() {
        return SyntheticaLookAndFeel.getInt("Synthetica.hiDpiImageScaleFactor", null, 200);
    }

    public static String getString(String key, Component c) {
        return (String)SyntheticaLookAndFeel.get(key, c);
    }

    public static String getString(String key, Component c, String defaultValue) {
        Object o = SyntheticaLookAndFeel.get(key, c);
        return o != null ? (String)o : defaultValue;
    }

    public static Color getColor(String key, Component c) {
        return (Color)SyntheticaLookAndFeel.get(key, c);
    }

    public static Color getColor(String key, Component c, Color defaultColor) {
        Object o = SyntheticaLookAndFeel.get(key, c);
        return o != null ? (Color)o : defaultColor;
    }

    public static Icon getIcon(String key, Component c) {
        return SyntheticaLookAndFeel.getIcon(key, c, false);
    }

    public static Icon getIcon(String key, Component c, boolean scaled) {
        Icon icon = (Icon)SyntheticaLookAndFeel.get(key, c);
        return scaled ? (icon instanceof UIResource ? new ScalableIcon.ScalableIconUIResource(icon) : new ScalableIcon(icon)) : icon;
    }

    public static boolean isToplevelPopupMenu(JPopupMenu popup) {
        Component invoker = popup.getInvoker();
        boolean toplevelPopupEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.toplevel.enabled", popup, false);
        boolean toplevelMenuEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.menu.toplevel.popupMenu.toplevel.enabled", popup, toplevelPopupEnabled);
        if (invoker instanceof JMenu && toplevelMenuEnabled) {
            return ((JMenu)invoker).isTopLevelMenu() || SyntheticaLookAndFeel.getClientProperty("Synthetica.menu.toplevel", (JMenu)invoker, false) != false;
        }
        return toplevelPopupEnabled && SyntheticaLookAndFeel.getClientProperty("Synthetica.popupMenu.toplevel", popup, false) != false;
    }

    public static <T extends JComponent> T findOpaqueParentOfClass(Class<T> clazz, Container c, boolean respectOpacity) {
        if (c == null) {
            return null;
        }
        if (c instanceof JComponent && clazz.isInstance(c) && (respectOpacity && c.isOpaque() || SyntheticaLookAndFeel.isOpaque((JComponent)c))) {
            return (T)((JComponent)c);
        }
        if (c.isOpaque()) {
            return null;
        }
        return SyntheticaLookAndFeel.findOpaqueParentOfClass(clazz, c.getParent(), respectOpacity);
    }

    public static boolean isOpaque(JComponent c) {
        if (c == null) {
            return true;
        }
        boolean opaque = c.getBackground() == null || c.getBackground().getAlpha() != 0;
        boolean bl = opaque = c.getClientProperty("Synthetica.opaque") == null ? opaque : (Boolean)c.getClientProperty("Synthetica.opaque");
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.textComponents.useSwingOpaqueness", c)) {
            opaque = c.isOpaque();
        }
        return opaque;
    }

    public static void setChildrenOpaque(Container container, boolean opaque) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.setOpaque(opaque);
                jc.putClientProperty("Synthetica.opaque", opaque);
                SyntheticaLookAndFeel.setChildrenOpaque(jc, opaque);
            }
            ++n2;
        }
    }

    public static Rectangle validateWindowBounds(Rectangle windowBounds) {
        Rectangle bounds = new Rectangle(windowBounds);
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.windowBoundsValidation.enabled", null, true)) {
            Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
            int minX = screenBounds.x;
            int maxX = screenBounds.x + screenBounds.width - bounds.width;
            int minY = screenBounds.y;
            int maxY = screenBounds.y + screenBounds.height - bounds.height;
            if (!SyntheticaLookAndFeel.isInScreen(bounds.x, bounds.y)) {
                if (bounds.x < minX) {
                    bounds.x = minX;
                } else if (bounds.x > maxX) {
                    bounds.x = maxX;
                }
                if (bounds.y < minY) {
                    bounds.y = minY;
                } else if (bounds.y > maxY) {
                    bounds.y = maxY;
                }
            }
        }
        return bounds;
    }

    private static boolean isInScreen(int x, int y) {
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice gd = graphicsDeviceArray[n2];
            Rectangle screenBounds = gd.getDefaultConfiguration().getBounds();
            if (screenBounds.contains(x, y)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isWindowOpacityEnabled(Window w) {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.window.opaque", w, true);
    }

    public static void setWindowOpaque(Window w, boolean opaque) {
        if (w != null) {
            w.setBackground(opaque ? null : new Color(0, 0, 0, 0));
        }
    }

    public static boolean isWindowShapeEnabled(Window w) {
        String shapeType = SyntheticaLookAndFeel.getString("Synthetica.window.shape", w);
        return shapeType != null && !shapeType.equals("NONE");
    }

    public static boolean isWindowShapeSupported(Window w) {
        boolean shapeSupport = true;
        if (OS.getCurrentOS() == OS.Mac) {
            shapeSupport &= SyntheticaLookAndFeel.getBoolean("Synthetica.window.shapeSupportOnMac", w, false);
        }
        return shapeSupport;
    }

    public static void updateWindowShape(Window w) {
        if (w instanceof JFrame && !((JFrame)w).isUndecorated() || w instanceof JDialog && !((JDialog)w).isUndecorated() || SyntheticaLookAndFeel.windowIsFullScreen(w) || SyntheticaLookAndFeel.getJVMCompatibilityMode() != JVMCompatibilityMode.SUN) {
            return;
        }
        if (OS.getCurrentOS() == OS.Mac && !SyntheticaLookAndFeel.isWindowShapeSupported(w)) {
            SyntheticaLookAndFeel.setWindowOpaque(w, false);
            return;
        }
        boolean maximized = w instanceof Frame && (((Frame)w).getExtendedState() & 6) == 6;
        String shapeType = SyntheticaLookAndFeel.getString("Synthetica.window.shape", w);
        Shape shape = null;
        if (maximized || !SyntheticaLookAndFeel.isWindowShapeEnabled(w)) {
            shape = null;
        } else if ("ROUND_RECT".equals(shapeType)) {
            int arcW = SyntheticaLookAndFeel.getInt("Synthetica.window.arcW", w, 18, true);
            int arcH = SyntheticaLookAndFeel.getInt("Synthetica.window.arcH", w, 18, true);
            shape = new RoundRectangle2D.Float(0.0f, 0.0f, w.getWidth(), w.getHeight(), arcW, arcH);
        } else {
            try {
                shape = ((SyntheticaWindowShape)Class.forName(shapeType).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getShape(w.getWidth(), w.getHeight());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        w.setShape(shape);
    }

    public static boolean windowIsFullScreen(Window w) {
        return w.getGraphicsConfiguration().getDevice().getFullScreenWindow() == w;
    }

    private static void updateAllWindowShapes() {
        Window[] windowArray = Window.getWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isAWTWindow;
            Window w = windowArray[n2];
            boolean bl = isAWTWindow = !(w instanceof JWindow) && !(w instanceof JFrame) && !(w instanceof JDialog);
            if (!w.getClass().getName().contains("Popup$HeavyWeightWindow") && !isAWTWindow) {
                SyntheticaLookAndFeel.updateWindowShape(w);
            }
            ++n2;
        }
    }

    public static boolean isSystemPropertySet(String systemPropertyName) {
        return SyntheticaLookAndFeel.isSystemPropertySet(systemPropertyName, false);
    }

    public static boolean isSystemPropertySet(String systemPropertyName, boolean defaultValue) {
        String s;
        block4: {
            try {
                s = System.getProperty(systemPropertyName);
                if (s == null) {
                    return defaultValue;
                }
                if (s.length() != 0) break block4;
                return true;
            }
            catch (AccessControlException e) {
                return false;
            }
        }
        return Boolean.parseBoolean(s);
    }

    public static boolean isSystemPropertySet(String systemPropertyName, String value) {
        String s;
        block3: {
            try {
                s = System.getProperty(systemPropertyName);
                if (s != null) break block3;
                return false;
            }
            catch (AccessControlException e) {
                return false;
            }
        }
        return s.equals(value);
    }

    public static int getSystemPropertyInt(String systemPropertyName, int defaultValue) {
        try {
            String s = System.getProperty(systemPropertyName);
            if (s == null) {
                return defaultValue;
            }
            return Integer.valueOf(s);
        }
        catch (AccessControlException e) {
            return defaultValue;
        }
    }

    public boolean isUIScalingEnabled() {
        return this.getScaleFactor() != 1.0f || this.isSwingUIScalingEnabled();
    }

    public boolean isSwingUIScalingEnabled() {
        if (uiScaleEnabled != null) {
            return uiScaleEnabled;
        }
        GraphicsEnvironment en = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!GraphicsEnvironment.isHeadless()) {
            GraphicsDevice[] graphicsDeviceArray = en.getScreenDevices();
            int n = graphicsDeviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsDevice gd = graphicsDeviceArray[n2];
                if (gd.getDefaultConfiguration().getDefaultTransform().getScaleX() > 1.0 || gd.getDefaultConfiguration().getDefaultTransform().getScaleY() > 1.0) {
                    uiScaleEnabled = true;
                    return uiScaleEnabled;
                }
                ++n2;
            }
        }
        uiScaleEnabled = false;
        return uiScaleEnabled;
    }

    public float getScaleFactor() {
        return (float)this.getPercentageScaleFactor() / 100.0f;
    }

    private int getPercentageScaleFactor() {
        return SyntheticaLookAndFeel.getInt("Synthetica.scaleFactor", null, systemScaleFactor, false);
    }

    public float scaleFontSize(float fontSize) {
        float size = fontSize;
        int scaleFactor = this.getPercentageScaleFactor();
        if (scaleFactor == 100 && SyntheticaLookAndFeel.getBoolean("Synthetica.font.respectSystemDPI", null, !this.isSwingUIScalingEnabled())) {
            Object val;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            int dpi = 96;
            if (OS.getCurrentOS() == OS.Windows) {
                dpi = toolkit.getScreenResolution();
            } else if (OS.getCurrentOS() == OS.Linux && (val = toolkit.getDesktopProperty("gnome.Xft/DPI")) instanceof Integer) {
                dpi = (Integer)val / 1024;
            }
            size = (float)dpi * fontSize / 96.0f;
        }
        int fontScaleFactor = SyntheticaLookAndFeel.getInt("Synthetica.font.scaleFactor", null, scaleFactor, false);
        size = (float)fontScaleFactor * size / 100.0f;
        return size;
    }

    public Insets scaleInsets(Insets insets) {
        float scaleFactor = this.getScaleFactor();
        if (insets instanceof UIResource) {
            return new InsetsUIResource(Math.round((float)insets.top * scaleFactor), Math.round((float)insets.left * scaleFactor), Math.round((float)insets.bottom * scaleFactor), Math.round((float)insets.right * scaleFactor));
        }
        return new Insets(Math.round((float)insets.top * scaleFactor), Math.round((float)insets.left * scaleFactor), Math.round((float)insets.bottom * scaleFactor), Math.round((float)insets.right * scaleFactor));
    }

    public Insets scaleInsets(int top, int left, int bottom, int right) {
        return this.scaleInsets(top, left, bottom, right, false);
    }

    public Insets scaleInsets(int top, int left, int bottom, int right, boolean asUIResource) {
        float scaleFactor = this.getScaleFactor();
        if (asUIResource) {
            return new InsetsUIResource(Math.round((float)top * scaleFactor), Math.round((float)left * scaleFactor), Math.round((float)bottom * scaleFactor), Math.round((float)right * scaleFactor));
        }
        return new Insets(Math.round((float)top * scaleFactor), Math.round((float)left * scaleFactor), Math.round((float)bottom * scaleFactor), Math.round((float)right * scaleFactor));
    }

    public Point scalePoint(Point p) {
        return this.scalePoint(p.x, p.y);
    }

    public Point scalePoint(int x, int y) {
        float scaleFactor = this.getScaleFactor();
        return new Point(Math.round((float)x * scaleFactor), Math.round((float)y * scaleFactor));
    }

    public Dimension scaleDimension(Dimension dim) {
        float scaleFactor = this.getScaleFactor();
        if (dim instanceof UIResource) {
            return new DimensionUIResource(Math.round((float)dim.width * scaleFactor), Math.round((float)dim.height * scaleFactor));
        }
        return new Dimension(Math.round((float)dim.width * scaleFactor), Math.round((float)dim.height * scaleFactor));
    }

    public Dimension scaleDimension(int width, int height) {
        return this.scaleDimension(width, height, false);
    }

    public Dimension scaleDimension(int width, int height, boolean asUIResource) {
        float scaleFactor = this.getScaleFactor();
        if (asUIResource) {
            return new DimensionUIResource(Math.round((float)width * scaleFactor), Math.round((float)height * scaleFactor));
        }
        return new Dimension(Math.round((float)width * scaleFactor), Math.round((float)height * scaleFactor));
    }

    public Rectangle scaleBounds(Rectangle rect) {
        float scaleFactor = this.getScaleFactor();
        if (rect instanceof UIResource) {
            new RectangleUIResource(Math.round((float)rect.x * scaleFactor), Math.round((float)rect.y * scaleFactor), Math.round((float)rect.width * scaleFactor), Math.round((float)rect.height * scaleFactor));
        }
        return new Rectangle(Math.round((float)rect.x * scaleFactor), Math.round((float)rect.y * scaleFactor), Math.round((float)rect.width * scaleFactor), Math.round((float)rect.height * scaleFactor));
    }

    public Rectangle scaleBounds(int x, int y, int w, int h) {
        return this.scaleBounds(x, y, w, h, false);
    }

    public Rectangle scaleBounds(int x, int y, int w, int h, boolean asUIResource) {
        float scaleFactor = this.getScaleFactor();
        if (asUIResource) {
            return new RectangleUIResource(Math.round((float)x * scaleFactor), Math.round((float)y * scaleFactor), Math.round((float)w * scaleFactor), Math.round((float)h * scaleFactor));
        }
        return new Rectangle(Math.round((float)x * scaleFactor), Math.round((float)y * scaleFactor), Math.round((float)w * scaleFactor), Math.round((float)h * scaleFactor));
    }

    public Integer scaleInteger(Integer val) {
        return Math.round(this.getScaleFactor() * (float)val.intValue());
    }

    public Float scaleFloat(Float val) {
        return Float.valueOf(this.getScaleFactor() * val.floatValue());
    }

    public Border createEmptyBorder(Insets insets, boolean scaled) {
        return this.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right, scaled);
    }

    public Border createEmptyBorder(int top, int left, int bottom, int right, boolean scaled) {
        if (!scaled) {
            return BorderFactory.createEmptyBorder(top, left, bottom, right);
        }
        float scaleFactor = this.getScaleFactor();
        return BorderFactory.createEmptyBorder(Math.round((float)top * scaleFactor), Math.round((float)left * scaleFactor), Math.round((float)bottom * scaleFactor), Math.round((float)right * scaleFactor));
    }

    public Border createMatteBorder(Insets insets, Color color, boolean scaled) {
        return this.createMatteBorder(insets.top, insets.left, insets.bottom, insets.right, color, scaled);
    }

    public Border createMatteBorder(int top, int left, int bottom, int right, Color color, boolean scaled) {
        if (!scaled) {
            return BorderFactory.createMatteBorder(top, left, bottom, right, color);
        }
        float scaleFactor = this.getScaleFactor();
        return BorderFactory.createMatteBorder(Math.round((float)top * scaleFactor), Math.round((float)left * scaleFactor), Math.round((float)bottom * scaleFactor), Math.round((float)right * scaleFactor), color);
    }

    public Border createLineBorder(Color color, boolean scaled) {
        return this.createLineBorder(color, 1, scaled);
    }

    public Border createLineBorder(Color color, int thickness, boolean scaled) {
        return scaled ? BorderFactory.createLineBorder(color, Math.round((float)thickness * this.getScaleFactor())) : BorderFactory.createLineBorder(color, thickness);
    }

    public Border createLineBorder(Color color, int thickness, boolean scaled, boolean asUIResource) {
        if (asUIResource) {
            return scaled ? new BorderUIResource.LineBorderUIResource(color, Math.round((float)thickness * this.getScaleFactor())) : new BorderUIResource.LineBorderUIResource(color, thickness);
        }
        return this.createLineBorder(color, thickness, scaled);
    }

    public static void setChildrenName(Container container, String oldName, String newName) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (oldName.equals(SyntheticaLookAndFeel.getStyleName(c))) {
                if (c instanceof JComponent && ((JComponent)c).getClientProperty("Synthetica.style") != null) {
                    ((JComponent)c).putClientProperty("Synthetica.style", newName);
                } else {
                    c.setName(newName);
                }
            }
            if (c instanceof Container) {
                SyntheticaLookAndFeel.setChildrenName((Container)c, oldName, newName);
            }
            ++n2;
        }
    }

    public static Component findComponent(String name, Container container) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component cc;
            Component c = componentArray[n2];
            if (name.equals(SyntheticaLookAndFeel.getStyleName(c))) {
                return c;
            }
            if (c instanceof Container && (cc = SyntheticaLookAndFeel.findComponent(name, (Container)c)) != null) {
                return cc;
            }
            ++n2;
        }
        return null;
    }

    public static Component findComponent(Class<?> childClass, Container container) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component cc;
            Component c = componentArray[n2];
            if (childClass.isInstance(c)) {
                return c;
            }
            if (c instanceof Container && (cc = SyntheticaLookAndFeel.findComponent(childClass, (Container)c)) != null) {
                return cc;
            }
            ++n2;
        }
        return null;
    }

    public static <T extends Component> List<T> findComponents(String name, Container container, List<T> components) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (name.equals(SyntheticaLookAndFeel.getStyleName(c))) {
                components.add(c);
            }
            if (c instanceof Container) {
                SyntheticaLookAndFeel.findComponents(name, (Container)c, components);
            }
            ++n2;
        }
        return components;
    }

    public static <T extends Component> List<T> findComponents(Class<T> childClass, Container container, List<T> components) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (childClass.isInstance(c)) {
                components.add(c);
            }
            if (c instanceof Container) {
                SyntheticaLookAndFeel.findComponents(childClass, (Container)c, components);
            }
            ++n2;
        }
        return components;
    }

    public static Border findDefaultBorder(Border b) {
        if (b instanceof UIResource) {
            return b;
        }
        if (b instanceof CompoundBorder) {
            Border ob = SyntheticaLookAndFeel.findDefaultBorder(((CompoundBorder)b).getOutsideBorder());
            if (ob != null) {
                return ob;
            }
            Border ib = SyntheticaLookAndFeel.findDefaultBorder(((CompoundBorder)b).getInsideBorder());
            if (ib != null) {
                return ib;
            }
        }
        return null;
    }

    public static boolean preservePopupIconSpace(JPopupMenu popup) {
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.forceIconSpace", popup, false)) {
            return true;
        }
        return SyntheticaLookAndFeel.popupHasIcons(popup);
    }

    public static boolean popupHasIcons(JPopupMenu popup) {
        ArrayList list = new ArrayList();
        SyntheticaLookAndFeel.findComponents(JMenuItem.class, (Container)popup, list);
        if (list.size() == 0) {
            return false;
        }
        for (JMenuItem item : list) {
            if (item.getIcon() == null) continue;
            return true;
        }
        return false;
    }

    public static boolean popupHasCheckRadio(JPopupMenu popup) {
        ArrayList list = new ArrayList();
        SyntheticaLookAndFeel.findComponents(JMenuItem.class, (Container)popup, list);
        if (list.size() == 0) {
            return false;
        }
        for (JMenuItem item : list) {
            if (!(item instanceof JCheckBoxMenuItem) && !(item instanceof JRadioButtonMenuItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean popupHasCheckRadioWithIcon(JPopupMenu popup) {
        ArrayList list = new ArrayList();
        SyntheticaLookAndFeel.findComponents(JMenuItem.class, (Container)popup, list);
        for (JMenuItem mi : list) {
            if (!(mi instanceof JCheckBoxMenuItem) && !(mi instanceof JRadioButtonMenuItem) || mi.getIcon() == null) continue;
            return true;
        }
        return false;
    }

    public static Paint createLinearGradientPaint(float startX, float startY, float endX, float endY, float[] fractions, Color[] colors) {
        if (startX == endX && startY == endY) {
            endY += 1.0E-6f;
        }
        return new LinearGradientPaint(startX, startY, endX, endY, fractions, colors);
    }

    public static void setLookAndFeel(String lookAndFeelClassName) {
        SyntheticaLookAndFeel.setLookAndFeel(lookAndFeelClassName, true, true);
    }

    public static void setLookAndFeel(String lookAndFeelClassName, boolean antiAlias, boolean useScreenMenuBar) {
        try {
            if (antiAlias) {
                if (OS.getCurrentOS() == OS.Mac) {
                    System.setProperty("apple.awt.textantialiasing", "on");
                } else {
                    System.setProperty("swing.aatext", String.valueOf(antiAlias));
                }
            }
            if (useScreenMenuBar && OS.getCurrentOS() == OS.Mac && SyntheticaLookAndFeel.screenMenuBarSupportedByOSX() && SyntheticaLookAndFeel.getBoolean("Synthetica.screenMenuBarOnMacEnabled", null, true)) {
                System.setProperty("apple.laf.useScreenMenuBar", String.valueOf(useScreenMenuBar));
                SyntheticaLookAndFeel.setLookAndFeelWorkaround(UIManager.getSystemLookAndFeelClassName());
                String mbUI = UIManager.getString("MenuBarUI");
                Font miAccFont = UIManager.getFont("MenuItem.acceleratorFont");
                Boolean mBorderPainted = UIManager.getBoolean("Menu.borderPainted");
                Boolean miBorderPainted = UIManager.getBoolean("MenuItem.borderPainted");
                Boolean rbmiBorderPainted = UIManager.getBoolean("RadioButtonMenuItem.borderPainted");
                Boolean cbmiBorderPainted = UIManager.getBoolean("CheckBoxButtonMenuItem.borderPainted");
                UIManager.put("Menu.borderPainted", mBorderPainted);
                UIManager.put("MenuItem.acceleratorFont", miAccFont);
                UIManager.put("MenuItem.borderPainted", miBorderPainted);
                UIManager.put("RadioButtonMenuItem.borderPainted", rbmiBorderPainted);
                UIManager.put("CheckBoxMenuItem.borderPainted", cbmiBorderPainted);
                UIManager.put("MenuBarUI", mbUI);
            }
            SyntheticaLookAndFeel.setLookAndFeelWorkaround(lookAndFeelClassName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean screenMenuBarSupportedByOSX() {
        String version = OS.getVersion();
        return !version.contains("10.4.");
    }

    private static void setLookAndFeelWorkaround(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        Locale defaultLocale = Locale.getDefault();
        boolean useLocaleWorkaround = "tr".equalsIgnoreCase(defaultLocale.getLanguage());
        if (useLocaleWorkaround) {
            Locale.setDefault(Locale.US);
        }
        UIManager.setLookAndFeel(className);
        if (useLocaleWorkaround) {
            Locale.setDefault(defaultLocale);
        }
    }

    public static enum JVMCompatibilityMode {
        COMMON,
        SUN;

    }

    public static class RectangleUIResource
    extends Rectangle
    implements UIResource {
        public RectangleUIResource(int x, int y, int w, int h) {
            super(x, y, w, h);
        }
    }

    private static class Version
    implements IVersion {
        private int major;
        private int minor;
        private int revision;
        private int build;

        public Version() {
            ResourceBundle rb = SyntheticaLookAndFeel.getResourceBundle("version", new Locale("", ""), this.getClass().getModule());
            this.major = Integer.parseInt(rb.getString("major"));
            this.minor = Integer.parseInt(rb.getString("minor"));
            this.revision = Integer.parseInt(rb.getString("revision"));
            this.build = Integer.parseInt(rb.getString("build"));
        }

        @Override
        public int getMajor() {
            return this.major;
        }

        @Override
        public int getMinor() {
            return this.minor;
        }

        @Override
        public int getRevision() {
            return this.revision;
        }

        @Override
        public int getBuild() {
            return this.build;
        }

        @Override
        public String toString() {
            return String.valueOf(this.major) + "." + this.minor + "." + this.revision + " Build " + this.build;
        }
    }
}

