/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

class SyntheticaInternalFrameTitlePaneLayout5
implements LayoutManager {
    private JInternalFrame frame;
    private BasicInternalFrameTitlePane titlePane;
    private JButton menuButton;
    private JButton iconButton;
    private JButton maxButton;
    private JButton closeButton;
    private int buttonSpacing = 2;
    private int titleSpacing = 2;

    public SyntheticaInternalFrameTitlePaneLayout5(BasicInternalFrameTitlePane titlePane) {
        this.titlePane = titlePane;
        Container parent = titlePane.getParent();
        this.frame = parent instanceof JInternalFrame ? (JInternalFrame)parent : ((JInternalFrame.JDesktopIcon)parent).getInternalFrame();
        this.menuButton = (JButton)SyntheticaLookAndFeel.findComponent("InternalFrameTitlePane.menuButton", (Container)titlePane);
        this.iconButton = (JButton)SyntheticaLookAndFeel.findComponent("InternalFrameTitlePane.iconifyButton", (Container)titlePane);
        this.maxButton = (JButton)SyntheticaLookAndFeel.findComponent("InternalFrameTitlePane.maximizeButton", (Container)titlePane);
        this.closeButton = (JButton)SyntheticaLookAndFeel.findComponent("InternalFrameTitlePane.closeButton", (Container)titlePane);
    }

    @Override
    public void addLayoutComponent(String name, Component c) {
    }

    @Override
    public void removeLayoutComponent(Component c) {
    }

    @Override
    public Dimension preferredLayoutSize(Container c) {
        return this.minimumLayoutSize(c);
    }

    @Override
    public Dimension minimumLayoutSize(Container c) {
        int clippedTitleWidth;
        int titleLength;
        int w = 0;
        int h = 0;
        int buttons = 0;
        Dimension pref = this.menuButton.getPreferredSize();
        w += pref.width;
        h = Math.max(pref.height, h);
        if (this.frame.isClosable()) {
            ++buttons;
            pref = this.closeButton.getPreferredSize();
            w += pref.width;
            h = Math.max(pref.height, h);
        }
        if (this.frame.isMaximizable()) {
            ++buttons;
            pref = this.maxButton.getPreferredSize();
            w += pref.width;
            h = Math.max(pref.height, h);
        }
        if (this.frame.isIconifiable()) {
            ++buttons;
            pref = this.iconButton.getPreferredSize();
            w += pref.width;
            h = Math.max(pref.height, h);
        }
        w += buttons > 0 ? (buttons - 1) * this.buttonSpacing : 0;
        FontMetrics fm = this.titlePane.getFontMetrics(this.titlePane.getFont());
        h = Math.max(fm.getHeight() + 2, h);
        String title = this.frame.getTitle();
        int titleWidth = title != null ? SwingUtilities.computeStringWidth(fm, title) : 0;
        int n = titleLength = title != null ? title.length() : 0;
        w = titleLength > 3 ? (w += titleWidth < (clippedTitleWidth = SwingUtilities.computeStringWidth(fm, String.valueOf(title.substring(0, 3)) + "...")) ? titleWidth : clippedTitleWidth) : (w += titleWidth);
        w += this.titleSpacing * 2;
        Insets insets = this.titlePane.getInsets();
        return new Dimension(w += insets.left + insets.right, h += insets.top + insets.bottom);
    }

    @Override
    public void layoutContainer(Container c) {
        Insets insets = c.getInsets();
        if (this.frame.getComponentOrientation().isLeftToRight()) {
            this.setButtonBounds(this.menuButton, insets.left, false);
            int x = this.titlePane.getWidth() - insets.right;
            if (this.frame.isClosable()) {
                x = this.setButtonBounds(this.closeButton, x, true);
            }
            if (this.frame.isMaximizable()) {
                x = this.setButtonBounds(this.maxButton, x, true);
            }
            if (this.frame.isIconifiable()) {
                x = this.setButtonBounds(this.iconButton, x, true);
            }
        } else {
            this.setButtonBounds(this.menuButton, this.titlePane.getWidth() - insets.right, true);
            int x = insets.left;
            if (this.frame.isClosable()) {
                x = this.setButtonBounds(this.closeButton, x, false);
            }
            if (this.frame.isMaximizable()) {
                x = this.setButtonBounds(this.maxButton, x, false);
            }
            if (this.frame.isIconifiable()) {
                int n = this.setButtonBounds(this.iconButton, x, false);
            }
        }
    }

    private int setButtonBounds(JButton b, int x, boolean trailing) {
        Insets insets = this.titlePane.getInsets();
        Dimension pref = b.getPreferredSize();
        if (trailing) {
            x -= pref.width;
        }
        b.setBounds(x, insets.top + (this.titlePane.getHeight() - insets.top - insets.bottom - pref.height) / 2, pref.width, pref.height);
        if (trailing) {
            return x - this.buttonSpacing;
        }
        return x + pref.width + this.buttonSpacing;
    }
}

