/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.TablePainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.DefaultTableCellRenderer;

class SyntheticaHeaderRenderer5
extends DefaultTableCellRenderer
implements UIResource {
    private static final long serialVersionUID = -5043195354176641815L;
    private JTable table;
    private int column;

    SyntheticaHeaderRenderer5() {
        this.setHorizontalAlignment(SyntheticaLookAndFeel.getInt("Synthetica.tableHeader.horizontalAlignment", (Component)this, 10));
        this.setName("TableHeader.renderer");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.table = table;
        this.column = column;
        if (table != null && !hasFocus) {
            SynthStyle ss = SynthLookAndFeel.getStyle(table.getTableHeader(), Region.TABLE_HEADER);
            SynthContext sc = new SynthContext(table.getTableHeader(), Region.TABLE_HEADER, ss, 0);
            Insets insets = ss.getInsets(sc, null);
            Border border = this.getBorder();
            Border uiBorder = UIManager.getBorder("TableHeader.cellBorder");
            if (uiBorder != null) {
                if (border != uiBorder) {
                    this.setBorder(uiBorder);
                }
            } else if (insets.equals(new Insets(0, 0, 0, 0))) {
                this.setBorder(noFocusBorder);
            } else {
                this.setBorder(new EmptyBorder(insets));
            }
        }
        this.setValue(value);
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.table != null) {
            boolean painted = false;
            int[] sortedColumns = (int[])this.table.getClientProperty("SORTABLE_TABLE_SORTED_COLUMNS");
            Boolean paintSortBackground = (Boolean)this.table.getClientProperty("SORTABLE_TABLE_PAINT_SORT_BACKGROUND");
            if (sortedColumns != null && paintSortBackground != null && paintSortBackground.booleanValue()) {
                int[] nArray = sortedColumns;
                int n = sortedColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    int col = nArray[n2];
                    if (col == this.column) {
                        TablePainter.getInstance().paintTableHeaderCellBackground(this.table, new SyntheticaState(0), g, 0, 0, this.getWidth(), this.getHeight(), 1);
                        painted = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!painted) {
                TablePainter.getInstance().paintTableHeaderCellBackground(this.table, new SyntheticaState(0), g, 0, 0, this.getWidth(), this.getHeight(), 0);
            }
        }
        super.paintComponent(g);
    }

    @Override
    public boolean isOpaque() {
        Boolean opaque = (Boolean)SyntheticaLookAndFeel.get("Synthetica.tableHeader.opaque", this.table);
        return opaque == null ? super.isOpaque() : opaque.booleanValue();
    }
}

