/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.TablePainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.TableModel;
import sun.swing.table.DefaultTableCellHeaderRenderer;

class SyntheticaHeaderRenderer
extends DefaultTableCellHeaderRenderer
implements UIResource {
    private static final long serialVersionUID = -4089492349514455249L;
    private JTable table;
    private int column;

    static {
        $SWITCH_TABLE$javax$swing$SortOrder = SyntheticaHeaderRenderer.$SWITCH_TABLE$javax$swing$SortOrder();
    }

    SyntheticaHeaderRenderer() {
        this.setHorizontalAlignment(SyntheticaLookAndFeel.getInt("Synthetica.tableHeader.horizontalAlignment", (Component)this, 10));
        this.setName("TableHeader.renderer");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.table = table;
        this.column = column;
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!hasFocus && c instanceof JComponent && table != null && table.getTableHeader() != null && c instanceof JComponent) {
            JComponent comp = (JComponent)c;
            SynthStyle ss = SynthLookAndFeel.getStyle(table.getTableHeader(), Region.TABLE_HEADER);
            SynthContext sc = new SynthContext(table.getTableHeader(), Region.TABLE_HEADER, ss, 0);
            Insets insets = ss.getInsets(sc, null);
            Border border = comp.getBorder();
            Border uiBorder = UIManager.getBorder("TableHeader.cellBorder");
            if (uiBorder != null) {
                if (border != uiBorder) {
                    comp.setBorder(uiBorder);
                }
            } else if (insets.equals(new Insets(0, 0, 0, 0))) {
                if (border == null) {
                    comp.setBorder(noFocusBorder);
                }
            } else {
                comp.setBorder(new EmptyBorder(insets));
            }
        }
        if (table != null && table.getRowSorter() != null) {
            for (RowSorter.SortKey sortKey : this.getSortKeys(table)) {
                if (sortKey.getColumn() != table.convertColumnIndexToModel(column)) continue;
                Icon sortIcon = null;
                switch (sortKey.getSortOrder()) {
                    case ASCENDING: {
                        sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                        break;
                    }
                    case DESCENDING: {
                        sortIcon = UIManager.getIcon("Table.descendingSortIcon");
                        break;
                    }
                    default: {
                        sortIcon = UIManager.getIcon("Table.naturalSortIcon");
                    }
                }
                this.setIcon(sortIcon);
            }
        }
        return c;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.table != null) {
            int sortOrder = 0;
            boolean painted = false;
            int[] sortedColumns = (int[])this.table.getClientProperty("SORTABLE_TABLE_SORTED_COLUMNS");
            Boolean paintSortBackground = (Boolean)this.table.getClientProperty("SORTABLE_TABLE_PAINT_SORT_BACKGROUND");
            if (sortedColumns != null && paintSortBackground != null && paintSortBackground.booleanValue()) {
                int[] nArray = sortedColumns;
                int n = sortedColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    int col = nArray[n2];
                    if (col == this.column) {
                        TablePainter.getInstance().paintTableHeaderCellBackground(this.table, new SyntheticaState(0), g, 0, 0, this.getWidth(), this.getHeight(), 1);
                        painted = true;
                        break;
                    }
                    ++n2;
                }
            } else if (this.table.getRowSorter() != null) {
                for (RowSorter.SortKey sortKey : this.getSortKeys(this.table)) {
                    if (sortKey.getColumn() != this.table.convertColumnIndexToModel(this.column)) continue;
                    switch (sortKey.getSortOrder()) {
                        case ASCENDING: {
                            sortOrder = 1;
                            break;
                        }
                        case DESCENDING: {
                            sortOrder = 2;
                            break;
                        }
                    }
                    TablePainter.getInstance().paintTableHeaderCellBackground(this.table, new SyntheticaState(0), g, 0, 0, this.getWidth(), this.getHeight(), sortOrder);
                    painted = true;
                }
            }
            if (!painted) {
                TablePainter.getInstance().paintTableHeaderCellBackground(this.table, new SyntheticaState(0), g, 0, 0, this.getWidth(), this.getHeight(), sortOrder);
            }
        }
        super.paintComponent(g);
    }

    private List<RowSorter.SortKey> getSortKeys(JTable table) {
        RowSorter<? extends TableModel> rowSorter = table.getRowSorter();
        List<RowSorter.SortKey> sortKeys = rowSorter.getSortKeys();
        if (sortKeys.size() > 0) {
            sortKeys = new ArrayList<RowSorter.SortKey>();
            sortKeys.add(rowSorter.getSortKeys().get(0));
        }
        return sortKeys;
    }

    @Override
    public boolean isOpaque() {
        Boolean opaque = (Boolean)SyntheticaLookAndFeel.get("Synthetica.tableHeader.opaque", this.table);
        return opaque == null ? super.isOpaque() : opaque.booleanValue();
    }
}

