/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;

public class SyntheticaDefaultTableCellRenderer
extends JLabel
implements TableCellRenderer,
Serializable,
UIResource {
    private static final long serialVersionUID = 9059722839161202006L;
    private Border noFocusBorder;
    private Border focusBorder;
    private NumberFormat numberFormat;
    private DateFormat dateFormat;
    private Color alternateColor;
    private boolean colorCachingEnabled;
    private Color unselectedForeground;
    private Color unselectedBackground;

    public SyntheticaDefaultTableCellRenderer(TableCellRenderer renderer) {
        this.setOpaque(true);
        Border dBorder = renderer == null ? new EmptyBorder(0, 0, 0, 0) : ((JComponent)((Object)renderer)).getBorder();
        Insets dInsets = dBorder == null ? new Insets(0, 0, 0, 0) : dBorder.getBorderInsets(null);
        Border fb = UIManager.getBorder("Table.focusCellHighlightBorder");
        Border fBorder = fb == null ? new EmptyBorder(0, 0, 0, 0) : fb;
        Insets fInsets = fBorder.getBorderInsets(null);
        Insets insets = new Insets(dInsets.top - fInsets.top, dInsets.left - fInsets.left, dInsets.bottom - fInsets.bottom, dInsets.right - fInsets.right);
        this.focusBorder = new CompoundBorder(fBorder, new EmptyBorder(insets));
        this.noFocusBorder = new CompoundBorder(new EmptyBorder(fInsets), new EmptyBorder(insets));
        this.alternateColor = UIManager.getColor("Table.alternateRowColor");
        this.colorCachingEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.table.cellRenderer.colorCache.enabled", null, false);
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            name = "Table.cellRenderer";
        }
        return name;
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.colorCachingEnabled) {
            this.unselectedForeground = c;
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.colorCachingEnabled) {
            this.unselectedBackground = c;
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color foreground = null;
        Color background = null;
        JTable.DropLocation dropLocation = table.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
            foreground = UIManager.getColor("Table.dropCellForeground");
            background = UIManager.getColor("Table.dropCellBackground");
            isSelected = true;
        }
        if (isSelected) {
            if (foreground == null) {
                foreground = table.getSelectionForeground();
            }
            if (background == null) {
                background = table.getSelectionBackground();
            }
        } else {
            foreground = this.unselectedForeground == null ? table.getForeground() : this.unselectedForeground;
            Color color = background = this.unselectedBackground == null ? table.getBackground() : this.unselectedBackground;
            if ((background == null || background instanceof UIResource) && this.alternateColor != null && row % 2 == 1) {
                background = this.alternateColor;
            }
            if (hasFocus && table.isCellEditable(row, column)) {
                foreground = UIManager.get("Table.focusCellForeground") == null ? foreground : UIManager.getColor("Table.focusCellForeground");
                background = UIManager.get("Table.focusCellBackground") == null ? background : UIManager.getColor("Table.focusCellBackground");
            }
        }
        super.setForeground(foreground);
        super.setBackground(background);
        if (hasFocus) {
            this.setBorder(this.focusBorder);
        } else {
            this.setBorder(this.noFocusBorder);
        }
        this.setFont(table.getFont());
        this.setValue(value);
        this.setIcon(null);
        this.configureValue(value, table.getColumnClass(column));
        return this;
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }

    private void configureValue(Object value, Class<?> clazz) {
        if (clazz == Object.class || clazz == null) {
            this.setHorizontalAlignment(10);
        } else if (clazz == Float.class || clazz == Double.class) {
            if (this.numberFormat == null) {
                this.numberFormat = NumberFormat.getInstance();
            }
            this.setHorizontalAlignment(11);
            this.setText(value == null ? "" : this.numberFormat.format(value));
        } else if (clazz == Number.class) {
            this.setHorizontalAlignment(11);
        } else if (clazz == Date.class) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance();
            }
            this.setHorizontalAlignment(10);
            this.setText(value == null ? "" : this.dateFormat.format(value));
        } else if (clazz == Icon.class || clazz == ImageIcon.class) {
            this.setHorizontalAlignment(0);
            this.setIcon(value instanceof Icon ? (Icon)value : null);
            this.setText("");
        } else {
            this.configureValue(value, clazz.getSuperclass());
        }
    }

    @Override
    public boolean isOpaque() {
        boolean colorMatch;
        Color back = this.getBackground();
        Container table = this.getParent();
        if (table != null) {
            table = table.getParent();
        }
        boolean bl = colorMatch = back != null && table != null && back.equals(table.getBackground()) && table.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text" || propertyName == "labelFor" || propertyName == "displayedMnemonic" || (propertyName == "font" || propertyName == "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

