/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.GraphicsUtils;
import de.javasoft.plaf.synthetica.Scalable;
import de.javasoft.plaf.synthetica.ScalableImage;
import de.javasoft.plaf.synthetica.SyntheticaIcon;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.util.HiDpi;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class ScalableIcon
extends SyntheticaIcon
implements Scalable {
    private Icon icon;
    private BaseMultiResolutionImage multiResImage;
    private static HashMap<Icon, Image> iconCache = new HashMap();
    private static HashMap<Integer, Image> imageCache = new HashMap();
    static int counter;

    public ScalableIcon(Class<?> resourceBase, String ... fileNames) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        try {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                URL url = resourceBase.getResource(name);
                if (url == null) {
                    throw new RuntimeException("File not found: " + name);
                }
                images.add(ImageIO.read(url));
                ++n2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.multiResImage = new BaseMultiResolutionImage(images.toArray(new Image[images.size()]));
    }

    public ScalableIcon(Image ... images) {
        this.multiResImage = new BaseMultiResolutionImage(images);
    }

    public ScalableIcon(ScalableImage image) {
        this.multiResImage = image;
    }

    public ScalableIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    protected float getScaleFactor() {
        return SyntheticaLookAndFeel.getInstance().getScaleFactor();
    }

    @Override
    public int getIconHeight() {
        if (this.icon != null) {
            if (this.icon instanceof Scalable) {
                return this.icon.getIconHeight();
            }
            return (int)((float)this.icon.getIconHeight() * this.getScaleFactor());
        }
        if (this.multiResImage != null) {
            return (int)((float)this.multiResImage.getHeight(null) * this.getScaleFactor());
        }
        return 0;
    }

    @Override
    public int getIconHeight(SynthContext sc) {
        return this.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        if (this.icon != null) {
            if (this.icon instanceof Scalable) {
                return this.icon.getIconWidth();
            }
            return (int)((float)this.icon.getIconWidth() * this.getScaleFactor());
        }
        if (this.multiResImage != null) {
            return (int)((float)this.multiResImage.getWidth(null) * this.getScaleFactor());
        }
        return 0;
    }

    @Override
    public int getIconWidth(SynthContext sc) {
        return this.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        SynthContext sc = null;
        if (c instanceof AbstractButton && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
            AbstractButton b = (AbstractButton)c;
            SynthStyle ss = SyntheticaLookAndFeel.getStyle(b, Region.BUTTON);
            int state = 0;
            state |= b.getModel().isPressed() ? 4 : 0;
            state |= b.getModel().isSelected() ? 512 : 0;
            state |= !b.getModel().isEnabled() ? 8 : 0;
            sc = new SynthContext(b, Region.BUTTON, ss, state |= b.getModel().isRollover() ? 2 : 0);
        }
        this.paintIcon(sc, g, x, y, this.getIconWidth(), this.getIconHeight());
    }

    @Override
    public void paintIcon(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        Image image = null;
        if (this.icon != null) {
            if (this.icon instanceof Scalable) {
                this.icon.paintIcon(sc.getComponent(), g, x, y);
                return;
            }
            image = iconCache.get(this.icon);
            if (image == null) {
                image = GraphicsUtils.iconToImage(sc, this.icon);
                iconCache.put(this.icon, image);
            }
        } else if (this.multiResImage != null) {
            image = this.multiResImage.getResolutionVariant(w, h);
        }
        if (SyntheticaLookAndFeel.getInstance().getScaleFactor() != 1.0f && image != null) {
            int hash = image.hashCode();
            hash = 31 * hash + w;
            Image cachedImage = imageCache.get(hash = 31 * hash + h);
            if (cachedImage == null) {
                image = HiDpi.scaleImage(image, w, h);
                imageCache.put(hash, image);
            } else {
                image = cachedImage;
            }
        }
        if (image != null) {
            g.drawImage(image, x, y, w, h, null);
        } else {
            g.setColor(Color.RED);
            g.drawLine(x, y, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y, x, y + h - 1);
            g.drawRect(x, y, w - 1, h - 1);
        }
    }

    public static class ScalableIconUIResource
    extends ScalableIcon
    implements UIResource {
        public ScalableIconUIResource(Class<?> resourceBase, String ... fileNames) {
            super(resourceBase, fileNames);
        }

        public ScalableIconUIResource(Image ... images) {
            super(images);
        }

        public ScalableIconUIResource(Icon icon) {
            super(icon);
        }
    }
}

