/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.util.OS;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboPopup;

public class Popup
extends javax.swing.Popup {
    public static final String POPUP_BACKGROUND = "POPUP_BACKGROUND";
    public static final String POPUP_LIGHTWEIGHT = "POPUP_LIGHTWEIGHT";
    private Component contents;
    private int x;
    private int y;
    private javax.swing.Popup popup;
    private Container heavyWeightContainer;
    private boolean lightWeight;

    public Popup(Component owner, Component contents, int x, int y, javax.swing.Popup delegate) {
        this.contents = contents;
        this.popup = delegate;
        this.x = x;
        this.y = y;
        Container p = contents.getParent();
        ((JComponent)p).putClientProperty(POPUP_BACKGROUND, null);
        ((JComponent)p).putClientProperty(POPUP_LIGHTWEIGHT, null);
        if (!this.isWindowOpacityEnabled(null)) {
            ((JComponent)p).setDoubleBuffered(false);
        }
        this.lightWeight = true;
        while (p != null) {
            if (p instanceof JWindow || p instanceof Panel || p instanceof Window) {
                this.heavyWeightContainer = p;
                this.lightWeight = false;
                break;
            }
            p = p.getParent();
        }
        this.internalFrameCursorBugfix(owner);
        if (this.heavyWeightContainer != null && OS.getCurrentOS() == OS.Mac && !UIManager.getBoolean("Synthetica.popup.osShadow.enabled")) {
            this.heavyWeightContainer.setBackground(new Color(0x1000000, true));
            this.heavyWeightContainer.setBackground(new Color(0, true));
            if (this.heavyWeightContainer instanceof JWindow) {
                ((JWindow)this.heavyWeightContainer).getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
                ((JWindow)this.heavyWeightContainer).getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
            }
        }
    }

    private void internalFrameCursorBugfix(Component owner) {
        if (owner != null && owner instanceof JInternalFrame) {
            Container con = ((JInternalFrame)owner).getTopLevelAncestor();
            Cursor cu = Cursor.getPredefinedCursor(0);
            if (con instanceof JFrame) {
                ((JFrame)con).getGlassPane().setCursor(cu);
                ((JFrame)con).getGlassPane().setVisible(false);
            } else if (con instanceof JWindow) {
                ((JWindow)con).getGlassPane().setCursor(cu);
                ((JWindow)con).getGlassPane().setVisible(false);
            } else if (con instanceof JDialog) {
                ((JDialog)con).getGlassPane().setCursor(cu);
                ((JDialog)con).getGlassPane().setVisible(false);
            }
        }
    }

    @Override
    public void hide() {
        Container parent;
        if (this.contents instanceof BasicComboPopup && SyntheticaLookAndFeel.getBoolean("Synthetica.workaround.8173744.enabled", null, false)) {
            try {
                long current;
                long delta;
                Field comboBox = BasicComboPopup.class.getDeclaredField("comboBox");
                comboBox.setAccessible(true);
                final JComboBox combo = (JComboBox)comboBox.get(this.contents);
                String key = "Synthetica.comboBox.popupWorkaround";
                if (this.isBugPosition(combo) && (delta = (current = System.currentTimeMillis()) - SyntheticaLookAndFeel.getClientProperty("Synthetica.comboBox.popupWorkaround", combo, current)) < 100L) {
                    if (this.heavyWeightContainer instanceof Window) {
                        this.popup.hide();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            combo.setPopupVisible(true);
                            combo.putClientProperty("Synthetica.comboBox.popupWorkaround", System.currentTimeMillis());
                        }
                    });
                    return;
                }
                combo.putClientProperty("Synthetica.comboBox.popupWorkaround", null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.heavyWeightContainer instanceof Window && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.fade-out.enabled", this.contents)) {
            int delay = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.fade-out.delay", this.contents, 25);
            int duration = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.fade-out.duration", this.contents, 150);
            WindowFader fader = new WindowFader((Window)this.heavyWeightContainer, this.popup, delay, duration, false, true);
            fader.start();
        } else if (this.popup != null) {
            this.popup.hide();
        }
        Container container = parent = this.contents == null ? null : this.contents.getParent();
        if (parent instanceof JComponent) {
            ((JComponent)parent).putClientProperty(POPUP_BACKGROUND, null);
        }
        if (this.heavyWeightContainer != null) {
            this.heavyWeightContainer = null;
        }
        this.contents = null;
        this.popup = null;
    }

    private boolean isBugPosition(JComponent c) {
        PointerInfo info = MouseInfo.getPointerInfo();
        Point p = (Point)info.getLocation().clone();
        SwingUtilities.convertPointFromScreen(p, c);
        if (p.x == c.getWidth() - 1 || p.y == c.getHeight() - 1) {
            return true;
        }
        if ((c = (JComponent)SyntheticaLookAndFeel.findComponent("ComboBox.arrowButton", (Container)c)) == null) {
            return false;
        }
        p = info.getLocation();
        SwingUtilities.convertPointFromScreen(p, c);
        Rectangle bounds = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        return bounds.contains(p) && (p.x == bounds.width - 1 || p.y == bounds.height - 1);
    }

    public javax.swing.Popup getDelegate() {
        return this.popup;
    }

    public Component getContents() {
        return this.contents;
    }

    @Override
    public void show() {
        boolean blurEnabled;
        boolean bl = blurEnabled = this.contents instanceof JPopupMenu && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.blur.enabled", this.contents);
        if (blurEnabled && this.heavyWeightContainer == null) {
            this.heavyWeightContainer = this.contents.getParent();
        }
        if (this.heavyWeightContainer == null) {
            this.popup.show();
            return;
        }
        if (this.showPopupMenuLater()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Popup.this.showPopup(blurEnabled);
                }
            });
        } else {
            this.showPopup(blurEnabled);
        }
    }

    private void showPopup(boolean blurEnabled) {
        boolean robotEnabled;
        if (this.heavyWeightContainer == null) {
            return;
        }
        if (OS.getCurrentOS() == OS.Mac && this.contents instanceof JToolTip) {
            SyntheticaLookAndFeel.setChildrenOpaque(this.heavyWeightContainer, false);
        }
        if ((robotEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.popupRobot.enabled", this.contents.getParent(), true)) && this.isSnapshotRequired(this.heavyWeightContainer instanceof Window ? (Window)this.heavyWeightContainer : null, blurEnabled)) {
            if (this.showPopupLater(this.heavyWeightContainer, blurEnabled)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Container parent;
                        if (Popup.this.contents != null && (parent = Popup.this.contents.getParent()) instanceof JComponent) {
                            ((JComponent)parent).putClientProperty(Popup.POPUP_BACKGROUND, Popup.this.snapshot());
                            ((JComponent)parent).putClientProperty(Popup.POPUP_LIGHTWEIGHT, Popup.this.lightWeight);
                        }
                    }
                });
            } else {
                ((JComponent)this.contents.getParent()).putClientProperty(POPUP_BACKGROUND, this.snapshot());
                ((JComponent)this.contents.getParent()).putClientProperty(POPUP_LIGHTWEIGHT, this.lightWeight);
            }
        }
        if (this.heavyWeightContainer instanceof Window && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.fade-in.enabled", this.contents)) {
            int delay = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.fade-in.delay", this.contents, 25);
            int duration = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.fade-in.duration", this.contents, 200);
            WindowFader fader = new WindowFader((Window)this.heavyWeightContainer, null, delay, duration, true, false);
            fader.start();
        }
        if (this.showPopupLater(this.heavyWeightContainer, blurEnabled)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Popup.this.popup != null) {
                        Popup.this.popup.show();
                    }
                }
            });
        } else {
            this.popup.show();
        }
        if (this.heavyWeightContainer instanceof Window && !this.isWindowOpacityEnabled((Window)this.heavyWeightContainer) && !blurEnabled) {
            if (OS.getCurrentOS() == OS.Windows && !this.showPopupMenuLater()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SyntheticaLookAndFeel.setWindowOpaque((Window)Popup.this.heavyWeightContainer, false);
                    }
                });
            } else {
                SyntheticaLookAndFeel.setWindowOpaque((Window)this.heavyWeightContainer, false);
            }
        }
    }

    private boolean showPopupLater(Container container, boolean blurEnabled) {
        return container instanceof Window && this.isSnapshotRequired((Window)this.heavyWeightContainer, blurEnabled) && this.showPopupMenuLater();
    }

    private boolean isSnapshotRequired(Window w, boolean blurEnabled) {
        return OS.getCurrentOS() != OS.Mac && (this.isWindowOpacityEnabled(w) || blurEnabled) || OS.getCurrentOS() == OS.Mac && blurEnabled;
    }

    private boolean isWindowOpacityEnabled(Window w) {
        boolean opaque = SyntheticaLookAndFeel.isWindowOpacityEnabled(w);
        if (!opaque) {
            return false;
        }
        return this.isPopupMenuWindowOpaque();
    }

    private boolean isPopupMenuWindowOpaque() {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.window.opaque", this.contents, true);
    }

    private boolean showPopupMenuLater() {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.showLater", this.contents, true);
    }

    private BufferedImage snapshot() {
        BufferedImage popupBackground = null;
        try {
            Dimension size = this.heavyWeightContainer.getPreferredSize();
            if (size.width > 0 && size.height > 0) {
                Rectangle rect = new Rectangle(this.x, this.y, size.width, size.height);
                popupBackground = this.createScreenCapture(rect);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return popupBackground;
    }

    private BufferedImage createScreenCapture(Rectangle rect) throws AWTException {
        return new Robot().createScreenCapture(rect);
    }

    private static class WindowFader
    extends Timer {
        private static ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WindowFader fader = (WindowFader)evt.getSource();
                float alpha = (float)fader.counter / fader.repeats;
                WindowFader.setWindowOpacity(fader.window, fader.fadein ? alpha : 1.0f - alpha);
                if ((float)fader.counter == fader.repeats) {
                    fader.counter = 0;
                    fader.stop();
                    if (fader.hidePopup) {
                        if (fader.popup != null) {
                            fader.popup.hide();
                        }
                        WindowFader.setWindowOpacity(fader.window, 1.0f);
                    }
                    fader.popup = null;
                    fader.window = null;
                } else {
                    WindowFader windowFader = fader;
                    windowFader.counter = windowFader.counter + 1;
                }
            }
        };
        private Window window;
        private javax.swing.Popup popup;
        private boolean fadein;
        private boolean hidePopup;
        private float repeats;
        private int counter;

        public WindowFader(Window w, javax.swing.Popup delegate, int delay, int duration, boolean fadein, boolean hidePopup) {
            super(0, listener);
            this.window = w;
            this.popup = delegate;
            this.setDelay(delay);
            this.repeats = duration / delay;
            this.fadein = fadein;
            this.hidePopup = hidePopup;
            WindowFader.setWindowOpacity(w, fadein ? 0.01f : 1.0f);
        }

        private static void setWindowOpacity(Window w, float alpha) {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
                w.setOpacity(alpha);
            }
        }
    }
}

