/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.ExtKeyEventProcessor;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.TabbedPanePainter;
import de.javasoft.plaf.synthetica.util.DropShadow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;

public class GraphicsUtils
extends SynthGraphicsUtils {
    @Override
    public void paintText(SynthContext sc, Graphics g, String text, int x, int y, int mnemonicIndex) {
        Insets sInsets;
        String imagePath;
        JComponent c = sc.getComponent();
        Region region = sc.getRegion();
        if (region == Region.BUTTON || region == Region.TOGGLE_BUTTON) {
            if (!SyntheticaLookAndFeel.getBoolean("Button.showMnemonics", c, this.getPaintButtonMnemonics())) {
                mnemonicIndex = -1;
            }
            if ((imagePath = (String)SyntheticaLookAndFeel.get("Synthetica.button.textBackground", c)) != null && imagePath.length() > 0 && text != null && text.trim().length() > 0) {
                Insets dInsets = sInsets = (Insets)SyntheticaLookAndFeel.get("Synthetica.button.textBackground.insets", c);
                FontMetrics fm = g.getFontMetrics();
                int h = fm.getHeight();
                int w = fm.stringWidth(text);
                ImagePainter imagePainter = new ImagePainter(g, x - 2, y, w + 4, h, imagePath, sInsets, dInsets, 0, 0);
                imagePainter.draw();
            }
        } else if (region == Region.TABBED_PANE_TAB) {
            TabbedPanePainter p;
            Object painter;
            Color textColor;
            JTabbedPane tp = (JTabbedPane)c;
            int selectedIndex = tp.getSelectedIndex();
            int index = SyntheticaLookAndFeel.getClientProperty("Synthetica.tabbedPane.tabIndex", tp, -1);
            Color color = textColor = index >= 0 ? tp.getForegroundAt(index) : null;
            if (textColor != null && !(textColor instanceof UIResource)) {
                g.setColor(textColor);
            }
            if (selectedIndex != index && SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.bold", tp)) {
                int wBold = g.getFontMetrics().stringWidth(text);
                g.setFont(g.getFont().deriveFont(0));
                int wPlain = g.getFontMetrics().stringWidth(text);
                x += (wBold - wPlain) / 2;
            }
            if ((painter = SyntheticaLookAndFeel.get("Synthetica.TabbedPanePainter", c)) instanceof TabbedPanePainter && !(p = (TabbedPanePainter)painter).paintTabbedPaneTabText(sc, g, text, x, y, mnemonicIndex)) {
                return;
            }
        } else if (region == Region.PROGRESS_BAR) {
            Color fillColor;
            imagePath = (String)SyntheticaLookAndFeel.get("Synthetica.progressBar.textBackground", c);
            if (imagePath != null && imagePath.length() > 0 && text != null && text.trim().length() > 0) {
                Insets dInsets = sInsets = (Insets)SyntheticaLookAndFeel.get("Synthetica.progressBar.textBackground.insets", c);
                FontMetrics fm = g.getFontMetrics();
                int h = fm.getHeight();
                int w = fm.stringWidth(text);
                ImagePainter imagePainter = new ImagePainter(g, x - 2, y, w + 4, h, imagePath, sInsets, dInsets, 0, 0);
                imagePainter.draw();
            }
            if ((fillColor = SyntheticaLookAndFeel.getColor("Synthetica.progressBar.textFillColor", c)) != null) {
                this.paintProgressFillText(sc, g, text, fillColor, x, y, mnemonicIndex);
                return;
            }
        } else if (region == Region.INTERNAL_FRAME_TITLE_PANE) {
            if (mnemonicIndex == -1) {
                return;
            }
        } else if (!(region != Region.MENU && region != Region.MENU_ITEM && region != Region.CHECK_BOX_MENU_ITEM && region != Region.RADIO_BUTTON_MENU_ITEM || this.getPaintMenuMnemonics())) {
            mnemonicIndex = -1;
        } else if (region == Region.MENU_ITEM_ACCELERATOR && UIManager.get("MenuItem.acceleratorDelimiter") != null) {
            text = text.replace("+", UIManager.getString("MenuItem.acceleratorDelimiter"));
        }
        if (SyntheticaLookAndFeel.getAntiAliasEnabled() || SyntheticaLookAndFeel.getBoolean("Synthetica.text.antialias", c)) {
            Graphics2D g2 = (Graphics2D)g;
            Object oldAA = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            super.paintText(sc, g2, text, x, y, mnemonicIndex);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAA);
        } else {
            super.paintText(sc, g, text, x, y, mnemonicIndex);
        }
    }

    @Override
    public void paintText(SynthContext sc, Graphics g, String text, Icon icon, int align, int align2, int textPosition, int textPosition2, int iconTextGap, int mnemonicIndex, int textOffset) {
        if (SyntheticaLookAndFeel.getAntiAliasEnabled() || SyntheticaLookAndFeel.getBoolean("Synthetica.text.antialias", sc.getComponent())) {
            Graphics2D g2 = (Graphics2D)g;
            Object oldAA = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            super.paintText(sc, g2, text, icon, align, align2, textPosition, textPosition2, iconTextGap, mnemonicIndex, textOffset);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAA);
        } else {
            super.paintText(sc, g, text, icon, align, align2, textPosition, textPosition2, iconTextGap, mnemonicIndex, textOffset);
        }
    }

    private void paintProgressFillText(SynthContext sc, Graphics g, String text, Color fillColor, int x, int y, int mnemonicIndex) {
        JProgressBar progressBar = (JProgressBar)sc.getComponent();
        int fillStart = SyntheticaLookAndFeel.getClientProperty("Synthetica.progressBar.textFillStart", progressBar, 0);
        int fillAmount = SyntheticaLookAndFeel.getClientProperty("Synthetica.progressBar.textFillAmount", progressBar, 0);
        Rectangle orgClip = g.getClipBounds();
        FontMetrics fm = g.getFontMetrics();
        int h = fm.getHeight();
        int w = fm.stringWidth(text);
        if (progressBar.getOrientation() == 0) {
            super.paintText(sc, g, text, x, y, mnemonicIndex);
            g.setColor(fillColor);
            g.clipRect(fillStart, y, fillAmount, h);
            super.paintText(sc, g, text, x, y, mnemonicIndex);
        } else {
            super.paintText(sc, g, text, x, y, mnemonicIndex);
            g.setColor(fillColor);
            g.clipRect(x, fillStart, w, fillAmount);
            super.paintText(sc, g, text, x, y, mnemonicIndex);
        }
        g.setClip(orgClip);
    }

    protected boolean getPaintMnemonics() {
        return this.getPaintMenuMnemonics();
    }

    protected boolean getPaintMenuMnemonics() {
        if (ExtKeyEventProcessor.showMnemonicsOnAltKeyOnly()) {
            return ExtKeyEventProcessor.isMenuActive();
        }
        return true;
    }

    protected boolean getPaintButtonMnemonics() {
        if (ExtKeyEventProcessor.showMnemonicsOnAltKeyOnly()) {
            return ExtKeyEventProcessor.isAltKeyPressed();
        }
        return true;
    }

    @Override
    public void drawLine(SynthContext sc, Object paintKey, Graphics g, int x1, int y1, int x2, int y2) {
        JComponent c = sc.getComponent();
        if (paintKey instanceof String && ((String)paintKey).startsWith("Tree.")) {
            String lineType;
            Color color = null;
            if (paintKey.equals("Tree.horizontalLine")) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.tree.line.color.horizontal", c);
            } else if (paintKey.equals("Tree.verticalLine")) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.tree.line.color.vertical", c);
            }
            if (color != null) {
                g.setColor(color);
            }
            if ("SOLID".equals(lineType = SyntheticaLookAndFeel.getString("Synthetica.tree.line.type", c))) {
                g.drawLine(x1, y1, x2, y2);
            } else if ("DASHED".equals(lineType)) {
                int dashedSpace;
                int dashedLine = SyntheticaLookAndFeel.getInt("Synthetica.tree.line.dashed.line", (Component)c, true);
                if (dashedLine <= 0) {
                    dashedLine = 2;
                }
                if ((dashedSpace = SyntheticaLookAndFeel.getInt("Synthetica.tree.line.dashed.space", (Component)c, true)) <= 0) {
                    dashedSpace = 1;
                }
                if (paintKey.equals("Tree.horizontalLine")) {
                    int x = x1;
                    while (x < x2) {
                        g.drawLine(x, y1, Math.min(x + dashedLine - 1, x2), y2);
                        x += dashedLine + dashedSpace;
                    }
                } else {
                    int y = y1;
                    while (y < y2) {
                        g.drawLine(x1, y, x1, Math.min(y + dashedLine - 1, y2));
                        y += dashedLine + dashedSpace;
                    }
                }
            }
            return;
        }
        if (x1 == x2 && paintKey instanceof String && ((String)paintKey).equals("Table.grid")) {
            int lineWidth = SyntheticaLookAndFeel.getInt("Synthetica.table.columnMargin", sc.getComponent(), 1, true);
            if (lineWidth != 0) {
                g.fillRect(x1, y1, lineWidth, y2 - y1);
            }
            return;
        }
        if (y1 == y2 && paintKey instanceof String && ((String)paintKey).equals("Table.grid")) {
            int lineHeight = SyntheticaLookAndFeel.getInt("Synthetica.table.rowMargin", sc.getComponent(), 1, true);
            if (lineHeight != 0) {
                g.fillRect(x1, y1, x2 - x1, lineHeight);
            }
            return;
        }
        super.drawLine(sc, paintKey, g, x1, y1, x2, y2);
    }

    @Override
    public String layoutText(SynthContext sc, FontMetrics fm, String text, Icon icon, int hAlign, int vAlign, int hTextPosition, int vTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int iconTextGap) {
        JComponent c = sc.getComponent();
        if (c instanceof JTabbedPane) {
            SynthStyle ss;
            hTextPosition = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.text.position.leading", c) ? 10 : 11;
            SynthStyleFactory ssf = SynthLookAndFeel.getStyleFactory();
            if (ssf != null && (ss = ssf.getStyle(sc.getComponent(), Region.TABBED_PANE)).get(sc, "TabbedPane.textIconGap") == null) {
                iconTextGap = 4;
            }
        }
        String s = super.layoutText(sc, fm, text, icon, hAlign, vAlign, hTextPosition, vTextPosition, viewR, iconR, textR, iconTextGap);
        if (c instanceof JTabbedPane && ((JTabbedPane)c).getTabCount() > 0) {
            this.tabbedPaneTabCorrection(sc, (JTabbedPane)c, fm, text, icon, viewR, textR, iconR);
        }
        return s;
    }

    private void tabbedPaneTabCorrection(SynthContext sc, JTabbedPane tp, FontMetrics fm, String text, Icon icon, Rectangle viewR, Rectangle textR, Rectangle iconR) {
        int index;
        int selectedIndex = tp.getSelectedIndex();
        boolean selected = selectedIndex == (index = SyntheticaLookAndFeel.getClientProperty("Synthetica.tabbedPane.tabIndex", tp, -1).intValue());
        int placement = tp.getTabPlacement();
        if (index >= 0 && tp.getIconAt(index) != null) {
            int fHeight = fm.getHeight();
            int height = Math.max(fHeight, tp.getIconAt(index).getIconHeight());
            textR.y += (fHeight - height) / 2;
        }
        String propertyKey = "tabbedPane.tab";
        if (selected) {
            propertyKey = String.valueOf(propertyKey) + ".selected";
        }
        if (placement == 1) {
            propertyKey = String.valueOf(propertyKey) + ".top";
        } else if (placement == 2) {
            propertyKey = String.valueOf(propertyKey) + ".left";
        } else if (placement == 3) {
            propertyKey = String.valueOf(propertyKey) + ".bottom";
        } else if (placement == 4) {
            propertyKey = String.valueOf(propertyKey) + ".right";
        }
        String name = SyntheticaLookAndFeel.getStyleName(tp);
        Insets insets = SyntheticaLookAndFeel.getInsets(propertyKey, "text.insets", name, true);
        if (insets != null) {
            textR.x += insets.left;
            switch (tp.getTabPlacement()) {
                case 1: {
                    textR.y += insets.top;
                    break;
                }
                case 3: {
                    textR.y -= insets.bottom;
                }
            }
        }
        if (icon != null) {
            insets = SyntheticaLookAndFeel.getInsets(propertyKey, "icon.insets", name, true);
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            iconR.x += insets.left;
            if (tp.getTabPlacement() == 1) {
                iconR.y += insets.top;
            } else if (tp.getTabPlacement() == 3) {
                iconR.y -= insets.bottom;
            }
        }
    }

    public static Image iconToImage(SynthContext sc, Icon icon) {
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = image.getGraphics();
        JComponent c = sc == null ? null : sc.getComponent();
        icon.paintIcon(c, g, 0, 0);
        g.dispose();
        return image;
    }

    public void paintListCellRendererSelectionBackground(JList<?> list, Component renderer, Graphics g, int x, int y, int w, int h) {
        boolean focused = this.cellRendererRespectsFocus(renderer) ? list.hasFocus() : true;
        String imagePath = SyntheticaLookAndFeel.getString(focused ? "Synthetica.list.selectionBackground" : "Synthetica.list.selectionBackground.inactive", renderer);
        if (imagePath != null) {
            Insets sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.list.selectionBackground.insets", renderer, false, false);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, sInsets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintTreeCellRendererSelectionBackground(JTree tree, Component renderer, Graphics g, int x, int y, int w, int h) {
        String imagePath;
        boolean focused = true;
        if (this.cellRendererRespectsFocus(renderer)) {
            focused = tree.getParent() instanceof CellRendererPane ? tree.getParent().getParent().hasFocus() : tree.hasFocus();
        }
        if ((imagePath = SyntheticaLookAndFeel.getString(focused ? "Synthetica.tree.selectionBackground" : "Synthetica.tree.selectionBackground.inactive", renderer)) != null) {
            Insets sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.tree.selectionBackground.insets", renderer, false, false);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, sInsets, 0, 0);
            imagePainter.draw();
        }
    }

    public void paintTableCellRendererSelectionBackground(JTable table, Component renderer, Graphics g, int x, int y, int w, int h) {
        String imagePath;
        boolean focused;
        boolean bl = focused = this.cellRendererRespectsFocus(renderer) ? table.hasFocus() : true;
        if (table.getCellEditor() != null) {
            focused = true;
        }
        if ((imagePath = SyntheticaLookAndFeel.getString(focused ? "Synthetica.table.selectionBackground" : "Synthetica.table.selectionBackground.inactive", renderer)) != null) {
            Insets sInsets = SyntheticaLookAndFeel.getInsets("Synthetica.table.selectionBackground.insets", renderer, false, false);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, sInsets, 0, 0);
            imagePainter.draw();
        }
    }

    private boolean cellRendererRespectsFocus(Component renderer) {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.cellRenderer.respectFocus", renderer, false);
    }

    protected void paintTextShadow(JComponent c, Graphics g, int x, int y, String text, boolean highQuality, int size, int distance, float opacity, Color color, int xOffset, int yOffset, boolean useGraphicsFont, int mnemonicIndex) {
        if (text == null || text.length() == 0) {
            return;
        }
        Font f = useGraphicsFont ? g.getFont() : c.getFont();
        FontMetrics fm = g.getFontMetrics(f);
        int tw = fm.stringWidth(text);
        int th = fm.getHeight() + size * 2;
        BufferedImage image = this.createCompatibleImage(tw, th);
        Graphics2D g2 = image.createGraphics();
        g2.setFont(f);
        ((Graphics)g2).drawString(text, 0, fm.getAscent());
        if (this.getPaintMenuMnemonics() && mnemonicIndex >= 0 && mnemonicIndex < text.length()) {
            int underlineX = fm.stringWidth(text.substring(0, mnemonicIndex));
            int underlineY = fm.getHeight() - 1;
            int underlineWidth = fm.charWidth(text.charAt(mnemonicIndex));
            g2.fillRect(underlineX, underlineY, underlineWidth, 1);
        }
        g2.dispose();
        DropShadow ds = new DropShadow(image);
        ds.setQuality(highQuality);
        ds.setShadowSize(size);
        ds.setDistance(distance);
        ds.setShadowOpacity(opacity);
        ds.setShadowColor(color);
        ds.paintShadow(g, x + xOffset, y + yOffset);
    }

    private BufferedImage createCompatibleImage(int w, int h) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration c = e.getDefaultScreenDevice().getDefaultConfiguration();
        return c.createCompatibleImage(w, h, 3);
    }
}

