/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import de.javasoft.plaf.synthetica.SyntheticaTitlePane;
import de.javasoft.plaf.synthetica.util.OS;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyEventPostProcessor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.FocusManager;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.basic.ComboPopup;

class ExtKeyEventProcessor
implements KeyEventPostProcessor {
    private static boolean altKeyPressed = false;
    private static boolean menuActivated = false;
    private static boolean winKeyArmed = false;

    ExtKeyEventProcessor() {
    }

    @Override
    public boolean postProcessKeyEvent(KeyEvent evt) {
        boolean altGr;
        if (evt.isConsumed()) {
            return false;
        }
        this.winMetaKeySupport(evt);
        if (!ExtKeyEventProcessor.activateMenuByAltKey()) {
            return false;
        }
        int mod = evt.getModifiersEx();
        boolean ctrl = (mod & 0x80) == 128;
        boolean bl = altGr = (mod & 0x2000) == 8192;
        if (evt.getKeyCode() == 18 && !ctrl && !altGr) {
            JMenuBar mbar;
            Component c = evt.getComponent();
            Window w = SwingUtilities.getWindowAncestor(c);
            JRootPane root = SwingUtilities.getRootPane(c);
            JMenuBar jMenuBar = mbar = root != null ? root.getJMenuBar() : null;
            if (mbar == null && w instanceof JFrame) {
                mbar = ((JFrame)w).getJMenuBar();
            }
            if (evt.getID() == 401) {
                if (!altKeyPressed) {
                    this.altPressed(evt, c, root, mbar);
                }
                altKeyPressed = true;
                return true;
            }
            if (evt.getID() == 402) {
                if (altKeyPressed) {
                    this.altReleased(evt, c, root, mbar);
                }
                altKeyPressed = false;
            }
        } else {
            altKeyPressed = false;
        }
        return false;
    }

    static void resetWinMetaKey() {
        winKeyArmed = false;
    }

    private void winMetaKeySupport(KeyEvent evt) {
        RootPaneUI ui;
        JFrame frame;
        int keyCode = evt.getKeyCode();
        boolean metaKeyArmed = evt.isMetaDown();
        boolean ctrlKeyArmed = evt.isControlDown();
        Window win = FocusManager.getCurrentManager().getActiveWindow();
        JFrame jFrame = frame = win instanceof JFrame ? (JFrame)win : null;
        if (keyCode == 70 && metaKeyArmed && ctrlKeyArmed && evt.getID() == 401 && frame != null && frame.isResizable() && SyntheticaTitlePane.isFullScreenOnMacSupported(frame) && (ui = frame.getRootPane().getUI()) instanceof SyntheticaRootPaneUI && ((SyntheticaRootPaneUI)ui).getTitlePane() instanceof SyntheticaTitlePane) {
            SyntheticaTitlePane tp = (SyntheticaTitlePane)((SyntheticaRootPaneUI)ui).getTitlePane();
            if (this.isMaximized(win)) {
                tp.restore();
            } else {
                tp.maximize();
            }
        }
        if (keyCode == 524 && evt.getID() == 401) {
            winKeyArmed = true;
        } else if (!winKeyArmed || keyCode != 38) {
            if (metaKeyArmed && keyCode == 38 && !this.isMaximized(win) && frame != null) {
                ui = frame.getRootPane().getUI();
                if (ui instanceof SyntheticaRootPaneUI && ((SyntheticaRootPaneUI)ui).isSnapEnabled(win) && ((SyntheticaRootPaneUI)ui).getTitlePane() instanceof SyntheticaTitlePane) {
                    ((SyntheticaTitlePane)((SyntheticaRootPaneUI)ui).getTitlePane()).maximize();
                }
            } else if ((winKeyArmed || metaKeyArmed) && keyCode == 40 && this.isMaximized(win) && frame != null) {
                ui = frame.getRootPane().getUI();
                if (ui instanceof SyntheticaRootPaneUI) {
                    SyntheticaRootPaneUI sui = (SyntheticaRootPaneUI)ui;
                    if (this.isMaximized(win) && sui.getTitlePane() instanceof SyntheticaTitlePane) {
                        ((SyntheticaTitlePane)sui.getTitlePane()).restore();
                        sui.restoreSnappedWindow(win, win.getGraphicsConfiguration(), true);
                    }
                }
            } else if (!winKeyArmed || keyCode != 40) {
                if (metaKeyArmed && keyCode == 40 && !this.isMaximized(win) && frame != null) {
                    ui = frame.getRootPane().getUI();
                    if (ui instanceof SyntheticaRootPaneUI && ((SyntheticaRootPaneUI)ui).isSnapEnabled(win) && ((SyntheticaRootPaneUI)ui).getTitlePane() instanceof SyntheticaTitlePane) {
                        ((SyntheticaTitlePane)((SyntheticaRootPaneUI)ui).getTitlePane()).iconify();
                    }
                } else if ((winKeyArmed || metaKeyArmed) && (keyCode == 37 || keyCode == 39) && frame != null) {
                    ui = frame.getRootPane().getUI();
                    if (ui instanceof SyntheticaRootPaneUI && ((SyntheticaRootPaneUI)ui).isSnapEnabled(win)) {
                        if (keyCode == 37) {
                            ((SyntheticaRootPaneUI)ui).snapPrev(win);
                        } else {
                            ((SyntheticaRootPaneUI)ui).snapNext(win);
                        }
                    }
                } else {
                    winKeyArmed = false;
                }
            }
        }
    }

    private boolean isMaximized(Window win) {
        return win instanceof Frame && (((Frame)win).getExtendedState() & 6) == 6;
    }

    private void altPressed(KeyEvent evt, Component c, JRootPane root, JMenuBar mb) {
        if (UIManager.get("Button.showMnemonics") == null && !(c instanceof JMenuBar) && root != null) {
            root.repaint();
        }
        this.altPressed(evt, mb);
    }

    private void altPressed(KeyEvent evt, JMenuBar mb) {
        boolean consumeAnyway = UIManager.getBoolean("Synthetica.forcedAltKeyEventConsumption");
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] path = msm.getSelectedPath();
        if (path.length > 0) {
            if (!(path[0] instanceof ComboPopup)) {
                msm.clearSelectedPath();
            }
            menuActivated = false;
            if (!consumeAnyway) {
                evt.consume();
            }
        } else {
            if (mb != null) {
                menuActivated = true;
            }
            if (mb != null && mb.getMenu(0) != null && !consumeAnyway) {
                evt.consume();
            }
        }
        if (consumeAnyway) {
            evt.consume();
        }
        if (mb != null && menuActivated) {
            mb.repaint();
        }
    }

    public static void setMenuActive(boolean active) {
        menuActivated = active;
    }

    public static boolean isMenuActive() {
        return menuActivated;
    }

    public static boolean isAltKeyPressed() {
        return altKeyPressed;
    }

    public static boolean showMnemonicsOnAltKeyOnly() {
        if (OS.getCurrentOS() == OS.Windows && SyntheticaLookAndFeel.getBoolean("Synthetica.showMnemonicsOnAltKeyOnly", null, true)) {
            return true;
        }
        return SyntheticaLookAndFeel.getBoolean("Synthetica.forceShowMnemonicsOnAltKeyOnly", null);
    }

    public static boolean activateMenuByAltKey() {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.activateMenuByAltKey", null, true);
    }

    private void altReleased(KeyEvent evt, Component c, JRootPane root, JMenuBar mb) {
        if (UIManager.get("Button.showMnemonics") == null && !(c instanceof JMenuBar) && root != null) {
            root.repaint();
        }
        this.altReleased(evt, mb);
    }

    private void altReleased(KeyEvent evt, JMenuBar mb) {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        if (msm.getSelectedPath().length == 0 && menuActivated) {
            JMenu menu;
            JMenu jMenu = menu = mb != null ? mb.getMenu(0) : null;
            if (menu != null) {
                MenuElement[] path = new MenuElement[]{mb, menu};
                msm.setSelectedPath(path);
            }
        }
    }
}

