/*
 * Decompiled with CFR 0.152.
 */
package quickfix.codegen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import quickfix.codegen.CodeGenerationException;

public class JavaCodeGenerator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private String outputBaseDir;
    private String specificationDir;
    private String xformDir;
    private static final long SERIAL_UID = 20050617L;
    private static final String SERIAL_UID_STR = String.valueOf(20050617L);
    private static final String XSLPARAM_SERIAL_UID = "serialVersionUID";

    public JavaCodeGenerator(String string, String string2, String string3) {
        this.specificationDir = string;
        this.xformDir = string2;
        this.outputBaseDir = string3;
    }

    private void generateMessageBaseClasses() throws TransformerConfigurationException, FileNotFoundException, ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        this.log.info("Generating message base classes.");
        this.generateClassCodeForVersions("Message", new String[]{XSLPARAM_SERIAL_UID}, new String[]{SERIAL_UID_STR});
    }

    private void generateMessageFactoryClasses() throws TransformerConfigurationException, FileNotFoundException, ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        this.log.info("Generating message factories.");
    }

    private void generateMessageCrackerClasses() throws TransformerConfigurationException, FileNotFoundException, ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        this.log.info("Generating message crackers.");
    }

    private void generateClassCodeForVersions(String string, String[] stringArray, String[] stringArray2) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerConfigurationException, FileNotFoundException, TransformerException {
        for (int i = 2; i < 3; ++i) {
            this.log.debug("generating " + string + " for FIX 4." + i);
            Document document = this.getSpecification(i);
            this.generateCodeFile(document, this.xformDir + "/" + string + ".xsl", stringArray, stringArray2, this.outputBaseDir + "/quickfix/fix4" + i + "/" + string + ".java");
        }
    }

    private Document getSpecification(int n) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        File file = new File(this.specificationDir + "/FIX4" + n + ".xml");
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return document;
    }

    private void generateFieldClasses() throws ParserConfigurationException, SAXException, IOException {
        this.log.info("Generating field classes.");
        for (int i = 2; i >= 2; --i) {
            String string = this.outputBaseDir + "/quickfix/field/";
            this.writePackageDocumentation(string, "FIX field definitions (all FIX versions).");
            Document document = this.getSpecification(i);
            List list = this.getNames(document.getDocumentElement(), "fields/field");
            try {
                for (int j = 0; j < list.size(); ++j) {
                    String string2 = (String)list.get(j);
                    String string3 = string + string2 + ".java";
                    if (new File(string3).exists()) continue;
                    this.log.debug("field: " + string2);
                    this.generateCodeFile(document, this.xformDir + "/Fields.xsl", new String[]{"fieldName", XSLPARAM_SERIAL_UID}, new String[]{string2, SERIAL_UID_STR}, string3);
                }
                continue;
            }
            catch (Exception exception) {
                this.log.error("error while generating field classes", (Throwable)exception);
            }
        }
    }

    private void writePackageDocumentation(String string, String string2) throws FileNotFoundException {
        File file = new File(string + "package.html");
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        printStream.println("<html>");
        printStream.println("<head><title/></head>");
        printStream.println("<body>" + string2 + "</body>");
        printStream.println("</html>");
        printStream.close();
    }

    private void generateMessageSubclasses() throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, FileNotFoundException, TransformerFactoryConfigurationError, TransformerException {
        this.log.info("Generating message subclasses.");
        for (int i = 2; i < 3; ++i) {
            String string = this.outputBaseDir + "/quickfix/fix4" + i + "/";
            this.writePackageDocumentation(string, "Message classes for FIX 4." + i);
            Document document = this.getSpecification(i);
            List list = this.getNames(document.getDocumentElement(), "messages/message");
            for (int j = 0; j < list.size(); ++j) {
                String string2 = (String)list.get(j);
                this.log.debug("message (FIX 4." + i + "): " + string2);
                this.generateCodeFile(document, this.xformDir + "/MessageSubclass.xsl", new String[]{"itemName", XSLPARAM_SERIAL_UID}, new String[]{string2, SERIAL_UID_STR}, string + string2 + ".java");
            }
        }
    }

    private void generateComponentClasses() throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, FileNotFoundException, TransformerFactoryConfigurationError, TransformerException {
        this.log.info("Generating component classes.");
        for (int i = 2; i < 3; ++i) {
            String string = this.outputBaseDir + "/quickfix/fix4" + i + "/component/";
            Document document = this.getSpecification(i);
            List list = this.getNames(document.getDocumentElement(), "components/component");
            if (list.size() > 0) {
                this.writePackageDocumentation(string, "Message component classes for FIX 4." + i);
            }
            for (int j = 0; j < list.size(); ++j) {
                String string2 = (String)list.get(j);
                this.log.debug("component (FIX 4." + i + "): " + string2);
                this.generateCodeFile(document, this.xformDir + "/MessageSubclass.xsl", new String[]{"itemName", XSLPARAM_SERIAL_UID, "baseClass", "subpackage"}, new String[]{string2, SERIAL_UID_STR, "quickfix.MessageComponent", ".component"}, string + string2 + ".java");
            }
        }
    }

    private List getNames(Element element, String string) {
        return this.getNames(element, string, new ArrayList());
    }

    private List getNames(Element element, String string, List list) {
        int n = string.indexOf("/");
        if (n == -1) {
            NodeList nodeList = element.getElementsByTagName(string);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                list.add(((Element)nodeList.item(i)).getAttribute("name"));
            }
        } else {
            String string2 = string.substring(0, n);
            NodeList nodeList = element.getElementsByTagName(string2);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.getNames((Element)nodeList.item(i), string.substring(n + 1), list);
            }
        }
        return list;
    }

    private void generateCodeFile(Document document, String string, String[] stringArray, String[] stringArray2, String string2) throws TransformerFactoryConfigurationError, TransformerConfigurationException, FileNotFoundException, TransformerException {
        File file;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamSource streamSource = new StreamSource(string);
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                transformer.setParameter(stringArray[i], stringArray2[i]);
            }
        }
        if (!(file = new File(string2)).getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(new FileOutputStream(string2));
        transformer.transform(dOMSource, streamResult);
    }

    public void generate() {
        try {
            this.generateFieldClasses();
            this.generateMessageBaseClasses();
            this.generateMessageFactoryClasses();
            this.generateMessageCrackerClasses();
            this.generateComponentClasses();
            this.generateMessageSubclasses();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CodeGenerationException(exception);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 3) {
                String string = JavaCodeGenerator.class.getName();
                System.err.println("usage: " + string + " specDir xformDir outputBaseDir");
                return;
            }
            JavaCodeGenerator javaCodeGenerator = new JavaCodeGenerator(stringArray[0], stringArray[1], stringArray[2]);
            javaCodeGenerator.generate();
        }
        catch (Exception exception) {
            LoggerFactory.getLogger(JavaCodeGenerator.class).error("error during code generation", (Throwable)exception);
            System.exit(1);
        }
    }
}

