/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.ByteArrayOutputStream;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import quickfix.DataDictionary;
import quickfix.Field;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.Group;
import quickfix.InvalidMessage;
import quickfix.StringField;
import quickfix.field.BodyLength;
import quickfix.field.CheckSum;

public class Message
extends FieldMap {
    static final long serialVersionUID = -3193357271891865972L;
    protected Header header = new Header();
    protected Trailer trailer = new Trailer();
    private boolean doValidation;
    private int isValidStructureTag = 0;
    private boolean isValidStructure = true;
    private static DecimalFormat checksumFormat = new DecimalFormat("000");
    private String messageData;
    private int position;
    private StringField pushedBackField;

    public Message() {
    }

    public Message(String string) throws InvalidMessage {
        this.fromString(string, null, true);
    }

    public Message(String string, boolean validate) throws InvalidMessage {
        this.fromString(string, null, validate);
    }

    public Message(String string, DataDictionary dd) throws InvalidMessage {
        this.fromString(string, dd, true);
    }

    public Message(String string, DataDictionary dd, boolean validate) throws InvalidMessage {
        this.fromString(string, dd, validate);
    }

    public static boolean InitializeXML(String url) {
        throw new UnsupportedOperationException();
    }

    public Object clone() {
        try {
            Message message = (Message)this.getClass().newInstance();
            return this.cloneTo(message);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Object cloneTo(Message message) {
        message.initializeFrom(this);
        message.header.initializeFrom(this.getHeader());
        message.trailer.initializeFrom(this.getTrailer());
        return message;
    }

    public String toString() {
        this.header.setField(new BodyLength(this.bodyLength()));
        this.trailer.setField(new CheckSum(this.checkSum()));
        StringBuffer sb = new StringBuffer();
        this.header.calculateString(sb, null, null);
        this.calculateString(sb, null, null);
        this.trailer.calculateString(sb, null, null);
        return sb.toString();
    }

    public int bodyLength() {
        return this.header.calculateLength() + this.calculateLength() + this.trailer.calculateLength();
    }

    private int checkSum(String s) {
        int offset = s.lastIndexOf("\u000110=");
        int sum = 0;
        for (int i = 0; i < offset; ++i) {
            sum += s.charAt(i);
        }
        return (sum + 1) % 256;
    }

    private String checkSum() {
        return checksumFormat.format((this.header.calculateTotal() + this.calculateTotal() + this.trailer.calculateTotal()) % 256);
    }

    public void headerAddGroup(Group group) {
        this.header.addGroup(group);
    }

    public void headerReplaceGroup(int num, Group group) {
        this.header.replaceGroup(num, group);
    }

    public Group headerGetGroup(int num, Group group) throws FieldNotFound {
        return this.header.getGroup(num, group);
    }

    public void headerRemoveGroup(Group group) {
        this.header.removeGroup(group);
    }

    public boolean headerHasGroup(int field) {
        return this.header.hasGroup(field);
    }

    public boolean headerHasGroup(int num, int field) {
        return this.header.hasGroup(num, field);
    }

    public boolean headerHasGroup(int num, Group group) {
        return this.headerHasGroup(num, group.getFieldTag());
    }

    public boolean headerHasGroup(Group group) {
        return this.headerHasGroup(group.getFieldTag());
    }

    public void trailerAddGroup(Group group) {
        this.trailer.addGroup(group);
    }

    public Group trailerGetGroup(int num, Group group) throws FieldNotFound {
        return this.trailer.getGroup(num, group);
    }

    public void trailerReplaceGroup(int num, Group group) {
        this.trailer.replaceGroup(num, group);
    }

    public void trailerRemoveGroup(Group group) {
        this.trailer.removeGroup(group);
    }

    public boolean trailerHasGroup(int field) {
        return this.trailer.hasGroup(field);
    }

    public boolean trailerHasGroup(int num, int field) {
        return this.trailer.hasGroup(num, field);
    }

    public boolean trailerHasGroup(int num, Group group) {
        return this.trailerHasGroup(num, group.field());
    }

    public boolean trailerHasGroup(Group group) {
        return this.trailerHasGroup(group.field());
    }

    public String toXML() {
        return this.toXML(null);
    }

    public String toXML(DataDictionary dataDictionary) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element message = document.createElement("message");
            document.appendChild(message);
            this.toXMLFields(message, "header", this.header, dataDictionary);
            this.toXMLFields(message, "body", this, dataDictionary);
            this.toXMLFields(message, "trailer", this.trailer, dataDictionary);
            DOMSource domSource = new DOMSource(document);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(out);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "ISO-8859-1");
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(domSource, streamResult);
            return out.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void toXMLFields(Element message, String section, FieldMap fieldMap, DataDictionary dataDictionary) throws FieldNotFound {
        Document document = message.getOwnerDocument();
        Element fields = document.createElement(section);
        message.appendChild(fields);
        Iterator fieldItr = fieldMap.iterator();
        while (fieldItr.hasNext()) {
            StringField field = (StringField)fieldItr.next();
            Element fieldElement = document.createElement("field");
            if (dataDictionary != null) {
                String enumValue;
                String name = dataDictionary.getFieldName(field.getTag());
                if (name != null) {
                    fieldElement.setAttribute("name", name);
                }
                if ((enumValue = dataDictionary.getValueName(field.getTag(), field.getValue())) != null) {
                    fieldElement.setAttribute("enum", enumValue);
                }
            }
            fieldElement.setAttribute("number", Integer.toString(field.getTag()));
            CDATASection value = document.createCDATASection(field.getValue());
            fieldElement.appendChild(value);
            fields.appendChild(fieldElement);
        }
        Iterator groupKeyItr = fieldMap.groupKeyIterator();
        while (groupKeyItr.hasNext()) {
            int groupKey = (Integer)groupKeyItr.next();
            List groups = fieldMap.getGroups(groupKey);
            for (Group group : groups) {
                this.toXMLFields(fields, "group", group, dataDictionary);
            }
        }
    }

    public final Header getHeader() {
        return this.header;
    }

    public final Trailer getTrailer() {
        return this.trailer;
    }

    public boolean isAdmin() {
        if (this.header.isSetField(35)) {
            try {
                String msgType = this.header.getString(35);
                return msgType.length() == 1 && "0A12345".indexOf(msgType.charAt(0)) != -1;
            }
            catch (FieldNotFound fieldNotFound) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isApp() {
        return !this.isAdmin();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.header.isEmpty() && this.trailer.isEmpty();
    }

    @Override
    public void clear() {
        super.clear();
        this.header.clear();
        this.trailer.clear();
    }

    public void reverseRoute(Header header) throws FieldNotFound {
        this.header.removeField(8);
        this.header.removeField(49);
        this.header.removeField(56);
        if (header.isSetField(8)) {
            String beginString = header.getString(8);
            if (beginString.length() > 0) {
                this.header.setString(8, beginString);
            }
            this.header.removeField(144);
            this.header.removeField(145);
            if (beginString.compareTo("FIX.4.1") >= 0) {
                this.copyField(header, 144, 145);
                this.copyField(header, 145, 144);
            }
            this.copyField(header, 49, 56);
            this.copyField(header, 56, 49);
            this.header.removeField(115);
            this.header.removeField(116);
            this.header.removeField(128);
            this.header.removeField(129);
            this.copyField(header, 115, 128);
            this.copyField(header, 116, 129);
            this.copyField(header, 128, 115);
            this.copyField(header, 129, 116);
        }
    }

    private void copyField(Header header, int fromField, int toField) throws FieldNotFound {
        String value;
        if (header.isSetField(fromField) && (value = header.getString(fromField)).length() > 0) {
            this.header.setString(toField, value);
        }
    }

    public void fromString(String messageData, DataDictionary dd, boolean doValidation) throws InvalidMessage {
        this.messageData = messageData;
        this.doValidation = doValidation;
        try {
            this.parseHeader(dd);
            this.parseBody(dd);
            this.parseTrailer(dd);
        }
        catch (InvalidMessage e) {
            this.isValidStructure = false;
            throw e;
        }
        if (doValidation) {
            this.validate(messageData);
        }
    }

    private void validate(String messageData) throws InvalidMessage {
        try {
            int checkSum = this.trailer.getInt(10);
            if (checkSum != this.checkSum(messageData)) {
                throw new InvalidMessage("Expected CheckSum=" + this.checkSum(messageData) + ", Received CheckSum=" + checkSum);
            }
        }
        catch (FieldNotFound e) {
            throw new InvalidMessage("Field not found: " + e.field);
        }
        catch (InvalidMessage e) {
            throw e;
        }
    }

    private void parseHeader(DataDictionary dd) throws InvalidMessage {
        StringField msgType;
        StringField bodyLength;
        boolean invalidHeaderFieldOrder = false;
        StringField beginString = this.extractField(dd, this.header);
        if (beginString == null || beginString.getField() != 8) {
            invalidHeaderFieldOrder = true;
        }
        if (beginString != null) {
            this.header.setField(beginString);
        }
        if ((bodyLength = this.extractField(dd, this.header)) == null || bodyLength.getField() != 9) {
            invalidHeaderFieldOrder = true;
        }
        if (bodyLength != null) {
            this.header.setField(bodyLength);
        }
        if ((msgType = this.extractField(dd, this.header)) == null || msgType.getField() != 35) {
            invalidHeaderFieldOrder = true;
        }
        if (msgType != null) {
            this.header.setField(msgType);
        }
        if (this.doValidation && invalidHeaderFieldOrder) {
            throw new InvalidMessage("Header fields out of order");
        }
        StringField field = this.extractField(dd, this.header);
        while (field != null && Message.isHeaderField(field, dd)) {
            this.header.setField(field);
            field = this.extractField(dd, this.header);
        }
        this.pushBack(field);
    }

    private String getMsgType() throws InvalidMessage {
        String res = null;
        try {
            res = this.header.getString(35);
        }
        catch (FieldNotFound e) {
            throw new InvalidMessage(e.getMessage());
        }
        return res;
    }

    private void parseBody(DataDictionary dd) throws InvalidMessage {
        StringField field = this.extractField(dd, this);
        while (field != null) {
            if (Message.isTrailerField(field.getField())) {
                this.pushBack(field);
                return;
            }
            if (Message.isHeaderField(field.getField())) {
                if (this.isValidStructure) {
                    this.isValidStructureTag = field.getField();
                    this.isValidStructure = false;
                }
                this.header.setField(field);
            } else {
                this.setField(field);
            }
            if (dd != null && dd.isGroup(this.getMsgType(), field.getField())) {
                this.parseGroup(field, dd, this);
            }
            field = this.extractField(dd, this);
        }
    }

    private void parseGroup(StringField field, DataDictionary dd, FieldMap parent) throws InvalidMessage {
        DataDictionary.GroupInfo rg = dd.getGroup(this.getMsgType(), field.getField());
        int groupCountTag = field.getField();
        int declaredGroupCount = Integer.parseInt(field.getValue());
        parent.setField(groupCountTag, field);
        int firstField = rg.getDelimeterField();
        boolean firstFieldFound = false;
        Group group = null;
        boolean inGroupParse = true;
        while (inGroupParse) {
            field = this.extractField(group, dd, parent);
            if (field.getTag() == firstField) {
                if (group != null) {
                    parent.addGroup(group);
                }
                group = new Group(groupCountTag, firstField, rg.getDataDictionary().getOrderedFields());
                group.setField(field);
                firstFieldFound = true;
                continue;
            }
            if (rg.getDataDictionary().isGroup(this.getMsgType(), field.getField())) {
                if (firstFieldFound) {
                    this.parseGroup(field, rg.getDataDictionary(), group);
                    continue;
                }
                throw new InvalidMessage("The group " + groupCountTag + " must set the delimiter field " + firstField);
            }
            if (rg.getDataDictionary().isField(field.getTag())) {
                if (!firstFieldFound) {
                    throw new InvalidMessage("Repeating group " + groupCountTag + " is out of order: first field should be " + firstField + ", but was " + field.getField() + ".");
                }
                group.setField(field);
                continue;
            }
            if (group != null) {
                parent.addGroup(group);
            }
            this.pushBack(field);
            inGroupParse = false;
        }
        parent.setGroupCount(groupCountTag, declaredGroupCount);
    }

    private void parseTrailer(DataDictionary dd) throws InvalidMessage {
        StringField field = this.extractField(dd, this.trailer);
        while (field != null && Message.isTrailerField(field, dd)) {
            this.trailer.setField(field);
            field = this.extractField(dd, this.trailer);
        }
    }

    static boolean isHeaderField(Field field, DataDictionary dd) {
        return Message.isHeaderField(field.getField()) || dd != null && dd.isHeaderField(field.getField());
    }

    static boolean isHeaderField(int field) {
        switch (field) {
            case 8: 
            case 9: 
            case 34: 
            case 35: 
            case 43: 
            case 49: 
            case 50: 
            case 52: 
            case 56: 
            case 57: 
            case 90: 
            case 97: 
            case 115: 
            case 116: 
            case 122: 
            case 128: 
            case 129: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 212: 
            case 213: 
            case 347: 
            case 369: 
            case 370: {
                return true;
            }
        }
        return false;
    }

    static boolean isTrailerField(Field field, DataDictionary dd) {
        return Message.isTrailerField(field.getField()) || dd != null && dd.isTrailerField(field.getField());
    }

    static boolean isTrailerField(int field) {
        switch (field) {
            case 10: 
            case 89: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public void pushBack(StringField field) {
        this.pushedBackField = field;
    }

    private StringField extractField(DataDictionary dataDictionary, FieldMap fields) throws InvalidMessage {
        return this.extractField(null, dataDictionary, fields);
    }

    private StringField extractField(Group group, DataDictionary dataDictionary, FieldMap fields) throws InvalidMessage {
        if (this.pushedBackField != null) {
            StringField f = this.pushedBackField;
            this.pushedBackField = null;
            return f;
        }
        if (this.position >= this.messageData.length()) {
            return null;
        }
        int equalsOffset = this.messageData.indexOf(61, this.position);
        if (equalsOffset == -1) {
            throw new InvalidMessage("Equal sign not found in field");
        }
        int tag = -1;
        try {
            tag = Integer.parseInt(this.messageData.substring(this.position, equalsOffset));
        }
        catch (NumberFormatException e) {
            throw new InvalidMessage("bad tag format: " + e.getMessage());
        }
        int sohOffset = this.messageData.indexOf(1, equalsOffset + 1);
        if (sohOffset == -1) {
            throw new InvalidMessage("SOH not found at end of field: " + tag);
        }
        if (dataDictionary != null && dataDictionary.isDataField(tag)) {
            int fieldLength;
            int lengthField = tag - 1;
            if (tag == 89) {
                lengthField = 93;
            }
            try {
                fieldLength = group == null ? fields.getInt(lengthField) : group.getInt(lengthField);
            }
            catch (FieldNotFound e1) {
                throw new InvalidMessage("Tag " + e1.field + " not found.");
            }
            sohOffset = equalsOffset + 1 + fieldLength;
        }
        this.position = sohOffset + 1;
        return new StringField(tag, this.messageData.substring(equalsOffset + 1, sohOffset));
    }

    public boolean hasValidStructure() {
        return this.isValidStructure;
    }

    public int getInvalidStructureTag() {
        return this.isValidStructureTag;
    }

    public class Trailer
    extends FieldMap {
        static final long serialVersionUID = -3193357271891865972L;

        @Override
        protected void calculateString(StringBuffer buffer, int[] excludedFields, int[] postFields) {
            super.calculateString(buffer, null, new int[]{10});
        }
    }

    public class Header
    extends FieldMap {
        static final long serialVersionUID = -3193357271891865972L;

        @Override
        protected void calculateString(StringBuffer buffer, int[] excludedFields, int[] postFields) {
            super.calculateString(buffer, new int[]{8, 9, 35}, postFields);
        }
    }
}

