/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.api.Util;
import com.install4j.runtime.util.BasicAntiAliasTextAreaUI;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.PartialLineBorder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class WindowsLafHelper {
    public static final float WINDOWS_TITLE_FONT_FACTOR = 1.25f;
    private static final Color WINDOWS_TITLE_COLOR = WindowsLafHelper.isDarculaLaF() ? UIManager.getColor("darcula.foreground") : new Color(0, 51, 153);
    private static final Color WINDOWS_SEPARATOR_COLOR = WindowsLafHelper.isDarculaLaF() ? UIManager.getColor("Separator.foreground") : new Color(223, 223, 223);
    private static Font nativeWindowsDialogFont;
    private static String[] availableFontFamilyNames;

    public static <T extends JComponent> T applyWindowsBottomSeparator(T component) {
        component.setBorder(new PartialLineBorder(WINDOWS_SEPARATOR_COLOR, 1, 2));
        return component;
    }

    public static <T extends JComponent> T nativeWindowsFont(T component) {
        if (!Boolean.getBoolean("ejt.noNativeDialogFont") && Util.isWindows()) {
            component.setFont(WindowsLafHelper.getNativeDialogFont());
            if (component instanceof DisplayTextArea && WindowsLafHelper.isAlloyLaF()) {
                ((DisplayTextArea)component).setUI(new BasicAntiAliasTextAreaUI());
            }
        }
        return component;
    }

    public static Font getNativeDialogFont() {
        if (nativeWindowsDialogFont == null) {
            String fontName = WindowsLafHelper.getNativeDialogFontName();
            nativeWindowsDialogFont = Util.isWindows() && WindowsLafHelper.isFontInstalled(fontName) ? new Font(fontName, 0, 12) : UIManager.getFont("Label.font");
        }
        return nativeWindowsDialogFont;
    }

    @NotNull
    private static String getNativeDialogFontName() {
        Locale locale = Locale.getDefault();
        if (locale.equals(new Locale("zh", "CN"))) {
            return "Microsoft YaHei UI";
        }
        if (locale.equals(new Locale("zh", "TW"))) {
            return "Microsoft JhengHei UI";
        }
        if (locale.getLanguage().equals(new Locale("ko").getLanguage())) {
            return "Malgun Gothic";
        }
        if (locale.getLanguage().equals(new Locale("ja").getLanguage())) {
            return "Meiryo UI";
        }
        return "Segoe UI";
    }

    public static <T extends JComponent> T makeWindowsTitleLabel(T component) {
        WindowsLafHelper.nativeWindowsFont(component);
        Font font = component.getFont();
        float size = font.getFamily().equals("Segoe UI") ? 16.0f : (float)font.getSize() * 1.25f;
        component.setFont(font.deriveFont(size));
        component.setForeground(WINDOWS_TITLE_COLOR);
        return component;
    }

    public static boolean isWindowsLaF() {
        return UIManager.getLookAndFeel().getID().equals("Windows");
    }

    public static boolean isAlloyLaF() {
        return UIManager.getLookAndFeel().getID().equals("Alloy");
    }

    public static boolean isFontInstalled(@NotNull String familyName) {
        if (availableFontFamilyNames == null) {
            GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
            availableFontFamilyNames = g.getAvailableFontFamilyNames();
        }
        for (String name : availableFontFamilyNames) {
            if (!name.equals(familyName)) continue;
            return true;
        }
        return false;
    }

    public static void setupAntiAliasing(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            Graphics2D g = (Graphics2D)graphics;
            Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            if (map != null) {
                g.addRenderingHints(map);
            } else {
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR);
            }
        }
    }

    public static boolean isDarculaLaF() {
        return UIManager.getLookAndFeel().getID().equals("Darcula");
    }
}

