/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.exe4j.runtime.LauncherEngine;
import com.exe4j.runtime.splash.SplashEngine;
import com.exe4j.runtime.splash.SplashScreenConfig;
import com.exe4j.runtime.util.ArgumentStack;
import com.install4j.runtime.installer.platform.win32.Common;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.launcher.LauncherHelper;
import com.install4j.runtime.launcher.service.UnixServiceHandler;
import com.install4j.runtime.launcher.util.ErrorHandler;
import com.install4j.runtime.launcher.util.LauncherUtil;
import com.install4j.runtime.launcher.util.SingleInstance;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class UnixLauncher {
    public static void main(String[] args) {
        LauncherHelper.INSTANCE.initIntegration();
        args = LauncherHelper.INSTANCE.initVariables(UnixLauncher.class, args);
        try {
            ArgumentStack argStack = new ArgumentStack(args);
            String method = argStack.popString();
            if (method.equals("stop")) {
                UnixServiceHandler.INSTANCE.setStop();
            } else if (method.equals("status")) {
                UnixServiceHandler.INSTANCE.reportStatus();
            } else {
                String configId = argStack.popString();
                String stdErrFile = argStack.popString();
                String stdOutFile = argStack.popString();
                String className = argStack.popString();
                LauncherEngine.setProperties(UnixLauncher.readProperties(configId));
                if (LauncherUtil.isMacOS() && !LauncherHelper.INSTANCE.getInstallerFile(Common.getMacLibraryFilename(0)).isFile()) {
                    System.setProperty("install4j.noNativeDialogs", "true");
                }
                boolean isGuiApplication = LauncherEngine.getBooleanProperty(162);
                ErrorHandler.setIsGuiApplication(isGuiApplication);
                boolean failOnMainMethodException = LauncherEngine.getBooleanProperty(106);
                String[] originalArgs = Launcher.getArgumentArray(argStack, argStack.size());
                Launcher.setOriginalArgs(originalArgs);
                SplashEngine.setJavaSplashScreenConfig(new SplashScreenConfig().initFromLauncherEngine());
                if (method.equals("launch")) {
                    UnixLauncher.checkSingleInstance(configId, originalArgs);
                    UnixLauncher.checkWarning();
                    LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
                } else if (method.equals("start")) {
                    UnixServiceHandler.INSTANCE.setStart();
                    if (LauncherEngine.getBooleanProperty(10011)) {
                        UnixLauncher.checkSingleInstance(configId, originalArgs);
                    }
                    LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
                } else if (method.equals("run")) {
                    UnixLauncher.checkSingleInstance(configId, originalArgs);
                    UnixLauncher.checkWarning();
                    LauncherEngine.launch(className, originalArgs, "", "", failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
                } else if (method.equals("run-redirect")) {
                    UnixLauncher.checkSingleInstance(configId, originalArgs);
                    UnixLauncher.checkWarning();
                    LauncherEngine.launch(className, originalArgs, stdErrFile, stdOutFile, failOnMainMethodException, isGuiApplication, ClassLoader.getSystemClassLoader());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.reportError(e.toString());
            System.exit(1);
        }
    }

    private static void checkSingleInstance(String configId, String[] originalArgs) {
        String moduleName;
        boolean languageRestart;
        boolean bl = languageRestart = originalArgs.length >= 1 && "__i4j_lang_restart".equals(originalArgs[0]);
        if (!languageRestart && LauncherEngine.getBooleanProperty(10005) && (moduleName = System.getProperty("exe4j.moduleName")) != null) {
            SingleInstance.checkForCurrentLauncher(new File(moduleName), LauncherEngine.getBooleanProperty(158), configId.equals("0") ? null : originalArgs);
        }
    }

    private static void checkWarning() {
        if (LauncherEngine.getBooleanProperty(148)) {
            System.out.println("This launcher was created with an evaluation version of install4j.");
        }
    }

    private static Properties readProperties(String configId) {
        if (configId.equals("0")) {
            Properties properties = new Properties();
            properties.setProperty(String.valueOf(162), String.valueOf(1));
            properties.setProperty(String.valueOf(10005), String.valueOf(1));
            return properties;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(LauncherHelper.INSTANCE.getInstallerFile(configId + ".lprop")));
            Properties properties = new Properties();
            properties.load(in);
            return LauncherUtil.replaceVariables(properties);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new Properties();
        }
    }
}

