/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.apiimpl;

import com.install4j.runtime.installer.helper.PreferencesUtil;
import com.install4j.runtime.installer.helper.VariableEncoding;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class VariablesImpl {
    public static Map<String, Object> loadVariablesFromPreferenceStore(String packageName, boolean userSpecific) throws IOException {
        if (InstallRegistry.isNoPreferences()) {
            return null;
        }
        try {
            PreferencesUtil.getRootNode(userSpecific).sync();
            Preferences packageNode = PreferencesUtil.getPackageNodeNoCreation(packageName, userSpecific);
            if (packageNode == null) {
                return null;
            }
            packageNode.sync();
            String[] keys = packageNode.keys();
            if (keys == null || keys.length == 0) {
                return null;
            }
            HashMap<String, String> encodedVariables = new HashMap<String, String>();
            for (String key : keys) {
                encodedVariables.put(key, packageNode.get(key, null));
            }
            return VariableEncoding.decodeVariables(encodedVariables, false);
        }
        catch (BackingStoreException e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
    }

    public static void saveVariablesToPreferenceStore(Map<String, Object> variables, String packageName, boolean userSpecific) throws IOException {
        if (InstallRegistry.isNoPreferences()) {
            return;
        }
        HashMap<String, String> encodedVariables = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            String string = entry.getKey();
            Object variableValue = entry.getValue();
            VariableEncoding.encodeVariable(encodedVariables, string, variableValue);
        }
        try {
            Preferences packageNode = PreferencesUtil.getPackageNode(packageName, userSpecific);
            for (Map.Entry entry : encodedVariables.entrySet()) {
                packageNode.put((String)entry.getKey(), (String)entry.getValue());
            }
            packageNode.flush();
        }
        catch (BackingStoreException e) {
            IOException iOException = new IOException(e.getMessage());
            iOException.initCause(e);
            throw iOException;
        }
    }
}

