/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.headless;

import com.install4j.api.Util;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.DummyWizardContext;
import com.install4j.runtime.installer.WizardContextInt;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.CommandSink;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.FinishCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collections;
import javax.swing.JEditorPane;

public abstract class AbstractHeadlessScreenExecutor
implements ScreenExecutor {
    public static final String EMPTY_FONT_FILE_NAME = "i4jempty.ttf";
    private CommandSink commandSink;
    private ContextImpl contextImpl;
    private boolean exitCalled = false;
    private WizardContextInt dummyWizardContext = this.createWizardContext();
    private boolean fileInstallerProgressInterfaceSet;

    public AbstractHeadlessScreenExecutor() {
        this.contextImpl = this.createContext();
    }

    protected abstract ContextImpl createContext();

    protected abstract ControllerCommand handleScreen(ScreenBeanConfig var1) throws UserCanceledException;

    protected DummyWizardContext createWizardContext() {
        return new DummyWizardContext();
    }

    protected void init(boolean headless) {
        if (headless) {
            InstallerUtil.setHeadlessProperty();
        }
        Policy.setPolicy(new AllowAllPolicy());
        System.setSecurityManager(new CheckExitSecurityManager());
        Runtime.getRuntime().addShutdownHook(new Thread("shutdown hook"){

            @Override
            public void run() {
                if (!AbstractHeadlessScreenExecutor.this.exitCalled && AbstractHeadlessScreenExecutor.this.commandSink != null) {
                    ConsoleImpl.getInstance().cancel();
                    ContextImpl.setCancelling();
                    AbstractHeadlessScreenExecutor.this.commandSink.returnToController(ControllerCommand.CANCEL);
                    AbstractHeadlessScreenExecutor.this.commandSink.waitForFinish();
                }
            }
        });
        if (!HelperCommunication.getInstance().isElevatedHelper()) {
            GUIHelper.invokeOnEDT(new Runnable(){

                @Override
                public void run() {
                    if (!Util.isMacOS() && !Util.isWindows()) {
                        AbstractHeadlessScreenExecutor.initFontManager();
                    }
                    new FormPanel(Collections.emptyList(), AbstractHeadlessScreenExecutor.this.getContext(), null, null);
                    AbstractHeadlessScreenExecutor.createEditorPane();
                }
            });
        }
    }

    @Override
    public void execute(ScreenBeanConfig screenConfig, CommandSink commandSink, boolean previousPossible, ControllerCommand lastCommand) {
        this.setCommandSink(commandSink);
        if (!this.fileInstallerProgressInterfaceSet) {
            FileInstaller.getInstance().setDefaultProgressInterface(this.getProgressInterface());
            this.fileInstallerProgressInterfaceSet = true;
        }
        try {
            ControllerCommand specialCommand = this.handleScreen(screenConfig);
            if (specialCommand != null) {
                commandSink.returnToController(specialCommand);
            } else {
                commandSink.returnToController(new GoForwardCommand(1, true, true, null));
            }
        }
        catch (UserCanceledException e) {
            commandSink.returnToController(ControllerCommand.CANCEL);
        }
        catch (Throwable e) {
            this.getContext().handleCriticalException(e);
        }
    }

    @Override
    public void setCommandSink(CommandSink commandSink) {
        this.commandSink = commandSink;
    }

    @Override
    public CommandSink getCommandSink() {
        return this.commandSink;
    }

    @Override
    public ProgressInterface getDefaultProgressInterface() {
        return this.getProgressInterface();
    }

    @Override
    public WizardContextInt getWizardContext() {
        return this.dummyWizardContext;
    }

    @Override
    public void setRollback() {
        this.getProgressInterface().setStatusMessage(Messages.getMessages().getString("StatusRollback"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ControllerCommand runValidationScript(ScreenBeanConfig screenConfig, Screen screen, Object ... scriptParameters) {
        ControllerCommand storedCommand;
        boolean validated;
        this.getCommandSink().startStoreCommand();
        try {
            validated = this.getContext().runBooleanScript(screenConfig.getValidationClassName(), screen, scriptParameters);
        }
        finally {
            storedCommand = this.getCommandSink().finishStoreCommand();
        }
        if (storedCommand != null) {
            return storedCommand;
        }
        if (!validated) {
            return ControllerCommand.CANCEL;
        }
        if (screenConfig.isFinishScreen()) {
            return new FinishCommand(null);
        }
        return null;
    }

    @Override
    public void closeWindows() {
    }

    @Override
    public ActionCallback getActionCallback() {
        return null;
    }

    @Override
    public void register(Screen screen, ScreenBeanConfig config) {
        this.getContext().applyToScreen(screen, config);
    }

    @Override
    public ContextImpl getContext() {
        return this.contextImpl;
    }

    @Override
    public void initializeLazilyLoadedScreens() {
    }

    private static void initFontManager() {
        block20: {
            Error initialInternalError = null;
            try {
                try {
                    AbstractHeadlessScreenExecutor.createEditorPane();
                }
                catch (Error e) {
                    if (!AbstractHeadlessScreenExecutor.isFontRelatedError(e)) {
                        throw e;
                    }
                    initialInternalError = e;
                    File fontFile = InstallerUtil.getInstallerFile(EMPTY_FONT_FILE_NAME);
                    if (!fontFile.isFile()) break block20;
                    File tempFile = File.createTempFile("i4jfont", ".properties");
                    tempFile.deleteOnExit();
                    try (FileOutputStream out = new FileOutputStream(tempFile);){
                        String fontConfigContent = "Version=1\nsequence.allfonts=i4jempty\nsequence.fallback=i4jempty\nallfonts.i4jempty=i4jempty\nfilename.i4jempty=" + fontFile + "\n";
                        out.write(fontConfigContent.getBytes());
                    }
                    System.setProperty("sun.awt.fontconfig", tempFile.getAbsolutePath());
                    AbstractHeadlessScreenExecutor.createEditorPane();
                }
            }
            catch (Throwable e) {
                if (initialInternalError != null) {
                    throw initialInternalError;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean isFontRelatedError(Error e) {
        if (e instanceof InternalError) {
            return true;
        }
        String message = e.getMessage();
        return message != null && message.contains("No fonts found");
    }

    private static void createEditorPane() {
        new JEditorPane("text/plain", "init text");
    }

    private class CheckExitSecurityManager
    extends SecurityManager {
        private CheckExitSecurityManager() {
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        @Override
        public void checkCreateClassLoader() {
        }

        @Override
        public void checkAccess(Thread t) {
        }

        @Override
        public void checkAccess(ThreadGroup g) {
        }

        @Override
        public void checkExit(int status) {
            AbstractHeadlessScreenExecutor.this.exitCalled = true;
        }

        @Override
        public void checkExec(String cmd) {
        }

        @Override
        public void checkLink(String lib) {
        }

        @Override
        public void checkRead(FileDescriptor fd) {
        }

        @Override
        public void checkRead(String file) {
        }

        @Override
        public void checkRead(String file, Object context) {
        }

        @Override
        public void checkWrite(FileDescriptor fd) {
        }

        @Override
        public void checkWrite(String file) {
        }

        @Override
        public void checkDelete(String file) {
        }

        @Override
        public void checkConnect(String host, int port) {
        }

        @Override
        public void checkConnect(String host, int port, Object context) {
        }

        @Override
        public void checkListen(int port) {
        }

        @Override
        public void checkAccept(String host, int port) {
        }

        @Override
        public void checkMulticast(InetAddress inetAddress) {
        }

        @Override
        @Deprecated
        public void checkMulticast(InetAddress inetAddress, byte ttl) {
        }

        @Override
        public void checkPropertiesAccess() {
        }

        @Override
        public void checkPropertyAccess(String key) {
        }

        @Deprecated
        public boolean checkTopLevelWindow(Object window) {
            return true;
        }

        @Override
        public void checkPrintJobAccess() {
        }

        @Deprecated
        public void checkSystemClipboardAccess() {
        }

        @Deprecated
        public void checkAwtEventQueueAccess() {
        }

        @Override
        public void checkPackageAccess(String pkg) {
        }

        @Override
        public void checkPackageDefinition(String pkg) {
        }

        @Override
        public void checkSetFactory() {
        }

        @Deprecated
        public void checkMemberAccess(Class clazz, int which) {
        }

        @Override
        public void checkSecurityAccess(String target) {
        }
    }

    private static class AllowAllPolicy
    extends Policy {
        private AllowAllPolicy() {
        }

        @Override
        public PermissionCollection getPermissions(CodeSource codesource) {
            Permissions permission = new Permissions();
            permission.add(new AllPermission());
            return permission;
        }

        @Override
        public PermissionCollection getPermissions(ProtectionDomain domain) {
            Permissions permission = new Permissions();
            permission.add(new AllPermission());
            return permission;
        }

        @Override
        public void refresh() {
        }
    }
}

