/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.launcher.util.SingleInstance;
import com.install4j.runtime.util.StringUtil;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class Application {
    public static void main(String[] args) {
        if (!HelperCommunication.executeAsHelper(args)) {
            InstallerUtil.setInProcess(false);
            if (args.length == 0) {
                System.err.println("Please provide the application id as first argument");
                System.exit(1);
            }
            String applicationId = args[0];
            String[] rest = new String[args.length - 1];
            System.arraycopy(args, 1, rest, 0, args.length - 1);
            InstallerConfig.setCurrentApplicationId(applicationId);
            CustomApplication customApplication = Application.getCustomApplication();
            if (customApplication != null && customApplication.isSingleInstance()) {
                File exeFileName = System.getProperty("exe4j.moduleName") != null ? new File(System.getProperty("exe4j.moduleName")) : Application.getExeFile(customApplication);
                SingleInstance.checkForCurrentLauncher(exeFileName, false, null);
            }
            Application.runApplication(rest, false, null);
        }
    }

    public static synchronized void runApplicationInProcess(String applicationId, String[] arguments, final boolean dialog, final Window parentWindow) {
        FileInstaller.clearFileInstaller();
        InstallerConfig.clearCurrentApplication();
        InstallerConfig.setCurrentApplicationId(applicationId);
        if (arguments == null) {
            arguments = new String[]{};
        }
        ArrayList<String> allArguments = new ArrayList<String>();
        StringUtil.splitupCommandLine(allArguments, InstallerConfig.getCurrentApplication().getArguments());
        allArguments.addAll(Arrays.asList(arguments));
        final String[] usedArguments = allArguments.toArray(new String[0]);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Application.runApplication(usedArguments, dialog, parentWindow);
            }
        };
        CustomApplication customApplication = Application.getCustomApplication();
        if (customApplication != null && customApplication.isSingleInstance()) {
            if (!SingleInstance.checkInProcessAndRun(Application.getExeFile(customApplication), runnable)) {
                InstallerUtil.exit(0);
            }
        } else {
            runnable.run();
        }
    }

    private static void runApplication(String[] arguments, boolean dialog, Window parentWindow) {
        try {
            ScreenExecutor screenExecutor = Installer.getScreenExecutor(arguments, dialog, parentWindow);
            Application.initInstallationDirectory();
            new Controller(screenExecutor).start();
        }
        catch (Throwable t) {
            InstallerUtil.reportException(t);
            InstallerUtil.exit(1);
        }
    }

    static void initInstallationDirectory() {
        InstallerConfig config = InstallerConfig.getCurrentInstance();
        File installationDirectory = new File(ResourceHelper.getRuntimeDir(), "..");
        if (Util.isMacOS() && config.getMacSpecificConfig().isSingleBundle()) {
            installationDirectory = new File(installationDirectory, "../../../..");
        }
        try {
            installationDirectory = installationDirectory.getCanonicalFile();
        }
        catch (IOException e) {
            installationDirectory = installationDirectory.getAbsoluteFile();
        }
        config.setInstallationDirectory(installationDirectory);
    }

    public static File getExeFile(ApplicationWithPath customApplication) {
        File execDir = customApplication.getExecutableDirectory();
        execDir = execDir == null || execDir.getPath().trim().equals("") ? ResourceHelper.getRuntimeDir() : new File(ResourceHelper.getRuntimeDir(), "../" + execDir.getPath());
        File execFile = new File(execDir, customApplication.getExecutableName() + (Util.isWindows() ? ".exe" : ""));
        try {
            execFile = execFile.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return execFile;
    }

    private static CustomApplication getCustomApplication() {
        com.install4j.runtime.beans.applications.Application application = InstallerConfig.getCurrentApplication();
        if (application instanceof CustomApplication) {
            return (CustomApplication)application;
        }
        return null;
    }
}

