/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFileSystemChooser<T extends AbstractFileSystemChooser<T>>
implements Iterable<File> {
    private Window parent;
    private String title;
    private File currentDirectory;
    private String approveButtonText;
    private File defaultSelectedFile;
    private boolean fileHidingEnabled = true;
    private boolean selected = false;

    public boolean select() {
        if (this.parent != null) {
            this.parent.toFront();
        }
        this.selected = true;
        return this.selectInternal();
    }

    public abstract boolean selectInternal();

    protected abstract Collection<File> getAllFiles();

    @Override
    @NotNull
    public Iterator<File> iterator() {
        this.checkSelected();
        return this.getAllFiles().iterator();
    }

    protected void checkSelected() {
        if (!this.selected) {
            throw new RuntimeException("File chooser was not shown yet");
        }
    }

    public Window getParent() {
        return this.parent;
    }

    public T parent(Component parent) {
        this.parent = this.getWindow(parent);
        return this.getTypedThis();
    }

    public String getTitle() {
        return this.title;
    }

    public T title(String title) {
        this.title = title;
        return this.getTypedThis();
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public T currentDirectory(File currentDirectory) {
        if (currentDirectory != null) {
            if (currentDirectory.getPath().isEmpty()) {
                currentDirectory = new File(System.getProperty("user.home"));
            } else if (currentDirectory.isFile()) {
                currentDirectory = currentDirectory.getParentFile();
            }
        }
        this.currentDirectory = currentDirectory;
        return this.getTypedThis();
    }

    public String getApproveButtonText() {
        return this.approveButtonText;
    }

    public T approveButtonText(String approveButtonText) {
        this.approveButtonText = approveButtonText;
        return this.getTypedThis();
    }

    public File getDefaultSelectedFile() {
        return this.defaultSelectedFile;
    }

    public T defaultSelectedFile(File defaultSelectedFile) {
        this.defaultSelectedFile = defaultSelectedFile;
        if (defaultSelectedFile != null) {
            this.currentDirectory(defaultSelectedFile.getParentFile());
        }
        return this.getTypedThis();
    }

    public boolean isFileHidingEnabled() {
        return this.fileHidingEnabled;
    }

    public T fileHidingEnabled(boolean fileHidingEnabled) {
        this.fileHidingEnabled = fileHidingEnabled;
        return this.getTypedThis();
    }

    private T getTypedThis() {
        return (T)this;
    }

    private Window getWindow(Component parent) {
        if (parent instanceof Window) {
            return (Window)parent;
        }
        return SwingUtilities.getWindowAncestor(parent);
    }
}

