/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.styles;

import com.install4j.api.context.ControlButtonType;
import com.install4j.api.styles.ControlButtonContainer;
import com.install4j.api.styles.NestedStyleContainer;
import com.install4j.api.styles.Style;
import com.install4j.api.styles.StyleContext;
import com.install4j.api.styles.StyleContextReceiver;
import com.install4j.api.styles.StyleManager;
import com.install4j.runtime.beans.formcomponents.SystemFormComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class NestedStyleComponent
extends SystemFormComponent
implements StyleContextReceiver,
ControlButtonContainer,
NestedStyleContainer {
    private String styleId = "";
    private Style style;

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        this.styleId = styleId;
    }

    @Override
    public void setStyleContext(StyleContext styleContext) {
        if (styleContext != null) {
            this.initStyle();
            if (this.style != null) {
                this.style.setStyleContext(styleContext);
            }
        }
    }

    @Override
    public JComponent createCenterComponent() {
        this.initStyle();
        if (this.style != null) {
            return this.getStyleManager().createStyleComponent(this.style);
        }
        return new JLabel("Error, style with ID " + this.styleId + " does not exist");
    }

    @Override
    public Collection<String> getNestedStyleIds() {
        return Collections.singleton(this.styleId);
    }

    private void initStyle() {
        if (this.style == null) {
            this.style = this.getStyleManager().cloneStyleById(this.styleId);
        }
    }

    private StyleManager getStyleManager() {
        return this.getContext().getWizardContext().getStyleManager();
    }

    @Override
    public boolean isFillCenterHorizontal() {
        this.initStyle();
        if (this.style != null) {
            return this.style.isFillHorizontal();
        }
        return false;
    }

    @Override
    public boolean isFillCenterVertical() {
        this.initStyle();
        if (this.style != null) {
            return this.style.isFillVertical();
        }
        return false;
    }

    @Override
    public void formWillActivate() {
        super.formWillActivate();
        this.getStyleManager().willActivate(this.style);
    }

    @Override
    public void formActivated() {
        super.formActivated();
        this.getStyleManager().activated(this.style);
    }

    @Override
    public void formDeactivated() {
        super.formDeactivated();
        this.getStyleManager().deactivated(this.style);
    }

    @Override
    public void setControlButtonEnabled(ControlButtonType controlButtonType, boolean enabled) {
        this.style.setControlButtonEnabled(controlButtonType, enabled);
    }

    @Override
    public void setControlButtonVisible(ControlButtonType controlButtonType, boolean visible) {
        this.style.setControlButtonVisible(controlButtonType, visible);
    }

    @Override
    public void setControlButtonText(ControlButtonType controlButtonType, String text) {
        this.style.setControlButtonText(controlButtonType, text);
    }

    @Override
    public void focusControlButton(ControlButtonType controlButtonType) {
        this.style.focusControlButton(controlButtonType);
    }

    @Override
    public void migrateIds(Map<String, String> oldIdToNewId) {
        super.migrateIds(oldIdToNewId);
        String newId = oldIdToNewId.get(this.styleId);
        if (newId != null) {
            this.styleId = newId;
            this.style = null;
        }
    }
}

