/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.menu;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.spellcheck.Dictionary;
import com.teamdev.jxbrowser.view.swing.internal.menu.ContextMenu;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class SpellingContextMenu
extends ContextMenu {
    public SpellingContextMenu(JComponent component, ShowContextMenuCallback.Params params, ShowContextMenuCallback.Action callback) {
        super(component, params, callback);
    }

    @Override
    protected void initialize(JPopupMenu popupMenu) {
        Browser browser = this.getParams().browser();
        this.addSuggestionMenuItems(popupMenu, browser);
        this.addAddToDictionaryMenuItem(popupMenu, browser);
    }

    private void addSuggestionMenuItems(JPopupMenu popupMenu, Browser browser) {
        Iterator iterator = this.getParams().spellCheckMenu().dictionarySuggestions().iterator();
        while (iterator.hasNext()) {
            String dictionarySuggestion = (String)iterator.next();
            JMenuItem menuItem = new JMenuItem(dictionarySuggestion);
            menuItem.addActionListener(e -> {
                browser.replaceMisspelledWord(dictionarySuggestion);
                this.getCallback().close();
            });
            popupMenu.add(menuItem);
            if (iterator.hasNext()) continue;
            popupMenu.addSeparator();
        }
    }

    private void addAddToDictionaryMenuItem(JPopupMenu popupMenu, Browser browser) {
        JMenuItem menuItem = new JMenuItem(this.getParams().spellCheckMenu().addToDictionaryMenuItemText());
        menuItem.addActionListener(e -> {
            Dictionary dictionary = browser.engine().spellChecker().customDictionary();
            dictionary.add(this.getParams().spellCheckMenu().misspelledWord());
            this.getCallback().close();
        });
        popupMenu.add(menuItem);
    }
}

