/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal.dnd;

import com.teamdev.jxbrowser.browser.internal.RenderWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.DragCursorUpdated;
import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.browser.internal.rpc.DragStarted;
import com.teamdev.jxbrowser.browser.internal.rpc.DropData;
import com.teamdev.jxbrowser.browser.internal.rpc.DropMetadata;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.util.GeometryUtil;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.view.swing.BitmapUtil;
import com.teamdev.jxbrowser.view.swing.internal.Platform;
import com.teamdev.jxbrowser.view.swing.internal.SwingUtil;
import com.teamdev.jxbrowser.view.swing.internal.dnd.BrowserTransferable;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.FileTransferableParser;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.HtmlTransferableParser;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.TextTransferableParser;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.TransferableParser;
import com.teamdev.jxbrowser.view.swing.internal.dnd.parser.UrlTransferableParser;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public final class DragAndDropHelper {
    private final JComponent component;
    private final RenderWidget renderWidget;
    private final ToolkitLibrary toolkitLibrary;
    private final DropTarget dropTarget;
    private final DragGestureRecognizer dragGestureRecognizer;
    private Display display;
    private DragContext context;
    private Subscription dragStarted;
    private Subscription dragCursorUpdated;
    private State state;

    public DragAndDropHelper(JComponent component, ToolkitLibrary toolkitLibrary, RenderWidget widget, Display display) {
        this.toolkitLibrary = toolkitLibrary;
        this.renderWidget = widget;
        this.component = component;
        this.display = display;
        this.context = new DragContext();
        this.dropTarget = new DropTarget(null, new DropListener());
        DragSource dragSource = new DragSource();
        this.dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(null, 0x40000003, new DragListener());
        component.setTransferHandler(new TransferHandler(){});
        this.state = State.DETACHED;
    }

    public void attach() {
        if (this.state == State.ATTACHED) {
            return;
        }
        this.dropTarget.setComponent(this.component);
        this.dragGestureRecognizer.setComponent(this.component);
        this.dragStarted = this.renderWidget.on(DragStarted.class, this::onStartDragging);
        this.dragCursorUpdated = this.renderWidget.on(DragCursorUpdated.class, this::updateDragCursor);
        this.state = State.ATTACHED;
    }

    public void detach() {
        if (this.state == State.DETACHED) {
            return;
        }
        this.dropTarget.setComponent(null);
        this.dragGestureRecognizer.setComponent(null);
        this.dragStarted.unsubscribe();
        this.dragCursorUpdated.unsubscribe();
        this.state = State.DETACHED;
    }

    private void updateDragCursor(DragCursorUpdated event) {
        this.context.setOperation(event.getDragOperation());
    }

    private void onStartDragging(DragStarted event) {
        BrowserTransferable transferable = BrowserTransferable.newInstance(this.toolkitLibrary);
        transferable.setData(event.getDropData());
        BufferedImage image = BitmapUtil.toBufferedImage((Bitmap)event.getDragImage());
        BufferedImage image_1x = BitmapUtil.toBufferedImage((Bitmap)event.getDragImage1X());
        Image dragImage = Platform.getInstance().createMultiResolutionImage(image_1x, image);
        java.awt.Point offset = SwingUtil.toPoint((Point)event.getDragImageOffset());
        if (Environment.isMac()) {
            offset.x = -offset.x;
            offset.y = -offset.y;
        }
        this.context.startDragging(transferable, dragImage, offset);
    }

    public boolean isDragging() {
        return this.context.isDragging();
    }

    public void onDisplayChanged(Display display) {
        this.display = display;
    }

    private class DragListener
    extends DragSourceAdapter
    implements DragGestureListener {
        private DragListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (!DragAndDropHelper.this.context.isDragging()) {
                return;
            }
            DragSource dragSource = dge.getDragSource();
            BrowserTransferable transferable = (BrowserTransferable)DragAndDropHelper.this.context.getTransferable();
            Image dragImage = DragAndDropHelper.this.context.getDragImage();
            java.awt.Point imageOffset = DragAndDropHelper.this.context.getImageOffset();
            DragAndDropHelper.this.component.getTransferHandler().setDragImage(dragImage);
            DragAndDropHelper.this.component.getTransferHandler().setDragImageOffset(imageOffset);
            dragSource.startDrag(dge, null, dragImage, imageOffset, transferable, this);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            Point location = SwingUtil.toProtobufPoint(dsde.getLocation());
            DragOperation operation = SwingUtil.toDragOperation(dsde.getDropAction());
            if (!Platform.getInstance().isDpiAware()) {
                location = GeometryUtil.scaleDown((Point)location, (double)DragAndDropHelper.this.display.scaleFactor());
            }
            DragAndDropHelper.this.renderWidget.dragEnd(Point.empty(), location, operation);
            DragAndDropHelper.this.context.endDragging();
        }
    }

    private class DropListener
    extends DropTargetAdapter {
        private final List<TransferableParser> parsers = new ArrayList<TransferableParser>();

        DropListener() {
            this.parsers.add(new TextTransferableParser());
            this.parsers.add(new UrlTransferableParser(DragAndDropHelper.this.toolkitLibrary));
            this.parsers.add(new HtmlTransferableParser());
            this.parsers.add(new FileTransferableParser());
        }

        private void postProcessParsedData(DropData.Builder builder) {
            if (builder.getUrl().isEmpty() && UrlTransferableParser.isDataFormat(builder.getText())) {
                builder.setUrl(builder.getText());
            }
            if (builder.getText().isEmpty()) {
                builder.setText(builder.getUrl());
            }
        }

        private boolean canParse(Transferable transferable) {
            for (TransferableParser parser : this.parsers) {
                if (!parser.canParse(transferable)) continue;
                return true;
            }
            return false;
        }

        private DropData parse(Transferable transferable) {
            DropData.Builder builder = DropData.newBuilder();
            for (TransferableParser parser : this.parsers) {
                parser.parse(transferable, builder);
            }
            this.postProcessParsedData(builder);
            return builder.build();
        }

        private DropMetadata parseMetadata(Transferable transferable) {
            DropMetadata.Builder builder = DropMetadata.newBuilder();
            for (TransferableParser parser : this.parsers) {
                parser.parse(transferable, builder);
            }
            return builder.build();
        }

        private void updateDragOperation(DropTargetDragEvent dtde) {
            DragOperation operation = DragAndDropHelper.this.context.getOperation();
            if (operation == DragOperation.OPERATION_NONE) {
                dtde.rejectDrag();
            } else {
                dtde.acceptDrag(SwingUtil.toDragOperation(operation));
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (!this.canParse(dtde.getTransferable())) {
                dtde.rejectDrag();
                return;
            }
            Point location = SwingUtil.toProtobufPoint(dtde.getLocation());
            Point locationOnScreen = SwingUtil.toProtobufPoint(SwingUtil.getLocationOnScreen(DragAndDropHelper.this.component));
            Point screenLocation = GeometryUtil.makePoint((double)(locationOnScreen.x() + location.x()), (double)(locationOnScreen.y() + location.y()));
            DropMetadata dropMetadata = this.parseMetadata(dtde.getTransferable());
            int operations_allowed = SwingUtil.toDragOperationMask(dtde.getSourceActions());
            if (!Platform.getInstance().isDpiAware()) {
                location = GeometryUtil.scaleDown((Point)location, (double)DragAndDropHelper.this.display.scaleFactor());
                screenLocation = GeometryUtil.scaleDown((Point)screenLocation, (double)DragAndDropHelper.this.display.scaleFactor());
            }
            DragAndDropHelper.this.renderWidget.dragEnter(dropMetadata, location, screenLocation, operations_allowed);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (!this.canParse(dtde.getTransferable())) {
                dtde.rejectDrag();
                return;
            }
            this.updateDragOperation(dtde);
            Point location = SwingUtil.toProtobufPoint(dtde.getLocation());
            Point locationOnScreen = SwingUtil.toProtobufPoint(SwingUtil.getLocationOnScreen(DragAndDropHelper.this.component));
            Point screenLocation = GeometryUtil.makePoint((double)(locationOnScreen.x() + location.x()), (double)(locationOnScreen.y() + location.y()));
            int operations_allowed = SwingUtil.toDragOperationMask(dtde.getSourceActions());
            if (!Platform.getInstance().isDpiAware()) {
                location = GeometryUtil.scaleDown((Point)location, (double)DragAndDropHelper.this.display.scaleFactor());
                screenLocation = GeometryUtil.scaleDown((Point)screenLocation, (double)DragAndDropHelper.this.display.scaleFactor());
            }
            DragAndDropHelper.this.renderWidget.dragOver(location, screenLocation, operations_allowed);
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            DragAndDropHelper.this.renderWidget.dragLeave();
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Point location = SwingUtil.toProtobufPoint(dtde.getLocation());
            Point locationOnScreen = SwingUtil.toProtobufPoint(SwingUtil.getLocationOnScreen(DragAndDropHelper.this.component));
            Point screenLocation = GeometryUtil.makePoint((double)(locationOnScreen.x() + location.x()), (double)(locationOnScreen.y() + location.y()));
            dtde.acceptDrop(dtde.getDropAction());
            DropData dropData = this.parse(dtde.getTransferable());
            if (!Platform.getInstance().isDpiAware()) {
                location = GeometryUtil.scaleDown((Point)location, (double)DragAndDropHelper.this.display.scaleFactor());
                screenLocation = GeometryUtil.scaleDown((Point)screenLocation, (double)DragAndDropHelper.this.display.scaleFactor());
            }
            DragAndDropHelper.this.renderWidget.drop(dropData, location, screenLocation);
        }
    }

    private static class DragContext {
        private Transferable transferable;
        private Image dragImage;
        private java.awt.Point imageOffset;
        private boolean dragging;
        private DragOperation operation;

        private DragContext() {
        }

        void startDragging(Transferable transferable, Image image, java.awt.Point offset) {
            this.transferable = transferable;
            this.dragImage = image;
            this.imageOffset = offset;
            this.operation = DragOperation.OPERATION_NONE;
            this.dragging = true;
        }

        void endDragging() {
            this.dragging = false;
        }

        boolean isDragging() {
            return this.dragging;
        }

        Transferable getTransferable() {
            return this.transferable;
        }

        Image getDragImage() {
            return this.dragImage;
        }

        java.awt.Point getImageOffset() {
            return this.imageOffset;
        }

        DragOperation getOperation() {
            return this.operation;
        }

        void setOperation(DragOperation operation) {
            this.operation = operation;
        }
    }

    private static enum State {
        ATTACHED,
        DETACHED;

    }
}

