/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.internal.rpc.DragOperation;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Color;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Size;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public final class SwingUtil {
    public static java.awt.Point getLocationOnScreen(Component component) {
        return component.isShowing() ? component.getLocationOnScreen() : new java.awt.Point();
    }

    public static java.awt.Point toPoint(Point point) {
        return new java.awt.Point(point.x(), point.y());
    }

    public static Dimension toDimension(Size size) {
        return new Dimension(size.width(), size.height());
    }

    public static java.awt.Color toColor(Color color) {
        return new java.awt.Color(color.red(), color.green(), color.blue(), color.alpha());
    }

    public static void setupExtensionFilters(JFileChooser fileChooser, String filterDescription, List<String> extensions) {
        if (extensions.isEmpty()) {
            return;
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter(filterDescription, extensions.toArray(new String[0]));
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        FileFilter acceptAllFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return "All files";
            }
        };
        fileChooser.addChoosableFileFilter(acceptAllFilter);
    }

    public static Color toProtobufColor(java.awt.Color color) {
        return Color.newBuilder().red((float)color.getRed() / 255.0f).green((float)color.getGreen() / 255.0f).blue((float)color.getBlue() / 255.0f).build();
    }

    public static Point toProtobufPoint(java.awt.Point point) {
        return Point.of((int)point.x, (int)point.y);
    }

    public static int toDragOperationMask(int dragActionMask) {
        int result = 0;
        if ((dragActionMask & 1) == 1) {
            result |= 2;
        }
        if ((dragActionMask & 2) == 2) {
            result |= 0x10;
        }
        if ((dragActionMask & 0x40000000) == 0x40000000) {
            result |= 3;
        }
        return result;
    }

    public static DragOperation toDragOperation(int dragAction) {
        if (dragAction == 1) {
            return DragOperation.OPERATION_COPY;
        }
        if (dragAction == 2) {
            return DragOperation.OPERATION_MOVE;
        }
        if (dragAction == 0x40000000) {
            return DragOperation.OPERATION_LINK;
        }
        return DragOperation.OPERATION_NONE;
    }

    public static int toDragOperation(DragOperation operation) {
        if (operation == DragOperation.OPERATION_NONE) {
            return 0;
        }
        if (operation == DragOperation.OPERATION_COPY) {
            return 1;
        }
        if (operation == DragOperation.OPERATION_MOVE) {
            return 2;
        }
        if (operation == DragOperation.OPERATION_LINK) {
            return 0x40000000;
        }
        return 1;
    }

    private SwingUtil() {
    }

    private static Container getTopLevelContainer(Container container) {
        Container parent = container.getParent();
        if (parent == null || parent instanceof Window) {
            return container;
        }
        return SwingUtil.getTopLevelContainer(parent);
    }

    static java.awt.Point getLocationInWindow(JComponent component) {
        if (component.isShowing()) {
            java.awt.Point locationOnScreen = component.getLocationOnScreen();
            Container parent = component.getParent();
            if (parent != null) {
                Container container = SwingUtil.getTopLevelContainer(parent);
                java.awt.Point windowLocationOnScreen = container.getLocationOnScreen();
                int x = locationOnScreen.x - windowLocationOnScreen.x;
                int y = locationOnScreen.y - windowLocationOnScreen.y;
                if (Environment.isMac()) {
                    y = container.getHeight() - component.getHeight() - y;
                }
                return new java.awt.Point(x, y);
            }
        }
        return new java.awt.Point();
    }

    static void execute(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(task);
            }
            catch (InterruptedException | InvocationTargetException e) {
                Logger.error((String)"Failed to execute the task in the Event Dispatch Thread.", (Throwable)e);
            }
        }
    }
}

