/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.internal.rpc.CursorChanged;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.internal.CursorUtil;
import com.teamdev.jxbrowser.ui.internal.rpc.Bitmap;
import com.teamdev.jxbrowser.ui.internal.rpc.Cursor;
import com.teamdev.jxbrowser.ui.internal.rpc.CustomCursor;
import com.teamdev.jxbrowser.ui.internal.rpc.Point;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class SwingCursorUtil {
    private static final Map<Cursor.Type, Integer> knownCursorTypes;

    SwingCursorUtil() {
    }

    static java.awt.Cursor getCursor(CursorChanged event) {
        CursorChanged.CursorCase cursorCase = event.getCursorCase();
        if (cursorCase == CursorChanged.CursorCase.STANDARD) {
            return SwingCursorUtil.getStandardCursor(event.getStandard());
        }
        if (cursorCase == CursorChanged.CursorCase.CUSTOM) {
            return SwingCursorUtil.createCustomCursor(event.getCustom());
        }
        throw new IllegalArgumentException("Cursor case not supported: " + cursorCase.name());
    }

    private static java.awt.Cursor getStandardCursor(Cursor cursor) {
        Cursor.Type cursorType = cursor.getType();
        return Optional.ofNullable(knownCursorTypes.get(cursorType)).map(java.awt.Cursor::getPredefinedCursor).orElse(SwingCursorUtil.getCursorFromResource(cursorType));
    }

    private static java.awt.Cursor getCursorFromResource(Cursor.Type cursorType) {
        Optional cursorResource = CursorUtil.cursorResource((Cursor.Type)cursorType);
        if (cursorResource.isPresent()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage((URL)cursorResource.get());
            java.awt.Point hotSpot = CursorUtil.cursorHotspot((Cursor.Type)cursorType).map(point -> new java.awt.Point(point.x(), point.y())).orElse(new java.awt.Point());
            return toolkit.createCustomCursor(image, hotSpot, cursorType.name());
        }
        return java.awt.Cursor.getDefaultCursor();
    }

    private static java.awt.Cursor createCustomCursor(CustomCursor customCursor) {
        BufferedImage scaledCursorImage;
        BufferedImage cursorImage;
        Bitmap bitmap = customCursor.getBitmap();
        byte[] pixels = bitmap.getPixels().toByteArray();
        int width = bitmap.getSize().getWidth();
        int height = bitmap.getSize().getHeight();
        if (width == 0 || height == 0) {
            return java.awt.Cursor.getDefaultCursor();
        }
        Dimension bestCursorSize = Toolkit.getDefaultToolkit().getBestCursorSize(width, height);
        int preferredWidth = bestCursorSize.width;
        int preferredHeight = bestCursorSize.height;
        int[] intPixels = new int[pixels.length / 4];
        int index = 0;
        for (int idx = 0; idx < pixels.length; idx += 4) {
            int alpha = pixels[idx + 3] & 0xFF;
            int red = pixels[idx + 2] & 0xFF;
            int green = pixels[idx + 1] & 0xFF;
            int blue = pixels[idx] & 0xFF;
            intPixels[index++] = alpha << 24 | red << 16 | green << 8 | blue;
        }
        if (Environment.isWindows()) {
            int minWidth = Math.min(width, preferredWidth);
            int minHeight = Math.min(height, preferredHeight);
            cursorImage = new BufferedImage(minWidth, minHeight, 2);
            if (width < preferredWidth || height < preferredHeight) {
                Graphics2D graphics = (Graphics2D)cursorImage.getGraphics();
                graphics.setColor(new Color(0, 0, 0, 0));
                graphics.setComposite(AlphaComposite.getInstance(4));
                graphics.fillRect(0, 0, preferredWidth, preferredHeight);
            }
        } else {
            cursorImage = new BufferedImage(width, height, 2);
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                cursorImage.setRGB(x, y, intPixels[x + y * width]);
            }
        }
        if (width != preferredWidth || height != preferredHeight) {
            scaledCursorImage = new BufferedImage(preferredWidth, preferredHeight, 2);
            Graphics2D graphics = (Graphics2D)scaledCursorImage.getGraphics();
            graphics.drawImage(cursorImage, 0, 0, preferredWidth, preferredHeight, null);
        } else {
            scaledCursorImage = cursorImage;
        }
        Point cursorHotspot = customCursor.getHotspot();
        return Toolkit.getDefaultToolkit().createCustomCursor(scaledCursorImage, new java.awt.Point(cursorHotspot.getX(), cursorHotspot.getY()), "customCursor");
    }

    static {
        HashMap<Cursor.Type, Integer> cursorTypes = new HashMap<Cursor.Type, Integer>();
        cursorTypes.put(Cursor.Type.POINTER, 0);
        cursorTypes.put(Cursor.Type.CROSS, 1);
        cursorTypes.put(Cursor.Type.HAND, 12);
        cursorTypes.put(Cursor.Type.WAIT, 3);
        cursorTypes.put(Cursor.Type.IBEAM, 2);
        cursorTypes.put(Cursor.Type.NORTH_RESIZE, 8);
        cursorTypes.put(Cursor.Type.EAST_RESIZE, 11);
        cursorTypes.put(Cursor.Type.SOUTH_RESIZE, 9);
        cursorTypes.put(Cursor.Type.WEST_RESIZE, 10);
        cursorTypes.put(Cursor.Type.NORTH_EAST_RESIZE, 7);
        cursorTypes.put(Cursor.Type.SOUTH_EAST_RESIZE, 5);
        cursorTypes.put(Cursor.Type.NORTH_WEST_RESIZE, 6);
        cursorTypes.put(Cursor.Type.SOUTH_WEST_RESIZE, 4);
        cursorTypes.put(Cursor.Type.NORTH_SOUTH_RESIZE, 8);
        cursorTypes.put(Cursor.Type.EAST_WEST_RESIZE, 11);
        cursorTypes.put(Cursor.Type.NORTH_EAST_SOUTH_WEST_RESIZE, 7);
        cursorTypes.put(Cursor.Type.NORTH_WEST_SOUTH_EAST_RESIZE, 6);
        knownCursorTypes = Collections.unmodifiableMap(cursorTypes);
    }
}

