/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.event.BrowserClosing;
import com.teamdev.jxbrowser.browser.event.internal.RenderWidgetClosing;
import com.teamdev.jxbrowser.browser.internal.RenderWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.CursorChanged;
import com.teamdev.jxbrowser.browser.internal.rpc.DoneTabbing;
import com.teamdev.jxbrowser.browser.internal.rpc.DropDownCreated;
import com.teamdev.jxbrowser.browser.internal.rpc.DropDownDeleted;
import com.teamdev.jxbrowser.browser.internal.rpc.TooltipChanged;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.AWTHelperLibrary;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.rpc.RenderWidgetId;
import com.teamdev.jxbrowser.internal.util.GeometryUtil;
import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.KeyCode;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.MouseButton;
import com.teamdev.jxbrowser.ui.MouseModifiers;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.ScrollType;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.event.KeyReleased;
import com.teamdev.jxbrowser.ui.event.KeyTyped;
import com.teamdev.jxbrowser.ui.event.MouseDragged;
import com.teamdev.jxbrowser.ui.event.MouseEntered;
import com.teamdev.jxbrowser.ui.event.MouseExited;
import com.teamdev.jxbrowser.ui.event.MouseMoved;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.ui.event.MouseReleased;
import com.teamdev.jxbrowser.ui.event.MouseWheel;
import com.teamdev.jxbrowser.view.swing.internal.DisplayWatcher;
import com.teamdev.jxbrowser.view.swing.internal.Graphics2dDropDownWidget;
import com.teamdev.jxbrowser.view.swing.internal.HeavyweightPopupFactory;
import com.teamdev.jxbrowser.view.swing.internal.NativeKeyCodes;
import com.teamdev.jxbrowser.view.swing.internal.Platform;
import com.teamdev.jxbrowser.view.swing.internal.SwingCursorUtil;
import com.teamdev.jxbrowser.view.swing.internal.SwingUtil;
import com.teamdev.jxbrowser.view.swing.internal.Widget;
import com.teamdev.jxbrowser.view.swing.internal.dnd.DragAndDropHelper;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.SwingUtilities;

public abstract class OffScreenRenderWidget
extends JComponent
implements Widget {
    private final KeyListener keyListener;
    private final MouseListener mouseListener;
    private final FocusListener focusListener;
    private final ComponentListener resizeListener;
    private final WindowListener windowIconifiedListener;
    private final MouseWheelListener mouseWheelListener;
    private final ComponentListener windowMovedListener;
    private final RenderWidget renderWidget;
    private final NativeKeyCodes nativeKeyCodes;
    private int lastKeyCode;
    private Popup dropDownPopup;
    private Display display;
    private OffScreenRenderWidget dropDownRenderWidget;
    private Lazy<DragAndDropHelper> dragAndDropHelper;
    private Subscription doneTabbing;
    private Subscription cursorChanged;
    private Subscription tooltipChanged;
    private Subscription dropDownCreated;
    private Subscription dropDownDeleted;
    private Subscription browserClosing;
    private Subscription renderWidgetClosing;
    private DisplayWatcher displayWatcher;
    private boolean visible;

    OffScreenRenderWidget(RenderWidget renderWidget) {
        this.renderWidget = renderWidget;
        this.nativeKeyCodes = new NativeKeyCodes();
        this.focusListener = new FocusListener();
        this.resizeListener = new ResizeListener();
        this.keyListener = new KeyListener();
        this.mouseListener = new MouseListener();
        this.mouseWheelListener = new MouseWheelListener();
        this.windowMovedListener = new WindowMovedListener();
        this.windowIconifiedListener = new WindowIconifiedListener();
        EngineImpl engine = renderWidget.browser().engine();
        Path chromiumDir = engine.options().chromiumDir();
        AWTHelperLibrary awtHelperLibrary = AWTHelperLibrary.getInstance((File)chromiumDir.toFile());
        ToolkitLibrary toolkitLibrary = ToolkitLibrary.getInstance((Path)chromiumDir);
        this.display = Display.primaryDisplay((ToolkitLibrary)toolkitLibrary);
        if (!System.getProperties().containsKey("jxbrowser.display.watcher.off")) {
            this.displayWatcher = new DisplayWatcher(toolkitLibrary, awtHelperLibrary, this::onDisplayChanged);
        }
        this.dragAndDropHelper = new Lazy(() -> {
            if (!GraphicsEnvironment.isHeadless()) {
                return new DragAndDropHelper(this, toolkitLibrary, renderWidget, this.display);
            }
            return null;
        });
        this.setFocusable(true);
        this.setOpaque(false);
        this.setIgnoreRepaint(true);
        this.setFocusTraversalKeysEnabled(false);
        this.enableEvents(2088L);
    }

    final RenderWidget renderWidget() {
        return this.renderWidget;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.showRenderWidget();
    }

    @Override
    public void removeNotify() {
        this.hideRenderWidget();
        super.removeNotify();
    }

    boolean isShown() {
        return this.visible;
    }

    protected void close() {
        this.hideRenderWidget();
    }

    protected void showRenderWidget() {
        if (this.isShown()) {
            return;
        }
        this.updateMouseListeners();
        this.addWindowListeners();
        this.addKeyListener(this.keyListener);
        this.addFocusListener(this.focusListener);
        this.addComponentListener(this.resizeListener);
        this.renderWidget.show();
        this.cursorChanged = this.renderWidget.on(CursorChanged.class, event -> {
            try {
                Cursor cursor = SwingCursorUtil.getCursor(event);
                SwingUtilities.invokeLater(() -> this.setCursor(cursor));
            }
            catch (Exception e) {
                Logger.error((String)"Failed to change cursor", (Throwable)e);
            }
        });
        this.tooltipChanged = this.renderWidget.on(TooltipChanged.class, event -> SwingUtilities.invokeLater(() -> {
            String text = event.getTooltipText();
            if (text.isEmpty()) {
                this.setToolTipText(null);
            } else {
                this.setToolTipText(text);
            }
        }));
        this.dropDownCreated = this.renderWidget.on(DropDownCreated.class, event -> SwingUtilities.invokeLater(() -> {
            this.hideDropDown();
            this.createDropDown(event.getRenderWidgetId(), (Rect)event.getInitialBounds());
            this.showDropDown();
        }));
        this.dropDownDeleted = this.renderWidget.on(DropDownDeleted.class, event -> SwingUtilities.invokeLater(this::hideDropDown));
        this.doneTabbing = this.renderWidget.on(DoneTabbing.class, event -> SwingUtilities.invokeLater(() -> {
            KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (event.getReason() == DoneTabbing.Reason.DONE_TABBING_NEXT) {
                focusManager.focusNextComponent();
            } else {
                focusManager.focusPreviousComponent();
            }
        }));
        this.renderWidgetClosing = this.renderWidget.on(RenderWidgetClosing.class, event -> this.close());
        this.browserClosing = this.renderWidget.browser().on(BrowserClosing.class, event -> SwingUtil.execute(this::hideRenderWidget));
        if (this.isDragAndDropEnabled()) {
            ((DragAndDropHelper)this.dragAndDropHelper.get()).attach();
        }
        this.updateRenderWidgetBounds();
        this.visible = true;
    }

    protected void hideRenderWidget() {
        if (!this.isShown()) {
            return;
        }
        if (this.isDragAndDropEnabled()) {
            ((DragAndDropHelper)this.dragAndDropHelper.get()).detach();
        }
        if (this.renderWidgetClosing != null) {
            this.renderWidgetClosing.unsubscribe();
        }
        if (this.browserClosing != null) {
            this.browserClosing.unsubscribe();
        }
        if (this.cursorChanged != null) {
            this.cursorChanged.unsubscribe();
        }
        if (this.tooltipChanged != null) {
            this.tooltipChanged.unsubscribe();
        }
        if (this.dropDownCreated != null) {
            this.dropDownCreated.unsubscribe();
        }
        if (this.dropDownDeleted != null) {
            this.dropDownDeleted.unsubscribe();
        }
        if (this.doneTabbing != null) {
            this.doneTabbing.unsubscribe();
        }
        this.renderWidget.hide();
        this.removeKeyListener(this.keyListener);
        this.removeComponentListener(this.resizeListener);
        this.removeFocusListener(this.focusListener);
        this.removeWindowListeners();
        this.updateMouseListeners();
        this.visible = false;
    }

    private void showDropDown() {
        this.dropDownPopup.show();
    }

    private void createDropDown(RenderWidgetId renderWidgetId, Rect initialBounds) {
        Rect bounds = initialBounds;
        if (!Platform.getInstance().isDpiAware()) {
            bounds = GeometryUtil.scaleUp((Rect)initialBounds, (double)this.display.scaleFactor());
        }
        this.dropDownRenderWidget = new Graphics2dDropDownWidget(new RenderWidget(this.renderWidget.browser(), renderWidgetId));
        this.dropDownRenderWidget.setPreferredSize(SwingUtil.toDimension(bounds.size()));
        OffScreenRenderWidget owner = this;
        java.awt.Point locationOnScreen = owner.getLocationOnScreen();
        int x = locationOnScreen.x + bounds.origin().x();
        int y = locationOnScreen.y + bounds.origin().y();
        HeavyweightPopupFactory popupFactory = new HeavyweightPopupFactory();
        this.dropDownPopup = popupFactory.getPopup(owner, this.dropDownRenderWidget, x, y);
    }

    private void hideDropDown() {
        if (this.dropDownPopup != null) {
            this.dropDownRenderWidget.hideRenderWidget();
            this.dropDownPopup.hide();
            this.dropDownPopup = null;
        }
    }

    protected void addWindowListeners() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.addComponentListener(this.windowMovedListener);
            window.addWindowListener(this.windowIconifiedListener);
            if (this.displayWatcher != null) {
                this.displayWatcher.attach(window);
            }
        }
    }

    protected void removeWindowListeners() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.removeComponentListener(this.windowMovedListener);
            window.removeWindowListener(this.windowIconifiedListener);
            if (this.displayWatcher != null) {
                this.displayWatcher.detach(window);
            }
        }
    }

    private void updateMouseListeners() {
        if (this.isEnabled()) {
            this.addMouseListener(this.mouseListener);
            this.addMouseWheelListener(this.mouseWheelListener);
        } else {
            this.removeMouseListener(this.mouseListener);
            this.removeMouseWheelListener(this.mouseWheelListener);
        }
    }

    @Override
    public synchronized void addMouseListener(java.awt.event.MouseListener l) {
        if (!Arrays.asList(this.getMouseListeners()).contains(l)) {
            super.addMouseListener(l);
        }
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        if (!Arrays.asList(this.getMouseMotionListeners()).contains(l)) {
            super.addMouseMotionListener(l);
        }
    }

    @Override
    public synchronized void addMouseWheelListener(java.awt.event.MouseWheelListener l) {
        if (!Arrays.asList(this.getMouseWheelListeners()).contains(l)) {
            super.addMouseWheelListener(l);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateMouseListeners();
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.updateRenderWidgetBounds();
    }

    protected void updateRenderWidgetBounds() {
        Rectangle r = this.getBounds();
        if (r.width < 0 || r.height < 0) {
            return;
        }
        Rect bounds = GeometryUtil.makeRect((double)r.x, (double)r.y, (double)r.width, (double)r.height);
        if (!Platform.getInstance().isDpiAware()) {
            bounds = GeometryUtil.scaleDown((Rect)bounds, (double)this.display.scaleFactor());
        }
        this.renderWidget.bounds(bounds);
    }

    private void updateBoundsInScreen() {
        Rectangle rect = this.getBounds();
        if (rect.isEmpty()) {
            return;
        }
        java.awt.Point location = SwingUtil.getLocationOnScreen(this);
        Rect bounds = GeometryUtil.makeRect((double)location.x, (double)location.y, (double)rect.width, (double)rect.height);
        if (!Platform.getInstance().isDpiAware()) {
            bounds = GeometryUtil.scaleDown((Rect)bounds, (double)this.display.scaleFactor());
        }
        this.renderWidget.boundsInScreen(bounds);
        this.destroyDropDownWidget();
    }

    private void onDisplayChanged(Display display) {
        this.display = display;
        this.dragAndDropHelper.maybeGet().ifPresent(helper -> helper.onDisplayChanged(display));
        this.renderWidget.displayId(display.id());
    }

    private Point getScreenPoint(MouseEvent e) {
        java.awt.Point location = SwingUtil.getLocationOnScreen(e.getComponent());
        int x = e.getX();
        int y = e.getY();
        int globalX = location.x + x;
        int globalY = location.y + y;
        Point point = GeometryUtil.makePoint((double)globalX, (double)globalY);
        if (!Platform.getInstance().isDpiAware()) {
            return GeometryUtil.scaleDown((Point)point, (double)this.display.scaleFactor());
        }
        return point;
    }

    private Point getLocalPoint(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Point point = GeometryUtil.makePoint((double)x, (double)y);
        if (!Platform.getInstance().isDpiAware()) {
            return GeometryUtil.scaleDown((Point)point, (double)this.display.scaleFactor());
        }
        return point;
    }

    private void dispatchMouseDragged(MouseEvent e) {
        Optional<MouseButton> mouseButton = OffScreenRenderWidget.getMouseButton(e);
        if (!mouseButton.isPresent()) {
            return;
        }
        this.renderWidget.dispatch(MouseDragged.newBuilder((Point)this.getLocalPoint(e)).locationOnScreen(this.getScreenPoint(e)).button(mouseButton.get()).mouseModifiers(OffScreenRenderWidget.getMouseModifiers(e)).keyModifiers(OffScreenRenderWidget.getKeyModifiers(e)).build());
    }

    private static KeyModifiers getKeyModifiers(InputEvent e) {
        return KeyModifiers.newBuilder().altDown(OffScreenRenderWidget.isAltDown(e)).altGraphDown(OffScreenRenderWidget.isAltGraphDown(e)).shiftDown(OffScreenRenderWidget.isShiftDown(e)).controlDown(OffScreenRenderWidget.isControlDown(e)).metaDown(OffScreenRenderWidget.isMetaDown(e)).build();
    }

    private static KeyModifiers getKeyModifiers(MouseEvent e) {
        KeyModifiers.Builder builder = KeyModifiers.newBuilder().altDown(OffScreenRenderWidget.isAltDown(e)).altGraphDown(OffScreenRenderWidget.isAltGraphDown(e)).shiftDown(OffScreenRenderWidget.isShiftDown(e)).controlDown(OffScreenRenderWidget.isControlDown(e)).metaDown(OffScreenRenderWidget.isMetaDown(e));
        if (SwingUtilities.isRightMouseButton(e)) {
            builder.metaDown(false);
        }
        return builder.build();
    }

    private static MouseModifiers getMouseModifiers(MouseEvent e) {
        int modifiersEx = e.getModifiersEx();
        return MouseModifiers.newBuilder().primaryButtonDown((modifiersEx & 0x400) == 1024).middleButtonDown((modifiersEx & 0x800) == 2048).secondaryButtonDown((modifiersEx & 0x1000) == 4096).build();
    }

    private void dispatchMouseMoved(MouseEvent e) {
        this.renderWidget.dispatch(MouseMoved.newBuilder((Point)this.getLocalPoint(e)).locationOnScreen(this.getScreenPoint(e)).build());
    }

    private void destroyDropDownWidget() {
        if (this.dropDownRenderWidget != null) {
            this.dropDownRenderWidget.renderWidget.shutdownAndDestroy();
        }
    }

    static Optional<MouseButton> getMouseButton(MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event)) {
            return Optional.of(MouseButton.PRIMARY);
        }
        if (SwingUtilities.isMiddleMouseButton(event)) {
            return Optional.of(MouseButton.MIDDLE);
        }
        if (SwingUtilities.isRightMouseButton(event)) {
            return Optional.of(MouseButton.SECONDARY);
        }
        return Optional.empty();
    }

    private static boolean isShiftDown(InputEvent event) {
        return Environment.isJre8() ? (event.getModifiersEx() & 0x40) != 0 : event.isShiftDown();
    }

    private static boolean isControlDown(InputEvent event) {
        return Environment.isJre8() ? (event.getModifiersEx() & 0x80) != 0 : event.isControlDown();
    }

    private static boolean isMetaDown(InputEvent event) {
        return Environment.isJre8() ? (event.getModifiersEx() & 0x100) != 0 : event.isMetaDown();
    }

    private static boolean isAltDown(InputEvent event) {
        return Environment.isJre8() ? (event.getModifiersEx() & 0x200) != 0 : event.isAltDown();
    }

    private static boolean isAltGraphDown(InputEvent event) {
        return Environment.isJre8() ? (event.getModifiersEx() & 0x2000) != 0 : event.isAltGraphDown();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getID() == 503) {
            super.processMouseMotionEvent(e);
            this.dispatchMouseMoved(e);
            return;
        }
        if (e.getID() == 506) {
            if (this.isDragging()) {
                super.processMouseMotionEvent(e);
                return;
            }
            this.dispatchMouseDragged(e);
        }
    }

    private boolean isDragging() {
        return this.dragAndDropHelper.maybeGet().map(DragAndDropHelper::isDragging).orElse(false);
    }

    private void requestFocusIfNecessary() {
        if (!this.hasFocus()) {
            this.requestFocus();
        }
    }

    @Override
    public void enableDragAndDrop() {
        if (this.isDragAndDropEnabled()) {
            ((DragAndDropHelper)this.dragAndDropHelper.get()).attach();
        }
    }

    @Override
    public void disableDragAndDrop() {
        if (this.isDragAndDropEnabled()) {
            ((DragAndDropHelper)this.dragAndDropHelper.get()).detach();
        }
    }

    private boolean isDragAndDropEnabled() {
        return !GraphicsEnvironment.isHeadless() && this.renderWidget.browser().dragAndDrop().isEnabled();
    }

    private class WindowIconifiedListener
    extends WindowAdapter {
        private WindowIconifiedListener() {
        }

        @Override
        public void windowIconified(WindowEvent e) {
            OffScreenRenderWidget.this.renderWidget.minimize();
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            OffScreenRenderWidget.this.renderWidget.restore();
        }
    }

    private class WindowMovedListener
    extends ComponentAdapter {
        private WindowMovedListener() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            OffScreenRenderWidget.this.updateBoundsInScreen();
        }
    }

    private class FocusListener
    extends FocusAdapter {
        private FocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            OffScreenRenderWidget.this.renderWidget.focus();
        }

        @Override
        public void focusLost(FocusEvent e) {
            OffScreenRenderWidget.this.renderWidget.unfocus();
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            OffScreenRenderWidget.this.setBounds(OffScreenRenderWidget.this.getBounds());
        }
    }

    private class KeyListener
    extends KeyAdapter {
        private KeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            OffScreenRenderWidget.this.renderWidget.dispatch(KeyTyped.newBuilder((KeyCode)OffScreenRenderWidget.this.nativeKeyCodes.toVirtualKeyCode(OffScreenRenderWidget.this.lastKeyCode != 0 ? OffScreenRenderWidget.this.lastKeyCode : e.getKeyCode(), e.getKeyLocation())).keyChar(e.getKeyChar()).keyModifiers(OffScreenRenderWidget.getKeyModifiers(e)).build());
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.suppressTraversalKey(e);
            KeyCode keyCode = OffScreenRenderWidget.this.nativeKeyCodes.toVirtualKeyCode(e.getKeyCode(), e.getKeyLocation());
            if (keyCode == null && e.getKeyCode() == 10) {
                keyCode = KeyCode.KEY_CODE_RETURN;
            }
            if (keyCode == null) {
                throw new IllegalStateException("Unsupported key code: " + e.getKeyCode());
            }
            OffScreenRenderWidget.this.lastKeyCode = e.getKeyCode();
            KeyPressed.Builder builder = KeyPressed.newBuilder((KeyCode)keyCode).keyModifiers(OffScreenRenderWidget.getKeyModifiers(e));
            char keyChar = e.getKeyChar();
            if (keyChar != '\uffff') {
                builder.keyChar(e.getKeyChar());
            }
            OffScreenRenderWidget.this.renderWidget.dispatch(builder.build());
        }

        private void suppressTraversalKey(KeyEvent event) {
            if (event.getKeyChar() == '\t') {
                event.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            KeyCode keyCode = OffScreenRenderWidget.this.nativeKeyCodes.toVirtualKeyCode(e.getKeyCode(), e.getKeyLocation());
            if (keyCode == null && e.getKeyCode() == 10) {
                keyCode = KeyCode.KEY_CODE_RETURN;
            }
            if (keyCode == null) {
                throw new IllegalStateException("Unsupported key code: " + e.getKeyCode());
            }
            OffScreenRenderWidget.this.lastKeyCode = 0;
            OffScreenRenderWidget.this.renderWidget.dispatch(KeyReleased.newBuilder((KeyCode)keyCode).keyModifiers(OffScreenRenderWidget.getKeyModifiers(e)).build());
        }
    }

    private class MouseWheelListener
    extends MouseAdapter {
        private MouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!OffScreenRenderWidget.this.isEnabled()) {
                return;
            }
            int directionFix = -1;
            ScrollType scrollType = ScrollType.forNumber((int)e.getScrollType());
            if (scrollType == null) {
                scrollType = ScrollType.SCROLL_TYPE_UNSPECIFIED;
            }
            float pointsPerUnit = Environment.isMac() ? 10.0f : 33.333332f;
            float delta = (float)e.getUnitsToScroll() * pointsPerUnit * (float)directionFix;
            float deltaX = e.isShiftDown() ? delta : 0.0f;
            float deltaY = !e.isShiftDown() ? delta : 0.0f;
            OffScreenRenderWidget.this.renderWidget.dispatch(MouseWheel.newBuilder((Point)OffScreenRenderWidget.this.getLocalPoint(e)).locationOnScreen(OffScreenRenderWidget.this.getScreenPoint(e)).deltaX(deltaX).deltaY(deltaY).keyModifiers(OffScreenRenderWidget.getKeyModifiers(e)).scrollType(scrollType).build());
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Optional<MouseButton> mouseButton = OffScreenRenderWidget.getMouseButton(e);
            if (!OffScreenRenderWidget.this.isEnabled() || !mouseButton.isPresent()) {
                return;
            }
            OffScreenRenderWidget.this.renderWidget.dispatch(MouseEntered.newBuilder((Point)OffScreenRenderWidget.this.getLocalPoint(e)).button(mouseButton.get()).locationOnScreen(OffScreenRenderWidget.this.getScreenPoint(e)).mouseModifiers(OffScreenRenderWidget.getMouseModifiers(e)).keyModifiers(OffScreenRenderWidget.getKeyModifiers(e)).build());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Optional<MouseButton> mouseButton = OffScreenRenderWidget.getMouseButton(e);
            if (!OffScreenRenderWidget.this.isEnabled() || !mouseButton.isPresent()) {
                return;
            }
            OffScreenRenderWidget.this.renderWidget.dispatch(MouseExited.newBuilder((Point)OffScreenRenderWidget.this.getLocalPoint(e)).button(mouseButton.get()).locationOnScreen(OffScreenRenderWidget.this.getScreenPoint(e)).mouseModifiers(OffScreenRenderWidget.getMouseModifiers(e)).keyModifiers(OffScreenRenderWidget.getKeyModifiers(e)).build());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Optional<MouseButton> mouseButton = OffScreenRenderWidget.getMouseButton(e);
            if (!OffScreenRenderWidget.this.isEnabled() || !mouseButton.isPresent()) {
                return;
            }
            OffScreenRenderWidget.this.requestFocusIfNecessary();
            OffScreenRenderWidget.this.renderWidget.dispatch(MousePressed.newBuilder((Point)OffScreenRenderWidget.this.getLocalPoint(e)).button(mouseButton.get()).locationOnScreen(OffScreenRenderWidget.this.getScreenPoint(e)).clickCount(e.getClickCount()).mouseModifiers(OffScreenRenderWidget.getMouseModifiers(e)).keyModifiers(OffScreenRenderWidget.getKeyModifiers(e)).build());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Optional<MouseButton> mouseButton = OffScreenRenderWidget.getMouseButton(e);
            if (!OffScreenRenderWidget.this.isEnabled() || !mouseButton.isPresent()) {
                return;
            }
            OffScreenRenderWidget.this.renderWidget.dispatch(MouseReleased.newBuilder((Point)OffScreenRenderWidget.this.getLocalPoint(e)).button(mouseButton.get()).locationOnScreen(OffScreenRenderWidget.this.getScreenPoint(e)).clickCount(e.getClickCount()).mouseModifiers(OffScreenRenderWidget.getMouseModifiers(e)).keyModifiers(OffScreenRenderWidget.getKeyModifiers(e)).build());
        }
    }
}

