/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.RenderWidget;
import com.teamdev.jxbrowser.browser.internal.RenderWidgets;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogRenderWidgetChanged;
import com.teamdev.jxbrowser.browser.internal.rpc.DialogRenderWidgetDeleted;
import com.teamdev.jxbrowser.browser.internal.rpc.FullScreenRenderWidgetCreated;
import com.teamdev.jxbrowser.browser.internal.rpc.FullScreenRenderWidgetDeleted;
import com.teamdev.jxbrowser.browser.internal.rpc.RenderWidgetChanged;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.rpc.RenderWidgetId;
import com.teamdev.jxbrowser.view.swing.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swing.internal.Widget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

abstract class OffScreenBrowserWidget
extends JComponent
implements Widget {
    private final HierarchyListener hierarchyListener = new HierarchyListenerImpl();
    private OffScreenRenderWidget widget;
    private OffScreenRenderWidget dialogWidget;
    private OffScreenRenderWidget fullScreenWidget;
    private OffScreenRenderWidget currentWidget;
    private Subscription onDialogRenderWidgetChanged;
    private Subscription onRenderWidgetChanged;
    private Subscription onDialogRenderWidgetDeleted;
    private Subscription onFullScreenRenderWidgetCreated;
    private Subscription onFullScreenRenderWidgetDeleted;
    private Subscription onBrowserClosed;

    OffScreenBrowserWidget(BrowserImpl browser) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        RenderWidgets renderWidgets = browser.renderWidgets();
        renderWidgets.activeRenderWidget().ifPresent(renderWidget -> this.showComponent(browser, renderWidget.id(), component -> {
            this.widget = component;
        }));
        this.subscribeRenderWidgetsObservers(browser);
        this.onBrowserClosed = browser.on(BrowserClosed.class, event -> {
            this.unsubscribeRenderWidgetsObservers();
            this.onBrowserClosed.unsubscribe();
        });
    }

    private void subscribeRenderWidgetsObservers(BrowserImpl browser) {
        RenderWidgets renderWidgets = browser.renderWidgets();
        this.onRenderWidgetChanged = renderWidgets.on(RenderWidgetChanged.class, event -> this.showComponent(browser, event.getNewRenderWidgetId(), component -> {
            if (this.widget != null) {
                this.widget.close();
            }
            this.widget = component;
        }));
        this.onDialogRenderWidgetChanged = renderWidgets.on(DialogRenderWidgetChanged.class, event -> this.showComponent(browser, event.getNewRenderWidgetId(), component -> {
            this.dialogWidget = component;
        }));
        this.onDialogRenderWidgetDeleted = renderWidgets.on(DialogRenderWidgetDeleted.class, event -> {
            this.hideComponent(this.dialogWidget);
            this.dialogWidget.close();
        });
        this.onFullScreenRenderWidgetCreated = renderWidgets.on(FullScreenRenderWidgetCreated.class, event -> this.showComponent(browser, event.getRenderWidgetId(), component -> {
            this.fullScreenWidget = component;
        }));
        this.onFullScreenRenderWidgetDeleted = renderWidgets.on(FullScreenRenderWidgetDeleted.class, event -> {
            this.hideComponent(this.fullScreenWidget);
            this.fullScreenWidget.close();
        });
    }

    private void unsubscribeRenderWidgetsObservers() {
        this.onRenderWidgetChanged.unsubscribe();
        this.onDialogRenderWidgetChanged.unsubscribe();
        this.onDialogRenderWidgetDeleted.unsubscribe();
        this.onFullScreenRenderWidgetCreated.unsubscribe();
        this.onFullScreenRenderWidgetDeleted.unsubscribe();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this.hierarchyListener);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this.hierarchyListener);
        super.removeNotify();
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.canRequestFocus(this.currentWidget)) {
            this.currentWidget.requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        if (this.canRequestFocus(this.currentWidget)) {
            return this.currentWidget.requestFocus(temporary);
        }
        return super.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.canRequestFocus(this.currentWidget)) {
            return this.currentWidget.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    private boolean canRequestFocus(JComponent component) {
        return component != null && component.isShowing() && component.isDisplayable();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.currentWidget != null) {
            this.currentWidget.setEnabled(enabled);
        }
    }

    private void showComponent(BrowserImpl browser, RenderWidgetId renderWidgetId, Consumer<OffScreenRenderWidget> componentConsumer) {
        SwingUtilities.invokeLater(() -> {
            this.removeAll();
            browser.renderWidgets().renderWidget(renderWidgetId).ifPresent(renderWidget -> {
                OffScreenRenderWidget offScreenRenderWidget = this.createRenderWidget((RenderWidget)renderWidget);
                if (!this.isDisplayable() || this.isShowing()) {
                    this.add((Component)offScreenRenderWidget, "Center");
                }
                componentConsumer.accept(offScreenRenderWidget);
                this.currentWidget = offScreenRenderWidget;
                this.currentWidget.setEnabled(this.isEnabled());
            });
            this.validate();
            this.repaint();
        });
    }

    private void hideComponent(JComponent component) {
        SwingUtilities.invokeLater(() -> {
            this.remove(component);
            this.currentWidget = this.widget;
            this.add((Component)this.widget, "Center");
            this.validate();
            this.repaint();
        });
    }

    @Override
    public void enableDragAndDrop() {
        if (this.currentWidget != null) {
            this.currentWidget.enableDragAndDrop();
        }
    }

    @Override
    public void disableDragAndDrop() {
        if (this.currentWidget != null) {
            this.currentWidget.disableDragAndDrop();
        }
    }

    abstract OffScreenRenderWidget createRenderWidget(RenderWidget var1);

    private final class HierarchyListenerImpl
    implements HierarchyListener {
        private HierarchyListenerImpl() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (OffScreenBrowserWidget.this.currentWidget == null) {
                return;
            }
            long flags = e.getChangeFlags();
            if (flags == 4L || flags == 1L) {
                this.relayoutComponent(OffScreenBrowserWidget.this.currentWidget);
            }
        }

        private void relayoutComponent(JComponent component) {
            if (OffScreenBrowserWidget.this.isShowing()) {
                if (!component.isShowing()) {
                    OffScreenBrowserWidget.this.add((Component)component, "Center");
                }
            } else {
                OffScreenBrowserWidget.this.remove(component);
            }
            OffScreenBrowserWidget.this.validate();
            OffScreenBrowserWidget.this.repaint();
        }
    }
}

