/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.internal.RenderWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.SurfaceUpdated;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.view.swing.internal.IoSurface;
import com.teamdev.jxbrowser.view.swing.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swing.internal.SwingUtil;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.nio.file.Path;
import javax.swing.SwingUtilities;

public final class IoSurfaceRenderWidget
extends OffScreenRenderWidget {
    private final IoSurface ioSurface;
    private final ResizeListener resizeListener;
    private Subscription surfaceUpdated;

    IoSurfaceRenderWidget(RenderWidget renderWidget) {
        super(renderWidget);
        EngineImpl engine = renderWidget.browser().engine();
        EngineOptions engineOptions = engine.options();
        Path chromiumDir = engineOptions.chromiumDir();
        this.ioSurface = new IoSurface(chromiumDir);
        this.resizeListener = new ResizeListener();
    }

    @Override
    public void close() {
        super.close();
        this.ioSurface.close();
    }

    @Override
    protected void showRenderWidget() {
        if (this.isShown()) {
            return;
        }
        super.showRenderWidget();
        this.surfaceUpdated = this.renderWidget().on(SurfaceUpdated.class, event -> this.ioSurface.updateSurface(event.getServiceName()));
        this.ioSurface.show(SwingUtilities.getWindowAncestor(this), this.getComponentBounds());
        this.addComponentListener(this.resizeListener);
    }

    @Override
    protected void hideRenderWidget() {
        if (!this.isShown()) {
            return;
        }
        if (this.surfaceUpdated != null) {
            this.surfaceUpdated.unsubscribe();
        }
        this.removeComponentListener(this.resizeListener);
        this.ioSurface.hide();
        super.hideRenderWidget();
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.ioSurface.setBounds(this.getComponentBounds());
    }

    private Rectangle getComponentBounds() {
        Rectangle bounds = this.getBounds();
        bounds.setLocation(SwingUtil.getLocationInWindow(this));
        return bounds;
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            IoSurfaceRenderWidget.this.ioSurface.setBounds(IoSurfaceRenderWidget.this.getComponentBounds());
        }
    }
}

