/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.internal.AWTHelperLibrary;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.File;
import java.nio.file.Path;

class IoSurface {
    private final AWTHelperLibrary awtHelper;
    private final ToolkitLibrary toolkit;
    private final long nsViewId;
    private String serviceName = "";
    private boolean visible;

    IoSurface(Path chromiumDir) {
        this.awtHelper = AWTHelperLibrary.getInstance((File)chromiumDir.toFile());
        this.toolkit = ToolkitLibrary.getInstance((Path)chromiumDir);
        this.nsViewId = this.toolkit.createNsView(0, 0, 1, 1);
    }

    void close() {
        this.toolkit.deleteNsView(this.nsViewId);
        this.toolkit.deleteMachService(this.serviceName);
    }

    void show(Window window, Rectangle bounds) {
        if (this.visible) {
            return;
        }
        if (window != null) {
            this.toolkit.showNsView(this.awtHelper.getWindowHandle(window), this.nsViewId);
            this.toolkit.setNsViewBounds(this.nsViewId, bounds.x, bounds.y, bounds.width, bounds.height);
            this.visible = true;
        }
    }

    void hide() {
        if (!this.visible) {
            return;
        }
        this.toolkit.hideNsView(this.nsViewId);
        this.visible = false;
    }

    void setBounds(Rectangle bounds) {
        if (!this.visible) {
            return;
        }
        this.toolkit.setNsViewBounds(this.nsViewId, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    void updateSurface(String serviceName) {
        if (!this.visible) {
            return;
        }
        this.updateMachService(serviceName);
        this.toolkit.setNsViewSurface(this.nsViewId, serviceName);
    }

    private void updateMachService(String newServiceName) {
        if (this.serviceName.equals(newServiceName)) {
            return;
        }
        if (!this.serviceName.isEmpty()) {
            this.toolkit.deleteMachService(this.serviceName);
        }
        this.toolkit.createMachService(newServiceName);
        this.serviceName = newServiceName;
    }
}

