/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.event.BrowserClosing;
import com.teamdev.jxbrowser.browser.event.FocusGained;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.browser.internal.WindowedWidget;
import com.teamdev.jxbrowser.browser.internal.rpc.WindowedDoneTabbing;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.AWTHelperLibrary;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.internal.util.GeometryUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.view.swing.internal.DisplayWatcher;
import com.teamdev.jxbrowser.view.swing.internal.Platform;
import com.teamdev.jxbrowser.view.swing.internal.SwingUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import sun.awt.AWTAccessor;

public final class HeavyweightWidget
extends JComponent {
    private static final List<HeavyweightWidget> heavyweightWidgets = Collections.synchronizedList(new ArrayList());
    private final BrowserImpl browser;
    private final WindowedWidget widget;
    private final ResizeListener resizeListener;
    private final AWTHelperLibrary awtHelperLibrary;
    private final HierarchyListener hierarchyListener;
    private final HierarchyBoundsListener hierarchyBoundsListener;
    private final ComponentListener windowMovedListener;
    private final WindowListener windowIconifiedListener;
    private final ComponentFocusListener componentFocusListener;
    private final AWTEventListener globalFocusListener;
    private final AWTEventListener globalFocusListenerWin;
    private final DisplayWatcher displayWatcher;
    private final Subscription browserClosing;
    private boolean closed;
    private Display display;
    private Subscription focusGained;
    private Subscription windowedDoneTabbing;

    HeavyweightWidget(BrowserImpl browser) {
        Preconditions.checkNotNull((Object)browser);
        this.browser = browser;
        EngineImpl engine = browser.engine();
        EngineOptions engineOptions = engine.options();
        Path chromiumDir = engineOptions.chromiumDir();
        this.awtHelperLibrary = AWTHelperLibrary.getInstance((File)chromiumDir.toFile());
        ToolkitLibrary toolkitLibrary = ToolkitLibrary.getInstance((Path)chromiumDir);
        this.widget = new WindowedWidget(browser);
        this.resizeListener = new ResizeListener();
        this.hierarchyListener = new HierarchyListenerImpl();
        this.hierarchyBoundsListener = new HierarchyBoundsListenerImpl();
        this.windowMovedListener = new WindowMovedListener();
        this.windowIconifiedListener = new WindowIconifiedListener();
        this.componentFocusListener = new ComponentFocusListener();
        this.globalFocusListener = new GlobalFocusListener();
        this.globalFocusListenerWin = new GlobalFocusListenerWin();
        this.display = Display.primaryDisplay((ToolkitLibrary)toolkitLibrary);
        this.displayWatcher = new DisplayWatcher(toolkitLibrary, this.awtHelperLibrary, this::onDisplayChanged);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.globalFocusListener, 4L);
        if (Environment.isWindows()) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.globalFocusListenerWin, 524288L);
        }
        this.setFocusable(true);
        this.browserClosing = browser.on(BrowserClosing.class, event -> SwingUtil.execute(this::close));
    }

    private void close() {
        this.removeComponentListeners();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.globalFocusListener);
        if (Environment.isWindows()) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.globalFocusListenerWin);
        }
        this.widget.close();
        heavyweightWidgets.remove(this);
        this.browserClosing.unsubscribe();
        this.closed = true;
    }

    private boolean isClosed() {
        return this.closed;
    }

    private void focus() {
        this.widget.focus();
    }

    private void unfocus() {
        this.widget.unfocus();
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.setShowing(aFlag);
    }

    private void addComponentListeners() {
        this.addHierarchyListener(this.hierarchyListener);
        this.addHierarchyBoundsListener(this.hierarchyBoundsListener);
        this.addComponentListener(this.resizeListener);
        this.addFocusListener(this.componentFocusListener);
        this.addWindowListeners();
        this.focusGained = this.browser.on(FocusGained.class, event -> {
            if (Environment.isWindows()) {
                for (HeavyweightWidget widget : heavyweightWidgets) {
                    if (widget.equals(this)) continue;
                    widget.unfocus();
                }
                SwingUtilities.invokeLater(() -> {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                    HeavyweightWidget.setMostRecentFocusOwner(this);
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                });
            }
        });
        this.windowedDoneTabbing = this.widget.on(WindowedDoneTabbing.class, event -> SwingUtilities.invokeLater(() -> {
            Window window;
            if (Environment.isLinux() && (window = SwingUtilities.getWindowAncestor(this)) != null) {
                this.componentFocusListener.ignoreNextFocusEvent();
                window.toFront();
            }
            if (event.getReason() == WindowedDoneTabbing.Reason.DONE_TABBING_PREV) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(this);
            } else {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
            }
        }));
    }

    private void removeComponentListeners() {
        if (this.focusGained != null) {
            this.focusGained.unsubscribe();
        }
        if (this.windowedDoneTabbing != null) {
            this.windowedDoneTabbing.unsubscribe();
        }
        this.removeComponentListener(this.resizeListener);
        this.removeHierarchyListener(this.hierarchyListener);
        this.removeHierarchyBoundsListener(this.hierarchyBoundsListener);
        this.removeFocusListener(this.componentFocusListener);
        this.removeWindowListeners();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.isClosed()) {
            this.addComponentListeners();
            this.setShowing(this.isShowing());
        }
    }

    private void setShowing(boolean showing) {
        if (showing) {
            this.attachWidget();
            heavyweightWidgets.add(this);
        } else {
            this.detachWidget();
            heavyweightWidgets.remove(this);
        }
    }

    @Override
    public void removeNotify() {
        if (!this.isClosed()) {
            this.setShowing(false);
            this.removeComponentListeners();
        }
        super.removeNotify();
    }

    private void addWindowListeners() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.addComponentListener(this.windowMovedListener);
            window.addWindowListener(this.windowIconifiedListener);
            this.displayWatcher.attach(window);
        }
    }

    private void removeWindowListeners() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.removeComponentListener(this.windowMovedListener);
            window.removeWindowListener(this.windowIconifiedListener);
            this.displayWatcher.detach(window);
        }
    }

    private static void setMostRecentFocusOwner(Component focusOwner) {
        Component component;
        for (component = focusOwner; component != null && !(component instanceof Window); component = component.getParent()) {
        }
        if (component == null) {
            return;
        }
        Window window = (Window)component;
        AWTAccessor.KeyboardFocusManagerAccessor keyboardFocusManagerAccessor = AWTAccessor.getKeyboardFocusManagerAccessor();
        keyboardFocusManagerAccessor.setMostRecentFocusOwner(window, focusOwner);
    }

    private void updateBounds() {
        Rectangle rect = this.getBounds();
        if (rect.width < 0 || rect.height < 0) {
            return;
        }
        Point locationInWindow = SwingUtil.getLocationInWindow(this);
        rect.setLocation(locationInWindow);
        Rect bounds = GeometryUtil.makeRect((double)rect.x, (double)rect.y, (double)rect.width, (double)rect.height);
        if (!Platform.getInstance().isDpiAware()) {
            bounds = GeometryUtil.scaleDown((Rect)bounds, (double)this.display.scaleFactor());
        }
        this.widget.bounds(bounds);
    }

    private void updateBoundsInScreen() {
        Rectangle rect = this.getBounds();
        if (rect.isEmpty()) {
            return;
        }
        Point location = SwingUtil.getLocationOnScreen(this);
        Rect bounds = GeometryUtil.makeRect((double)location.x, (double)location.y, (double)rect.width, (double)rect.height);
        if (!Platform.getInstance().isDpiAware()) {
            bounds = GeometryUtil.scaleDown((Rect)bounds, (double)this.display.scaleFactor());
        }
        this.widget.boundsOnScreen(bounds);
    }

    private void attachWidget() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            this.widget.attach(this.awtHelperLibrary.getWindowHandle(window));
            this.updateBounds();
        }
    }

    private void detachWidget() {
        this.widget.detach();
    }

    private void onDisplayChanged(Display display) {
        this.display = display;
        this.widget.displayId(display.id());
        this.updateBounds();
    }

    private final class HierarchyBoundsListenerImpl
    implements HierarchyBoundsListener {
        private HierarchyBoundsListenerImpl() {
        }

        @Override
        public void ancestorMoved(HierarchyEvent e) {
            this.updateBoundsIfNecessary();
        }

        private void updateBoundsIfNecessary() {
            if (HeavyweightWidget.this.isShowing()) {
                HeavyweightWidget.this.updateBounds();
                HeavyweightWidget.this.revalidate();
            }
        }

        @Override
        public void ancestorResized(HierarchyEvent e) {
            this.updateBoundsIfNecessary();
        }
    }

    private class HierarchyListenerImpl
    implements HierarchyListener {
        private HierarchyListenerImpl() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getChangeFlags() == 1L || e.getChangeFlags() == 4L) {
                Component topLevelContainer = e.getChanged();
                HeavyweightWidget.this.setShowing(topLevelContainer.isShowing() && HeavyweightWidget.this.isShowing());
            }
        }
    }

    private class GlobalFocusListenerWin
    implements AWTEventListener {
        private GlobalFocusListenerWin() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            Window topLevelWindow;
            Window window;
            boolean isFocusLost = event.getID() == 208;
            Object source = event.getSource();
            if (source instanceof Window && isFocusLost && (window = (Window)source).equals(topLevelWindow = SwingUtilities.getWindowAncestor(HeavyweightWidget.this))) {
                HeavyweightWidget.this.unfocus();
            }
        }
    }

    private class GlobalFocusListener
    implements AWTEventListener {
        private GlobalFocusListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            boolean isFocusGained = event.getID() == 1004;
            boolean isHeavyweightWidget = HeavyweightWidget.this.equals(event.getSource());
            if (isFocusGained && !isHeavyweightWidget) {
                HeavyweightWidget.this.unfocus();
            }
        }
    }

    private class WindowIconifiedListener
    extends WindowAdapter {
        private WindowIconifiedListener() {
        }

        @Override
        public void windowIconified(WindowEvent e) {
            HeavyweightWidget.this.widget.minimize();
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            HeavyweightWidget.this.widget.restore();
        }
    }

    private class WindowMovedListener
    extends ComponentAdapter {
        private WindowMovedListener() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            HeavyweightWidget.this.updateBoundsInScreen();
        }
    }

    private class ComponentFocusListener
    extends FocusAdapter {
        private boolean ignoreNextFocusEvent;

        private ComponentFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.ignoreNextFocusEvent) {
                this.ignoreNextFocusEvent = false;
                return;
            }
            HeavyweightWidget.this.focus();
        }

        void ignoreNextFocusEvent() {
            this.ignoreNextFocusEvent = true;
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            HeavyweightWidget.this.updateBoundsInScreen();
            HeavyweightWidget.this.updateBounds();
        }
    }
}

