/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.browser.internal.RenderWidget;
import com.teamdev.jxbrowser.browser.internal.callback.PaintCallback;
import com.teamdev.jxbrowser.browser.internal.callback.RenderWidgetCallback;
import com.teamdev.jxbrowser.browser.internal.rpc.Paint;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.os.internal.rpc.Memory;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.ui.internal.rpc.Rect;
import com.teamdev.jxbrowser.view.swing.internal.OffScreenRenderWidget;
import com.teamdev.jxbrowser.view.swing.internal.Platform;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.MemoryImageSource;
import java.nio.file.Path;

public class Graphics2dRenderWidget
extends OffScreenRenderWidget {
    private static final int COLOR_SPACE = 4;
    private final ToolkitLibrary toolkitLibrary;
    private int width;
    private int height;
    private Image image;
    private int[] pixels;
    private boolean repaintRequired;
    private double deviceScaleFactor;
    private MemoryImageSource source;

    Graphics2dRenderWidget(RenderWidget renderWidget) {
        super(renderWidget);
        this.initializeImage(Size.of((int)1, (int)1));
        EngineImpl engine = renderWidget.browser().engine();
        this.toolkitLibrary = ToolkitLibrary.getInstance((Path)engine.options().chromiumDir());
    }

    @Override
    protected void showRenderWidget() {
        if (this.isShown()) {
            return;
        }
        super.showRenderWidget();
        this.renderWidget().set(PaintCallback.class, (RenderWidgetCallback)((PaintCallback)params -> {
            Graphics2dRenderWidget graphics2dRenderWidget = this;
            synchronized (graphics2dRenderWidget) {
                com.teamdev.jxbrowser.ui.internal.rpc.Size viewSize = params.getViewSize();
                Rect dirtyRect = params.getDirtyRect();
                if (!Graphics2dRenderWidget.validateDirtyRect((com.teamdev.jxbrowser.ui.Rect)dirtyRect, (Size)viewSize)) {
                    return Paint.Response.newBuilder().build();
                }
                this.initializeImage((Size)viewSize);
                Point dirtyRectOrigin = dirtyRect.origin();
                Size dirtyRectSize = dirtyRect.size();
                Memory memory = params.getMemory();
                if (Environment.isWindows()) {
                    this.toolkitLibrary.updatePixels((long)params.getPid().getValue(), memory.getHandle(), (int)memory.getSize(), dirtyRectOrigin.x(), dirtyRectOrigin.y(), dirtyRectSize.width(), dirtyRectSize.height(), 4, viewSize.width(), viewSize.height(), this.pixels);
                } else {
                    this.toolkitLibrary.updatePixels(memory.getFile(), (int)memory.getSize(), dirtyRectOrigin.x(), dirtyRectOrigin.y(), dirtyRectSize.width(), dirtyRectSize.height(), 4, viewSize.width(), viewSize.height(), this.pixels);
                }
                this.updateImageAndRepaint((com.teamdev.jxbrowser.ui.Rect)dirtyRect, params.getScaleFactor());
            }
            return Paint.Response.newBuilder().build();
        }));
    }

    @Override
    protected void hideRenderWidget() {
        if (!this.isShown()) {
            return;
        }
        this.renderWidget().remove(PaintCallback.class);
        super.hideRenderWidget();
    }

    private void initializeImage(Size clientSize) {
        if (this.width != clientSize.width() || this.height != clientSize.height()) {
            this.width = clientSize.width();
            this.height = clientSize.height();
            int size = this.width * this.height;
            this.pixels = new int[size];
            this.source = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
            this.source.setAnimated(true);
            this.image = this.createImage(this.source);
            this.repaintRequired = true;
        }
    }

    private void updateImageAndRepaint(com.teamdev.jxbrowser.ui.Rect dirtyRect, double scaleFactor) {
        if (this.source != null) {
            int x = dirtyRect.origin().x();
            int y = dirtyRect.origin().y();
            int width = dirtyRect.size().width();
            int height = dirtyRect.size().height();
            this.source.newPixels(x, y, width, height);
            this.deviceScaleFactor = scaleFactor;
            if (this.repaintRequired) {
                Rectangle dirtyArea = new Rectangle((int)((double)x / scaleFactor), (int)((double)y / scaleFactor), (int)((double)width / scaleFactor), (int)((double)height / scaleFactor));
                this.repaint(dirtyArea);
                this.repaintRequired = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (Platform.getInstance().isDpiAware()) {
            double scale = 1.0 / this.deviceScaleFactor;
            g2d.scale(scale, scale);
        }
        Graphics2dRenderWidget graphics2dRenderWidget = this;
        synchronized (graphics2dRenderWidget) {
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this);
            }
        }
    }

    private static boolean validateDirtyRect(com.teamdev.jxbrowser.ui.Rect dirtyRect, Size viewSize) {
        int viewWidth = viewSize.width();
        int viewHeight = viewSize.height();
        Point dirtyRectOrigin = dirtyRect.origin();
        Size dirtyRectSize = dirtyRect.size();
        return dirtyRectOrigin.x() <= viewWidth && dirtyRectOrigin.y() <= viewHeight && dirtyRectOrigin.x() + dirtyRectSize.width() <= viewWidth && dirtyRectOrigin.y() + dirtyRectSize.height() <= viewHeight;
    }
}

