/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.internal;

import com.teamdev.jxbrowser.internal.AWTHelperLibrary;
import com.teamdev.jxbrowser.internal.Display;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

final class DisplayWatcher {
    private final WindowListener windowListener;
    private final Observer observer;
    private final ToolkitLibrary toolkitLibrary;
    private final AWTHelperLibrary awtHelperLibrary;
    private Display display;
    private long windowHandle;

    DisplayWatcher(ToolkitLibrary toolkitLibrary, AWTHelperLibrary awtHelperLibrary, Observer observer) {
        this.toolkitLibrary = toolkitLibrary;
        this.awtHelperLibrary = awtHelperLibrary;
        this.observer = observer;
        this.windowListener = new WindowListener();
    }

    private void updateDisplay() {
        String displayId = this.toolkitLibrary.getDisplayIdForWindow(this.windowHandle);
        if (this.isDisplayChanged(displayId)) {
            this.display = new Display(displayId, this.getScaleFactor(displayId));
            this.observer.onDisplayChanged(this.display);
        }
    }

    private boolean isDisplayChanged(String newDisplayId) {
        return this.display == null || !this.display.id().equals(newDisplayId);
    }

    void attach(Window window) {
        if (Environment.isLinux()) {
            return;
        }
        if (window != null) {
            window.addComponentListener(this.windowListener);
            this.windowHandle = this.awtHelperLibrary.getWindowHandle(window);
            this.updateDisplay();
        }
    }

    void detach(Window window) {
        if (Environment.isLinux()) {
            return;
        }
        if (window != null) {
            window.removeComponentListener(this.windowListener);
        }
    }

    private double getScaleFactor(String displayId) {
        String property = System.getProperty("jxbrowser.force.device.scale.factor");
        if (property != null) {
            try {
                return Double.parseDouble(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.toolkitLibrary.getScaleFactorForDisplay(displayId);
    }

    private class WindowListener
    extends ComponentAdapter {
        private WindowListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            DisplayWatcher.this.updateDisplay();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            DisplayWatcher.this.updateDisplay();
        }
    }

    public static interface Observer {
        public void onDisplayChanged(Display var1);
    }
}

