/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.callback;

import com.teamdev.jxbrowser.download.callback.StartDownloadCallback;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.view.swing.callback.AbstractDialogCallback;
import java.awt.FileDialog;
import java.awt.Frame;
import java.nio.file.Paths;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class DefaultStartDownloadCallback
extends AbstractDialogCallback
implements StartDownloadCallback {
    public DefaultStartDownloadCallback(JComponent parent) {
        super(parent);
        Preconditions.checkNotNull((Object)parent);
    }

    public void on(StartDownloadCallback.Params params, StartDownloadCallback.Action tell) {
        SwingUtilities.invokeLater(() -> {
            Frame frame = (Frame)SwingUtilities.getWindowAncestor(this.getParent());
            FileDialog fileDialog = new FileDialog(frame, "", 1);
            fileDialog.setModal(true);
            fileDialog.setFile(params.download().target().suggestedFileName());
            fileDialog.setMultipleMode(false);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null || fileDialog.getDirectory() == null) {
                tell.cancel();
            } else {
                tell.download(Paths.get(fileDialog.getDirectory(), fileDialog.getFile()));
            }
        });
    }
}

