/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.callback;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.OpenPopupCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.browser.event.UpdateBoundsRequested;
import com.teamdev.jxbrowser.internal.util.GeometryUtil;
import com.teamdev.jxbrowser.ui.Rect;
import com.teamdev.jxbrowser.ui.Size;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import com.teamdev.jxbrowser.view.swing.internal.SwingUtil;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class DefaultOpenPopupCallback
implements OpenPopupCallback {
    private static final int DEFAULT_POPUP_WIDTH = 800;
    private static final int DEFAULT_POPUP_HEIGHT = 600;

    public OpenPopupCallback.Response on(OpenPopupCallback.Params params) {
        final Browser browser = params.popupBrowser();
        SwingUtilities.invokeLater(() -> {
            BrowserView view = BrowserView.newInstance(browser);
            JFrame frame = new JFrame();
            frame.add((Component)view, "Center");
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    SwingUtilities.invokeLater(() -> ((Browser)browser).close());
                }
            });
            DefaultOpenPopupCallback.updateBounds(frame, params.initialBounds());
            browser.on(TitleChanged.class, event -> SwingUtilities.invokeLater(() -> frame.setTitle(event.title())));
            browser.on(BrowserClosed.class, event -> SwingUtilities.invokeLater(() -> {
                frame.setVisible(false);
                frame.dispose();
            }));
            browser.on(UpdateBoundsRequested.class, event -> DefaultOpenPopupCallback.updateBounds(frame, event.bounds()));
            frame.setVisible(true);
        });
        return OpenPopupCallback.Response.proceed();
    }

    private static void updateBounds(JFrame frame, Rect bounds) {
        if (GeometryUtil.isEmpty((Size)bounds.size())) {
            frame.setLocationByPlatform(true);
            frame.setSize(800, 600);
        } else {
            frame.setLocation(SwingUtil.toPoint(bounds.origin()));
            frame.setSize(SwingUtil.toDimension(bounds.size()));
        }
    }
}

