/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing.callback;

import com.teamdev.jxbrowser.browser.callback.OpenFilesCallback;
import com.teamdev.jxbrowser.view.swing.callback.AbstractDialogCallback;
import com.teamdev.jxbrowser.view.swing.internal.SwingUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;

public class DefaultOpenFilesCallback
extends AbstractDialogCallback
implements OpenFilesCallback {
    public DefaultOpenFilesCallback(JComponent parent) {
        super(parent);
    }

    public void on(OpenFilesCallback.Params params, OpenFilesCallback.Action tell) {
        SwingUtilities.invokeLater(() -> {
            JFileChooser fileChooser = new JFileChooser();
            SwingUtil.setupExtensionFilters(fileChooser, params.filterDescription(), params.acceptableExtensions());
            fileChooser.setMultiSelectionEnabled(true);
            if (fileChooser.showOpenDialog(this.getParent()) == 0) {
                Stream<Path> paths = Arrays.stream(fileChooser.getSelectedFiles()).map(File::toPath);
                tell.open((Path[])paths.toArray(Path[]::new));
            } else {
                tell.cancel();
            }
        });
    }
}

