/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.callback.AlertCallback;
import com.teamdev.jxbrowser.browser.callback.BeforeFormRepostCallback;
import com.teamdev.jxbrowser.browser.callback.BeforeUnloadCallback;
import com.teamdev.jxbrowser.browser.callback.BrowserCallback;
import com.teamdev.jxbrowser.browser.callback.ConfirmCallback;
import com.teamdev.jxbrowser.browser.callback.CreatePopupCallback;
import com.teamdev.jxbrowser.browser.callback.OpenFileCallback;
import com.teamdev.jxbrowser.browser.callback.OpenFilesCallback;
import com.teamdev.jxbrowser.browser.callback.OpenFolderCallback;
import com.teamdev.jxbrowser.browser.callback.OpenPopupCallback;
import com.teamdev.jxbrowser.browser.callback.PrintCallback;
import com.teamdev.jxbrowser.browser.callback.PromptCallback;
import com.teamdev.jxbrowser.browser.callback.SaveAsPdfCallback;
import com.teamdev.jxbrowser.browser.callback.SelectClientCertificateCallback;
import com.teamdev.jxbrowser.browser.callback.SelectColorCallback;
import com.teamdev.jxbrowser.browser.callback.ShowContextMenuCallback;
import com.teamdev.jxbrowser.browser.event.BrowserClosed;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.download.Downloads;
import com.teamdev.jxbrowser.download.callback.DownloadsCallback;
import com.teamdev.jxbrowser.download.callback.StartDownloadCallback;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.swing.DragAndDrop;
import com.teamdev.jxbrowser.view.swing.callback.DefaultAlertCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultBeforeFormRepostCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultBeforeUnloadCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultConfirmCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenFileCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenFilesCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenFolderCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultOpenPopupCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultPrintCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultPromptCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultSaveAsPdfCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultSelectClientCertificateCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultSelectColorCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultShowContextMenuCallback;
import com.teamdev.jxbrowser.view.swing.callback.DefaultStartDownloadCallback;
import com.teamdev.jxbrowser.view.swing.internal.Graphics2dBrowserWidget;
import com.teamdev.jxbrowser.view.swing.internal.HeavyweightBrowserWidget;
import com.teamdev.jxbrowser.view.swing.internal.IoSurfaceBrowserWidget;
import com.teamdev.jxbrowser.view.swing.internal.Widget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class BrowserView
extends JComponent {
    private final Browser browser;
    private final DragAndDrop dragAndDrop;
    private Subscription onBrowserClosed;
    private Widget widget;

    public static BrowserView newInstance(Browser browser) {
        return new BrowserView(browser);
    }

    private BrowserView(Browser browser) {
        Preconditions.checkNotNull((Object)browser);
        this.browser = browser;
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(800, 600));
        if (browser instanceof BrowserImpl) {
            this.widget = this.createBrowserWidget((BrowserImpl)browser);
            this.addWidget(this.widget.asComponent());
            this.onBrowserClosed = browser.on(BrowserClosed.class, event -> {
                this.removeWidget(this.widget.asComponent());
                this.unregisterDefaultBrowserCallbacks();
                this.onBrowserClosed.unsubscribe();
            });
        }
        this.dragAndDrop = new DragAndDropSupport();
        this.registerDefaultCallbacks();
    }

    private void removeWidget(JComponent widget) {
        SwingUtilities.invokeLater(() -> {
            this.remove(widget);
            this.validate();
            this.repaint();
        });
    }

    private void addWidget(JComponent widget) {
        SwingUtilities.invokeLater(() -> {
            this.add((Component)widget, "Center");
            this.validate();
            this.repaint();
        });
    }

    private void registerDefaultCallbacks() {
        this.registerDefaultCallback(CreatePopupCallback.class, params -> CreatePopupCallback.Response.create());
        this.registerDefaultCallback(OpenPopupCallback.class, new DefaultOpenPopupCallback());
        this.registerDefaultCallback(AlertCallback.class, new DefaultAlertCallback(this));
        this.registerDefaultCallback(ConfirmCallback.class, new DefaultConfirmCallback(this));
        this.registerDefaultCallback(PromptCallback.class, new DefaultPromptCallback(this));
        this.registerDefaultCallback(OpenFileCallback.class, new DefaultOpenFileCallback(this));
        this.registerDefaultCallback(OpenFilesCallback.class, new DefaultOpenFilesCallback(this));
        this.registerDefaultCallback(OpenFolderCallback.class, new DefaultOpenFolderCallback(this));
        this.registerDefaultCallback(SaveAsPdfCallback.class, new DefaultSaveAsPdfCallback(this));
        this.registerDefaultCallback(SelectColorCallback.class, new DefaultSelectColorCallback(this));
        this.registerDefaultCallback(BeforeUnloadCallback.class, new DefaultBeforeUnloadCallback(this));
        this.registerDefaultCallback(SelectClientCertificateCallback.class, new DefaultSelectClientCertificateCallback(this));
        this.registerDefaultCallback(BeforeFormRepostCallback.class, new DefaultBeforeFormRepostCallback(this));
        this.registerDefaultCallback(PrintCallback.class, new DefaultPrintCallback());
        this.registerDefaultCallback(ShowContextMenuCallback.class, new DefaultShowContextMenuCallback(this));
        this.registerDefaultCallback(StartDownloadCallback.class, new DefaultStartDownloadCallback(this));
    }

    private void unregisterDefaultBrowserCallbacks() {
        this.browser.remove(CreatePopupCallback.class);
        this.browser.remove(OpenPopupCallback.class);
        this.browser.remove(AlertCallback.class);
        this.browser.remove(ConfirmCallback.class);
        this.browser.remove(PromptCallback.class);
        this.browser.remove(OpenFileCallback.class);
        this.browser.remove(OpenFilesCallback.class);
        this.browser.remove(OpenFolderCallback.class);
        this.browser.remove(SaveAsPdfCallback.class);
        this.browser.remove(SelectColorCallback.class);
        this.browser.remove(BeforeUnloadCallback.class);
        this.browser.remove(SelectClientCertificateCallback.class);
        this.browser.remove(BeforeFormRepostCallback.class);
        this.browser.remove(PrintCallback.class);
        this.browser.remove(ShowContextMenuCallback.class);
    }

    private <T extends BrowserCallback> void registerDefaultCallback(Class<T> callbackClass, T callback) {
        if (!this.browser.get(callbackClass).isPresent()) {
            this.browser.set(callbackClass, callback);
        }
    }

    private <T extends DownloadsCallback> void registerDefaultCallback(Class<T> callbackClass, T callback) {
        Downloads downloads = this.browser.engine().downloads();
        if (!downloads.get(callbackClass).isPresent()) {
            downloads.set(callbackClass, callback);
        }
    }

    private Widget createBrowserWidget(BrowserImpl browser) {
        RenderingMode renderingMode = browser.engine().options().renderingMode();
        if (Environment.isMac()) {
            if (renderingMode == RenderingMode.OFF_SCREEN) {
                return new Graphics2dBrowserWidget(browser);
            }
            if (renderingMode == RenderingMode.HARDWARE_ACCELERATED) {
                return new IoSurfaceBrowserWidget(browser);
            }
        }
        if (Environment.isWindows() || Environment.isLinux()) {
            if (renderingMode == RenderingMode.OFF_SCREEN) {
                return new Graphics2dBrowserWidget(browser);
            }
            if (renderingMode == RenderingMode.HARDWARE_ACCELERATED) {
                return new HeavyweightBrowserWidget(browser);
            }
        }
        throw new IllegalStateException("Unsupported operating system");
    }

    public Browser getBrowser() {
        return this.browser;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.widget != null) {
            this.widget.asComponent().requestFocus();
        }
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        if (this.widget != null) {
            return this.widget.asComponent().requestFocus(temporary);
        }
        return super.requestFocus(temporary);
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.widget != null) {
            return this.widget.asComponent().requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.widget != null) {
            this.widget.asComponent().setEnabled(enabled);
        }
    }

    public DragAndDrop dragAndDrop() {
        return this.dragAndDrop;
    }

    private class DragAndDropSupport
    implements DragAndDrop {
        private DragAndDropSupport() {
        }

        @Override
        public void enable() {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if (BrowserView.this.browser instanceof BrowserImpl) {
                ((BrowserImpl)BrowserView.this.browser).dragAndDrop().enable();
            }
            if (BrowserView.this.widget != null) {
                BrowserView.this.widget.enableDragAndDrop();
            }
        }

        @Override
        public void disable() {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if (BrowserView.this.widget != null) {
                BrowserView.this.widget.disableDragAndDrop();
            }
            if (BrowserView.this.browser instanceof BrowserImpl) {
                ((BrowserImpl)BrowserView.this.browser).dragAndDrop().disable();
            }
        }

        @Override
        public boolean isEnabled() {
            if (GraphicsEnvironment.isHeadless()) {
                return false;
            }
            if (BrowserView.this.browser instanceof BrowserImpl) {
                return ((BrowserImpl)BrowserView.this.browser).dragAndDrop().isEnabled();
            }
            return false;
        }
    }
}

