/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.swing;

import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.ui.Bitmap;
import com.teamdev.jxbrowser.ui.Size;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public final class BitmapUtil {
    public static BufferedImage toBufferedImage(Bitmap bitmap) {
        Preconditions.checkNotNull((Object)bitmap);
        Preconditions.checkArgument((!bitmap.size().isEmpty() ? 1 : 0) != 0, (String)"Bitmap size cannot be empty");
        Size size = bitmap.size();
        int width = size.width();
        int height = size.height();
        WritableRaster raster = Raster.createInterleavedRaster(0, width, height, width * 4, 4, new int[]{2, 1, 0, 3}, null);
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, true, 3, 0);
        DataBufferByte dataBuffer = (DataBufferByte)raster.getDataBuffer();
        byte[] pixels = bitmap.pixels();
        System.arraycopy(pixels, 0, dataBuffer.getData(), 0, pixels.length);
        return new BufferedImage(colorModel, raster, true, new Hashtable());
    }

    private BitmapUtil() {
    }
}

