/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.iconfonts;

import de.javasoft.iconfonts.FontIcon;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public interface IconChar {
    public static final Map<Class<? extends IconChar>, Map<Float, Font>> FONT_CACHE = new HashMap<Class<? extends IconChar>, Map<Float, Font>>();

    public char getChar();

    public Font createFont();

    public static Icon createIcon(IconChar iconChar, float size) {
        return IconChar.createIcon(iconChar, size, null);
    }

    public static Icon createIcon(IconChar iconChar, float size, Color color) {
        return new FontIcon(iconChar, size, color);
    }

    public static Image createImage(IconChar iconChar, float size) {
        return IconChar.createImage(iconChar, size, null);
    }

    public static Image createImage(IconChar iconChar, float size, Color color) {
        return IconChar.createImage(iconChar.getChar(), IconChar.getFont(iconChar, size), color);
    }

    public static BufferedImage createImage(char chr, Font font, Color color) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        GlyphVector v = font.createGlyphVector(frc, new char[]{chr});
        Rectangle r = font.getStringBounds(String.valueOf(chr), frc).getBounds();
        BufferedImage img = new BufferedImage(r.width, r.height, 2);
        Graphics2D g2 = img.createGraphics();
        g2.setColor(color == null ? SyntheticaLookAndFeel.getColor((String)"Label.foreground", null) : color);
        g2.drawGlyphVector(v, 0.0f, r.height - g2.getFontMetrics(font).getDescent());
        g2.dispose();
        return img;
    }

    public static Font getFont(IconChar iconChar, float size) {
        Font font;
        Class<?> clazz = iconChar.getClass();
        Map<Float, Font> fontsBySize = FONT_CACHE.get(clazz);
        if (fontsBySize == null) {
            fontsBySize = new HashMap<Float, Font>();
            FONT_CACHE.put(clazz, fontsBySize);
            if (SyntheticaAddons.getVersion().getMajor() < 3) {
                String message = "<html>A version <b>SyntheticaAddons</b> version conflict has been detected.<br>Please contact the <b>Support Center</b><br> and post your License Registration Number.";
                String title = "SyntheticaAddons License Warning";
                Window w = FocusManager.getCurrentManager().getActiveWindow();
                JOptionPane.showMessageDialog(w, message, title, 2);
            }
        }
        if ((font = fontsBySize.get(Float.valueOf(size))) == null) {
            Font f = fontsBySize.size() == 0 ? iconChar.createFont() : (Font)fontsBySize.values().toArray()[0];
            font = f.deriveFont(size);
            fontsBySize.put(Float.valueOf(size), font);
        }
        return font;
    }
}

