/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.iconfonts;

import de.javasoft.iconfonts.IconChar;
import de.javasoft.plaf.synthetica.Scalable;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;

public class FontIcon
implements Icon,
Scalable {
    protected Font font;
    protected GlyphVector v;
    protected Color color;
    protected char chr;
    private Rectangle r;

    public FontIcon(String className, String iconName, Float size, Color color) throws ClassNotFoundException {
        this((IconChar)Enum.valueOf(Class.forName(className), iconName), size.floatValue(), color);
    }

    public FontIcon(IconChar iconChar, float size, Color color) {
        this.font = IconChar.getFont(iconChar, SyntheticaLookAndFeel.getInstance().scaleFontSize(size));
        this.chr = iconChar.getChar();
        this.color = color == null ? SyntheticaLookAndFeel.getColor((String)"Label.foreground", null) : color;
    }

    @Override
    public int getIconHeight() {
        if (this.r == null) {
            this.r = this.getBounds();
        }
        return this.r.height;
    }

    @Override
    public int getIconWidth() {
        if (this.r == null) {
            this.r = this.getBounds();
        }
        return this.r.width;
    }

    private Rectangle getBounds() {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        this.v = this.font.createGlyphVector(frc, new char[]{this.chr});
        this.r = this.font.getStringBounds(String.valueOf(this.chr), frc).getBounds();
        return this.r;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.color);
        g2.drawGlyphVector(this.v, x, y + this.getIconHeight() - g2.getFontMetrics(this.font).getDescent());
    }
}

