/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class ResourceBundleUtils {
    public static ResourceBundle loadResourceBundle(Class<?> clazz, Locale locale, String packageName) {
        String bundleName = String.valueOf(packageName) + "/" + clazz.getSimpleName();
        return ResourceBundle.getBundle(bundleName, locale, clazz.getModule());
    }

    public static void addResourceBundleToDefaults(ResourceBundle resBundle, boolean override) {
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration<String> enumeration = resBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            String value = resBundle.getString(key);
            if (!override && defaults.containsKey(key)) continue;
            defaults.put(key, value);
        }
    }

    public static String loadTextResource(String location) throws URISyntaxException, IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(ResourceBundleUtils.class.getResourceAsStream(location)));
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(String.valueOf(line) + "\n");
        }
        reader.close();
        return sb.toString();
    }
}

