/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaAddonsPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.syntheticaaddons.SystemMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.plaf.synth.SynthContext;

public class SystemMonitorPainter
extends SyntheticaAddonsPainter {
    public static SystemMonitorPainter getInstance() {
        return SystemMonitorPainter.getInstance(null);
    }

    public static SystemMonitorPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(SystemMonitorPainter.getPainterClassName((SynthContext)sc, SystemMonitorPainter.class, (String)"Synthetica.SystemMonitorPainter"));
        if (instance == null) {
            instance = SystemMonitorPainter.getInstance((SynthContext)sc, SystemMonitorPainter.class, (String)"Synthetica.SystemMonitorPainter");
        }
        return (SystemMonitorPainter)instance;
    }

    public void paintSystemMonitorBorder(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        String imagePath = this.resolveImagePath("Synthetica.systemMonitor.border.image", c);
        Insets dInsets = sInsets = this.getImageInsets("Synthetica.systemMonitor.border.insets", c);
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.drawBorder();
    }

    public void paintSystemMonitorBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        SystemMonitor sm = (SystemMonitor)c;
        if (((Boolean)SyntheticaLookAndFeel.getClientProperty((String)"Synthetica.opaque", (JComponent)sm, (Object)true)).booleanValue() || c.getParent() instanceof SystemMonitor.MonitorPopup) {
            g.setColor(c.getBackground());
            g.fillRect(x, y, w, h);
        }
        int gridSize = SyntheticaLookAndFeel.getInt((String)"Synthetica.systemMonitor.grid.size", (Component)sm);
        if (sm.getGridSize() != null) {
            gridSize = sm.getGridSize();
        }
        if (gridSize > 0) {
            g.setColor(sm.getGridColor());
            int x1 = x + w - 1;
            while (x1 > x) {
                g.drawLine(x1, y, x1, y + h - 1);
                x1 -= gridSize;
            }
            int y1 = y + h - 1;
            while (y1 > y) {
                g.drawLine(x, y1, x + w - 1, y1);
                y1 -= gridSize;
            }
        }
    }

    public void paintSystemMonitorForeground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        SystemMonitor sm = (SystemMonitor)c;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int gradientStartAlpha = SyntheticaLookAndFeel.getInt((String)"Synthetica.systemMonitor.gradient.start.alpha", (Component)sm);
        if (sm.getGradientStartAlpha() != null) {
            gradientStartAlpha = sm.getGradientStartAlpha();
        }
        int gradientEndAlpha = SyntheticaLookAndFeel.getInt((String)"Synthetica.systemMonitor.gradient.end.alpha", (Component)sm);
        if (sm.getGradientEndAlpha() != null) {
            gradientEndAlpha = sm.getGradientEndAlpha();
        }
        for (String key : sm.getModel().getIds()) {
            int i;
            if (!sm.getVisible(key)) continue;
            List<Float> values = sm.getModel().getValues(key);
            int size = values.size();
            int bufferSize = sm.getModel().getBufferSize(key);
            int[] xArr = new int[Math.min(size + 2, w + 2)];
            int[] yArr = new int[Math.min(size + 2, w + 2)];
            int xStart = x;
            int yStart = y + h - 1;
            int xEnd = x + w - 1;
            int yEnd = y + h - 1;
            if (size < w) {
                if (size < bufferSize) {
                    xArr[0] = xStart = x + w - size;
                    xArr[size + 1] = xEnd;
                    i = 1;
                    while (i <= size) {
                        xArr[i] = xStart + i - 1;
                        ++i;
                    }
                } else {
                    xArr[0] = xStart;
                    xArr[size + 1] = xEnd;
                    i = 1;
                    while (i <= size) {
                        xArr[i] = x + w * i / size - 1;
                        ++i;
                    }
                    xArr[1] = xStart;
                }
                yArr[0] = yStart;
                yArr[size + 1] = yEnd;
                i = 1;
                for (float value : values) {
                    yArr[i++] = Math.max(y + h - 1 - (int)(value * (float)h), y);
                }
            } else {
                xArr[0] = xStart;
                xArr[w + 1] = xEnd;
                i = 1;
                while (i <= w) {
                    xArr[i] = x + i - 1;
                    ++i;
                }
                yArr[0] = yEnd;
                yArr[w + 1] = yEnd;
                i = 1;
                int j = size - w;
                while (j < size) {
                    yArr[i++] = Math.max(y + h - 1 - (int)(values.get(j).floatValue() * (float)h), y);
                    ++j;
                }
            }
            Color color = sm.getModel().getColor(key);
            if (color == null) {
                color = sm.getForeground();
            }
            Color gradientStart = new Color(color.getRed(), color.getGreen(), color.getBlue(), gradientStartAlpha);
            Color gradientEnd = new Color(color.getRed(), color.getGreen(), color.getBlue(), gradientEndAlpha);
            g2.setPaint(new GradientPaint(x, y, gradientStart, y, y + h, gradientEnd));
            g2.fillPolygon(xArr, yArr, xArr.length);
            g2.setColor(color);
            g2.drawPolygon(xArr, yArr, xArr.length);
        }
    }

    public void paintSystemMonitorSpotlight(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        SystemMonitor sm = (SystemMonitor)c;
        if (sm.getSpotlightEnabled()) {
            String imagePath = this.resolveImagePath("Synthetica.systemMonitor.spotlight.image", sm);
            Insets sInsets = this.getImageInsets("Synthetica.systemMonitor.spotlight.insets", sm);
            if (w < 100 || h < 100) {
                w = h = Math.min(w, h);
                sInsets = new Insets(0, 0, 0, 0);
            }
            Insets dInsets = sInsets;
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
    }
}

