/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui.painter;

import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaAddonsPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.util.DropShadow;
import de.javasoft.syntheticaaddons.MultiLevelBar;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class MultiLevelBarPainter
extends SyntheticaAddonsPainter {
    public static MultiLevelBarPainter getInstance() {
        return MultiLevelBarPainter.getInstance(null);
    }

    public static MultiLevelBarPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(MultiLevelBarPainter.getPainterClassName((SynthContext)sc, MultiLevelBarPainter.class, (String)"Synthetica.MultiLevelBarPainter"));
        if (instance == null) {
            instance = MultiLevelBarPainter.getInstance((SynthContext)sc, MultiLevelBarPainter.class, (String)"Synthetica.MultiLevelBarPainter");
        }
        return (MultiLevelBarPainter)instance;
    }

    public void paintMultiLevelBar(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        MultiLevelBar bar = (MultiLevelBar)c;
        int maxLevel = bar.getLevelByName(c.getClass().getName()).getLevel();
        for (MultiLevelBar.BarLevel barLevel : bar.getLevels()) {
            Insets sInsets;
            int width = w * barLevel.getLevel() / maxLevel;
            if (width < (barLevel.getInsets().left + barLevel.getInsets().right) / 2) continue;
            String imagePath = barLevel.getImagePath();
            Insets dInsets = sInsets = barLevel.getInsets();
            ImagePainter imagePainter = new ImagePainter(g, x, y, width, h, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.draw();
        }
        g.setColor(c.getForeground());
        Font font = g.getFont();
        if (font instanceof FontUIResource) {
            g.setFont(font.deriveFont(1));
        }
        Insets textInsets = bar.getTextInsets();
        int va = bar.getVerticalAlignment();
        int ha = bar.getHorizontalAlignment();
        if (va == 1) {
            y += textInsets.top;
        } else if (va == 3) {
            h -= textInsets.bottom;
        }
        if (ha == 2) {
            x += textInsets.left;
        } else if (ha == 4) {
            w -= textInsets.right;
        }
        Rectangle viewRectangle = new Rectangle(x, y, w, h);
        Rectangle iconRectangle = new Rectangle();
        Rectangle textRectangle = new Rectangle();
        SwingUtilities.layoutCompoundLabel(g.getFontMetrics(), bar.getText(), null, va, ha, 0, 4, viewRectangle, iconRectangle, textRectangle, 0);
        if (bar.getUseTextDropShadow()) {
            BufferedImage image = new BufferedImage(w, h, 2);
            Graphics2D g2 = image.createGraphics();
            g2.setFont(g.getFont());
            ((Graphics)g2).drawString(bar.getText(), 0, g.getFontMetrics().getAscent());
            g2.dispose();
            DropShadow ds = new DropShadow(image);
            ds.paintShadow(g, textRectangle.x, textRectangle.y);
        }
        SynthStyle ss = SynthLookAndFeel.getStyle(bar, Region.PANEL);
        SynthContext sc = new SynthContext(bar, Region.PANEL, ss, 0);
        ss.getGraphicsUtils(sc).paintText(sc, g, bar.getText(), textRectangle, -1);
    }
}

